/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractDatastorePlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.tasks.IProcessingPluginTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import eu.basysbio.cisd.dss.HeaderUtils;
import java.io.File;
import java.util.List;
import java.util.Properties;

public class TimeSeriesPropertiesUpdateProcessingPlugin
extends AbstractDatastorePlugin
implements IProcessingPluginTask {
    private static final long serialVersionUID = 1L;

    public TimeSeriesPropertiesUpdateProcessingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    public ProcessingStatus process(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        ProcessingStatus result = new ProcessingStatus();
        for (DatasetDescription dataset : datasets) {
            Status status = this.processDataset(context.getDirectoryProvider(), dataset);
            result.addDatasetStatus(dataset, status);
        }
        return result;
    }

    private Status processDataset(IDataSetDirectoryProvider directoryProvider, DatasetDescription dataset) {
        try {
            File file = this.getDataSubDir(directoryProvider, dataset);
            List<NewProperty> newProperties = HeaderUtils.extractHeaderProperties(file, true);
            SpaceIdentifier space = new SpaceIdentifier(dataset.getDatabaseInstanceCode(), dataset.getSpaceCode());
            ServiceProvider.getOpenBISService().updateDataSet(dataset.getDataSetCode(), newProperties, space);
            return Status.OK;
        }
        catch (UserFailureException ex) {
            return Status.createError((String)ex.getMessage());
        }
    }
}

