/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.etlserver.SimpleTypeExtractor;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LocatorType;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Properties;

public class TypeExtractor
implements ITypeExtractor {
    static final String DATA_TYPE = ".data.txt";
    private final SimpleTypeExtractor extractor;

    public TypeExtractor(Properties properties) {
        this.extractor = new SimpleTypeExtractor(properties);
    }

    public final DataSetType getDataSetType(File incomingDataSetPath) {
        if (!incomingDataSetPath.isDirectory()) {
            throw new UserFailureException("Data set should be a folder: " + incomingDataSetPath.getAbsolutePath());
        }
        String[] files = incomingDataSetPath.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(TypeExtractor.DATA_TYPE);
            }
        });
        if (files.length != 1) {
            throw new UserFailureException("Exactly one file of type '.data.txt' expected instead of " + files.length + ".");
        }
        DataSetType dataSetType = new DataSetType();
        dataSetType.setCode(files[0].substring(0, files[0].length() - DATA_TYPE.length()));
        return dataSetType;
    }

    public final FileFormatType getFileFormatType(File incomingDataSetPath) {
        return this.extractor.getFileFormatType(incomingDataSetPath);
    }

    public final LocatorType getLocatorType(File incomingDataSetPath) {
        return this.extractor.getLocatorType(incomingDataSetPath);
    }

    public String getProcessorType(File incomingDataSetPath) {
        return this.extractor.getProcessorType(incomingDataSetPath);
    }

    public boolean isMeasuredData(File incomingDataSetPath) {
        return this.extractor.isMeasuredData(incomingDataSetPath);
    }
}

