/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.dss.bundle.registrators;

import ch.systemsx.cisd.etlserver.IDataSetHandlerRpc;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypeWithVocabularyTerms;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;

public class BundleRegistrationState {
    private final IDataSetHandlerRpc delegator;
    private final SessionContextDTO sessionContext;
    private final IEncapsulatedOpenBISService openbisService;
    private final SampleType gridPrepSampleType;
    private final SampleType replicaSampleType;
    private final DataSetTypeWithVocabularyTerms rawImagesDataSetType;
    private final DataSetTypeWithVocabularyTerms metadataDataSetType;
    private final DataSetTypeWithVocabularyTerms imageDataSetType;

    public BundleRegistrationState(IDataSetHandlerRpc delegator, IEncapsulatedOpenBISService openbisService) {
        this.delegator = delegator;
        this.sessionContext = delegator.getSessionContext();
        this.openbisService = openbisService;
        this.gridPrepSampleType = openbisService.getSampleType("GRID_PREP");
        this.replicaSampleType = openbisService.getSampleType("GRID_REPLICA");
        this.rawImagesDataSetType = openbisService.getDataSetType("RAW_IMAGES");
        this.metadataDataSetType = openbisService.getDataSetType("METADATA");
        this.imageDataSetType = openbisService.getDataSetType("IMAGE");
    }

    IDataSetHandlerRpc getDelegator() {
        return this.delegator;
    }

    SessionContextDTO getSessionContext() {
        return this.sessionContext;
    }

    IEncapsulatedOpenBISService getOpenbisService() {
        return this.openbisService;
    }

    SampleType getGridPrepSampleType() {
        return this.gridPrepSampleType;
    }

    SampleType getReplicaSampleType() {
        return this.replicaSampleType;
    }

    DataSetTypeWithVocabularyTerms getRawImagesDataSetType() {
        return this.rawImagesDataSetType;
    }

    DataSetTypeWithVocabularyTerms getMetadataDataSetType() {
        return this.metadataDataSetType;
    }

    DataSetTypeWithVocabularyTerms getImageDataSetType() {
        return this.imageDataSetType;
    }
}

