/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.shared.metadata;

import ch.systemsx.cisd.cina.shared.labview.LVData;
import ch.systemsx.cisd.cina.shared.labview.LVDataParser;
import ch.systemsx.cisd.cina.shared.metadata.CollectionMetadataExtractor;
import ch.systemsx.cisd.cina.shared.metadata.LabViewXMLToHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BundleMetadataExtractor {
    private static final String COLLECTIONS_FOLDER_NAME = "Collections";
    private static final String METADATA_FOLDER_NAME = "Annotations";
    private static final String BUNDLE_METADATA_FILE_NAME = "CollectionMetadata.xml";
    private static final String BUNDLE_METADATA_FOLDER_NAME = "Annotations";
    private static final String GRID_PREP_SAMPLE_CODE_KEY = "database id";
    private final ArrayList<CollectionMetadataExtractor> replicaMetadataExtractors;
    private final File bundleMetadataFile;
    private final HashMap<String, String> metadataMap;
    private final File bundle;
    private LVData lvdata;
    private boolean hasBeenPrepared = false;

    public BundleMetadataExtractor(File bundle) {
        this.bundle = bundle;
        this.replicaMetadataExtractors = new ArrayList();
        this.bundleMetadataFile = new File(new File(bundle, "Annotations"), BUNDLE_METADATA_FILE_NAME);
        this.metadataMap = new HashMap();
    }

    public void prepare() {
        if (this.hasBeenPrepared) {
            return;
        }
        this.parseBundleMetadata();
        this.prepareReplicaMetadataExtractors();
        this.hasBeenPrepared = true;
    }

    public List<CollectionMetadataExtractor> getReplicaMetadataExtractors() {
        this.checkPrepared();
        return this.replicaMetadataExtractors;
    }

    public String tryGridPrepSampleCode() {
        this.checkPrepared();
        return this.metadataMap.get(GRID_PREP_SAMPLE_CODE_KEY);
    }

    private void processDirectory(File file) {
        File annotationsDirectory = new File(file, "Annotations");
        if (!annotationsDirectory.exists()) {
            return;
        }
        if (!annotationsDirectory.isDirectory()) {
            return;
        }
        if (!CollectionMetadataExtractor.doesFolderContainReplicaMetadata(annotationsDirectory)) {
            return;
        }
        CollectionMetadataExtractor replicaMetadataExtractor = new CollectionMetadataExtractor(annotationsDirectory);
        replicaMetadataExtractor.prepare();
        this.replicaMetadataExtractors.add(replicaMetadataExtractor);
    }

    private void checkPrepared() {
        assert (this.hasBeenPrepared);
    }

    private void prepareReplicaMetadataExtractors() {
        File[] replicaContents;
        File metadataFolder = new File(this.bundle, COLLECTIONS_FOLDER_NAME);
        File[] fileArray = replicaContents = metadataFolder.listFiles();
        int n = replicaContents.length;
        int n2 = 0;
        while (n2 < n) {
            File replicaFile = fileArray[n2];
            if (replicaFile.isDirectory()) {
                this.processDirectory(replicaFile);
            }
            ++n2;
        }
    }

    private void parseBundleMetadata() {
        this.lvdata = LVDataParser.parse(this.bundleMetadataFile);
        if (this.lvdata == null) {
            throw new IllegalArgumentException("Could not parse metadata in file " + this.bundleMetadataFile.getAbsolutePath());
        }
        new LabViewXMLToHashMap(this.lvdata, this.metadataMap).appendIntoMap();
    }
}

