/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.shared.metadata;

import ch.systemsx.cisd.cina.shared.labview.LVData;
import ch.systemsx.cisd.cina.shared.labview.LVDataParser;
import ch.systemsx.cisd.cina.shared.metadata.IMetadataExtractor;
import ch.systemsx.cisd.cina.shared.metadata.LabViewXMLToHashMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ImageMetadataExtractor
implements IMetadataExtractor {
    private final HashMap<String, String> metadataMap;
    private final File folder;
    private LVData lvdata;
    private static final String IMAGE_METADATA_FILE_NAME = "metadata.xml";
    private static final HashMap<String, String> prefixMap = new HashMap();

    static {
        prefixMap.put("Pixelsize (nm)", "Size");
        prefixMap.put("Dimension (px)", "Dimension");
    }

    public static boolean doesFolderContainImageMetadata(File folder) {
        File metadataFile = new File(folder, IMAGE_METADATA_FILE_NAME);
        return metadataFile.exists();
    }

    public ImageMetadataExtractor(Map<String, String> parentMetadataOrNull, File folder) {
        this.metadataMap = parentMetadataOrNull != null ? new HashMap<String, String>(parentMetadataOrNull) : new HashMap();
        this.folder = folder;
    }

    public void prepare() throws IllegalArgumentException {
        if (this.lvdata != null) {
            return;
        }
        if (!ImageMetadataExtractor.doesFolderContainImageMetadata(this.folder)) {
            throw new IllegalArgumentException("Folder " + this.folder + " is not an image metadata file");
        }
        File metadataFile = new File(this.folder, IMAGE_METADATA_FILE_NAME);
        this.lvdata = LVDataParser.parse(metadataFile);
        if (this.lvdata == null) {
            throw new IllegalArgumentException("Could not parse metadata in file " + metadataFile.getAbsolutePath());
        }
        new LabViewXMLToHashMap(this.lvdata, this.metadataMap, prefixMap).appendIntoMap();
    }

    @Override
    public Map<String, String> getMetadataMap() {
        this.checkPrepared();
        return this.metadataMap;
    }

    public File getFolder() {
        return this.folder;
    }

    public File getRepresentationsFolder() {
        return new File(this.folder, "Representations");
    }

    public File getLargeImageRepresentation() {
        return new File(this.getRepresentationsFolder(), "StandardPreview_large.png");
    }

    private void checkPrepared() {
        assert (this.lvdata != null);
    }
}

