/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.shared.metadata;

import ch.systemsx.cisd.cina.shared.labview.AbstractLVDataElement;
import ch.systemsx.cisd.cina.shared.labview.Cluster;
import ch.systemsx.cisd.cina.shared.labview.DBL;
import ch.systemsx.cisd.cina.shared.labview.EW;
import ch.systemsx.cisd.cina.shared.labview.LVData;
import ch.systemsx.cisd.cina.shared.labview.LVDataBoolean;
import ch.systemsx.cisd.cina.shared.labview.LVDataString;
import ch.systemsx.cisd.cina.shared.labview.U32;
import ch.systemsx.cisd.cina.shared.labview.U8;
import java.util.HashMap;
import java.util.Map;

class LabViewXMLToHashMap {
    private final LVData lvdata;
    private final Map<String, String> metadataMap;
    private final Map<String, String> prefixMap;

    LabViewXMLToHashMap(LVData lvdata, Map<String, String> metadataMap) {
        this(lvdata, metadataMap, new HashMap<String, String>());
    }

    public LabViewXMLToHashMap(LVData lvdata, Map<String, String> metadataMap, Map<String, String> prefixMap) {
        this.lvdata = lvdata;
        this.metadataMap = metadataMap;
        this.prefixMap = prefixMap;
    }

    public void appendIntoMap() {
        for (Cluster cluster : this.lvdata.getClusters()) {
            this.parseCluster(cluster, this.getClusterPrefix(cluster));
        }
    }

    private void parseCluster(Cluster cluster, String prefix) {
        for (LVDataString lvdataString : cluster.getStrings()) {
            this.putIntoMap(prefix, lvdataString, lvdataString.getValue());
        }
        for (U8 u8 : cluster.getU8s()) {
            this.putIntoMap(prefix, u8, u8.getValue().toString());
        }
        for (U32 u32 : cluster.getU32s()) {
            this.putIntoMap(prefix, u32, u32.getValue().toString());
        }
        for (DBL dbl : cluster.getDbls()) {
            this.putIntoMap(prefix, dbl, dbl.getValue().toString());
        }
        for (LVDataBoolean bool : cluster.getBooleans()) {
            this.putIntoMap(prefix, bool, bool.getValue().toString());
        }
        for (EW ew : cluster.getEws()) {
            this.putIntoMap(prefix, ew, ew.getChosenValue());
        }
        for (Cluster subcluster : cluster.getClusters()) {
            this.parseCluster(subcluster, this.getClusterPrefix(subcluster));
        }
    }

    private void putIntoMap(String prefix, AbstractLVDataElement lvdataElement, String string) {
        this.metadataMap.put((String.valueOf(prefix) + lvdataElement.getName()).toLowerCase(), string);
    }

    private String getClusterPrefix(Cluster cluster) {
        String clusterPrefix = this.prefixMap.get(cluster.getName());
        if (clusterPrefix == null) {
            clusterPrefix = "";
        }
        return clusterPrefix;
    }
}

