/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.imaging;

import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureValue;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureDefDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgFeatureVocabularyTermDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class FeatureVocabularyTermsMap {
    private final Map<Long, Map<Integer, FeatureValue>> featureDefToVocabularyTerms;
    private final Map<String, Long> featureCodeToIdMap;

    public static FeatureVocabularyTermsMap createVocabularyTermsMap(List<ImgFeatureVocabularyTermDTO> allTerms, Set<ImgFeatureDefDTO> datasetFeatureDefs) {
        Map<Long, List<ImgFeatureVocabularyTermDTO>> featureToTermsMap = FeatureVocabularyTermsMap.createFeatureToTermsMap(allTerms);
        return new FeatureVocabularyTermsMap(FeatureVocabularyTermsMap.createSequenceNumberMap(featureToTermsMap), FeatureVocabularyTermsMap.createFeatureCodeToIdMap(datasetFeatureDefs));
    }

    private static Map<String, Long> createFeatureCodeToIdMap(Set<ImgFeatureDefDTO> datasetFeatureDefs) {
        HashMap<String, Long> codeToIdMap = new HashMap<String, Long>();
        for (ImgFeatureDefDTO featureDef : datasetFeatureDefs) {
            codeToIdMap.put(featureDef.getCode(), featureDef.getId());
        }
        return codeToIdMap;
    }

    private static Map<Long, Map<Integer, FeatureValue>> createSequenceNumberMap(Map<Long, List<ImgFeatureVocabularyTermDTO>> featureToTermsMap) {
        HashMap<Long, Map<Integer, FeatureValue>> map = new HashMap<Long, Map<Integer, FeatureValue>>();
        for (Map.Entry<Long, List<ImgFeatureVocabularyTermDTO>> entry : featureToTermsMap.entrySet()) {
            Long featureDefId = entry.getKey();
            List<ImgFeatureVocabularyTermDTO> featureTerms = entry.getValue();
            HashMap<Integer, FeatureValue> sequenceToTermMap = new HashMap<Integer, FeatureValue>();
            for (ImgFeatureVocabularyTermDTO term : featureTerms) {
                FeatureValue vocabularyTermValue = FeatureValue.createVocabularyTerm(term.getCode());
                sequenceToTermMap.put(term.getSequenceNumber(), vocabularyTermValue);
            }
            map.put(featureDefId, sequenceToTermMap);
        }
        return map;
    }

    private static Map<Long, List<ImgFeatureVocabularyTermDTO>> createFeatureToTermsMap(List<ImgFeatureVocabularyTermDTO> allTerms) {
        HashMap<Long, List<ImgFeatureVocabularyTermDTO>> map = new HashMap<Long, List<ImgFeatureVocabularyTermDTO>>();
        for (ImgFeatureVocabularyTermDTO term : allTerms) {
            long featureDefId = term.getFeatureDefId();
            ArrayList<ImgFeatureVocabularyTermDTO> featureTerms = (ArrayList<ImgFeatureVocabularyTermDTO>)map.get(featureDefId);
            if (featureTerms == null) {
                featureTerms = new ArrayList<ImgFeatureVocabularyTermDTO>();
            }
            featureTerms.add(term);
            map.put(featureDefId, featureTerms);
        }
        return map;
    }

    private FeatureVocabularyTermsMap(Map<Long, Map<Integer, FeatureValue>> featureDefToVocabularyTerms, Map<String, Long> featureCodeToIdMap) {
        this.featureDefToVocabularyTerms = featureDefToVocabularyTerms;
        this.featureCodeToIdMap = featureCodeToIdMap;
    }

    public boolean hasVocabularyTerms(String featureCode) {
        Long featureId = this.featureCodeToIdMap.get(featureCode);
        if (featureId == null) {
            return false;
        }
        return this.hasVocabularyTerms(featureId);
    }

    public boolean hasVocabularyTerms(long featureDefId) {
        return this.featureDefToVocabularyTerms.get(featureDefId) != null;
    }

    public FeatureValue getVocabularyTerm(long featureDefId, int termSequenceNumber) {
        Map<Integer, FeatureValue> termsMap = this.featureDefToVocabularyTerms.get(featureDefId);
        assert (termsMap != null) : "Feature def " + featureDefId + " has no vocabulary terms";
        FeatureValue term = termsMap.get(termSequenceNumber);
        assert (term != null) : "Cannot find term " + termSequenceNumber + " for feature def " + featureDefId;
        return term;
    }
}

