/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.db.generic;

import ch.systemsx.cisd.yeastx.db.generic.DMExperimentDTO;
import ch.systemsx.cisd.yeastx.db.generic.DMSampleDTO;
import net.lemnik.eodsql.AutoGeneratedKeys;
import net.lemnik.eodsql.ResultColumn;

public class DMDataSetDTO {
    @AutoGeneratedKeys
    private long id;
    @ResultColumn(value="PERM_ID")
    private String permId;
    @ResultColumn(value="EXPE_ID")
    private long experimentId;
    @ResultColumn(value="SAMP_ID")
    private Long sampleId;
    private DMSampleDTO sampleOrNull;
    private DMExperimentDTO experimentOrNull;

    public DMDataSetDTO() {
    }

    public DMDataSetDTO(String dsPermId, String sampPermIdOrNull, String sampNameOrNull, String expePermId, String experimentName) {
        this.permId = dsPermId;
        DMExperimentDTO experiment = new DMExperimentDTO(expePermId);
        experiment.setName(experimentName);
        if (sampPermIdOrNull != null) {
            assert (sampNameOrNull != null) : "sample name must be given when sample permId is given";
            this.sampleOrNull = new DMSampleDTO(sampPermIdOrNull);
            this.sampleOrNull.setName(sampNameOrNull);
            this.sampleOrNull.setExperiment(experiment);
        } else {
            this.experimentOrNull = experiment;
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getPermId() {
        return this.permId;
    }

    public void setPermId(String permId) {
        this.permId = permId;
    }

    public long getExperimentId() {
        return this.experimentId;
    }

    public void setExperimentId(long experimentId) {
        this.experimentId = experimentId;
    }

    public Long getSampleId() {
        return this.sampleId;
    }

    public void setSampleId(Long sampleId) {
        this.sampleId = sampleId;
    }

    public DMSampleDTO getSample() {
        return this.sampleOrNull;
    }

    public void setSample(DMSampleDTO sample) {
        this.sampleOrNull = sample;
        this.sampleId = sample.getId();
        this.experimentId = sample.getExperimentId();
    }

    public DMExperimentDTO getExperiment() {
        if (this.sampleOrNull != null) {
            return this.sampleOrNull.getExperiment();
        }
        return this.experimentOrNull;
    }
}

