/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.db.generic;

import ch.systemsx.cisd.yeastx.db.generic.DMDataSetDTO;
import ch.systemsx.cisd.yeastx.db.generic.DMExperimentDTO;
import ch.systemsx.cisd.yeastx.db.generic.DMSampleDTO;
import ch.systemsx.cisd.yeastx.db.generic.IDMGenericDAO;

public class DMGenericUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDataSet(IDMGenericDAO dao, DMDataSetDTO dataSet) {
        Class<IDMGenericDAO> clazz = IDMGenericDAO.class;
        synchronized (IDMGenericDAO.class) {
            DMExperimentDTO experiment = DMGenericUtils.getOrCreateExperiment(dao, dataSet);
            dataSet.setExperimentId(experiment.getId());
            if (dataSet.getSample() != null) {
                String permId = dataSet.getSample().getPermId();
                DMSampleDTO sample = dao.getSampleByPermId(permId);
                if (sample == null) {
                    sample = dataSet.getSample();
                    sample.setExperiment(experiment);
                    sample = DMGenericUtils.createSample(dao, sample, permId);
                }
                sample.setExperiment(experiment);
                dataSet.setSample(sample);
            }
            dao.close(true);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            long dataSetId = dao.addDataSet(dataSet);
            dataSet.setId(dataSetId);
            return;
        }
    }

    private static DMSampleDTO createSample(IDMGenericDAO dao, DMSampleDTO sample, String samplePermId) {
        long sampleId = dao.addSample(sample);
        sample.setId(sampleId);
        return sample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DMExperimentDTO getOrCreateExperiment(IDMGenericDAO dao, DMDataSetDTO dataSet) {
        String permId = dataSet.getExperiment().getPermId();
        Class<IDMGenericDAO> clazz = IDMGenericDAO.class;
        synchronized (IDMGenericDAO.class) {
            DMExperimentDTO experiment = dao.getExperimentByPermId(permId);
            if (experiment == null) {
                experiment = DMGenericUtils.createExperiment(dao, dataSet, permId);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return experiment;
        }
    }

    private static DMExperimentDTO createExperiment(IDMGenericDAO dao, DMDataSetDTO dataSet, String permId) {
        DMExperimentDTO experiment = dataSet.getExperiment();
        long experimentId = dao.addExperiment(experiment);
        experiment.setId(experimentId);
        return experiment;
    }
}

