/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.eicml;

import ch.systemsx.cisd.yeastx.eicml.ChromatogramDTO;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.IOException;
import java.io.OutputStream;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class EICMLChromatogramImageGenerator {
    public static final ChartType DEFAULT_CHART_TYPE = ChartType.LINE;
    private final ChromatogramDTO chromatogram;
    private final OutputStream out;
    private final int imageWidth;
    private final int imageHeight;
    private final ChartType chartType;

    public EICMLChromatogramImageGenerator(ChromatogramDTO chromatogram, OutputStream out, int imageWidth, int imageHeight) {
        this(chromatogram, out, imageWidth, imageHeight, DEFAULT_CHART_TYPE);
    }

    public EICMLChromatogramImageGenerator(ChromatogramDTO chromatogram, OutputStream out, int imageWidth, int imageHeight, ChartType chartType) {
        this.chromatogram = chromatogram;
        this.out = out;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.chartType = chartType;
    }

    public void generateImage() throws IOException {
        JFreeChart chart = this.createChart(this.createDataset());
        ChartUtilities.writeChartAsPNG((OutputStream)this.out, (JFreeChart)chart, (int)this.imageWidth, (int)this.imageHeight);
    }

    private JFreeChart createChart(IntervalXYDataset dataset) {
        JFreeChart chart = null;
        switch (this.chartType) {
            case AREA: {
                chart = this.createAreaChart(dataset);
                break;
            }
            case BAR: {
                chart = this.createBarChart(dataset);
                break;
            }
            case LINE: {
                chart = this.createLineChart(dataset);
                break;
            }
            case SPLINE: {
                chart = this.createSplineChart(dataset);
            }
        }
        return chart;
    }

    private JFreeChart createBarChart(IntervalXYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYBarChart((String)this.chromatogram.getLabel(), (String)"Run Time", (boolean)false, (String)"Intensity", (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        XYPlot plot = this.configureChart(chart);
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYBarRenderer) {
            XYBarRenderer renderer = (XYBarRenderer)r;
            renderer.setShadowVisible(false);
        }
        return chart;
    }

    private JFreeChart createLineChart(IntervalXYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.chromatogram.getLabel(), (String)"run time", (String)"intensity", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.configureChart(chart);
        return chart;
    }

    private JFreeChart createSplineChart(IntervalXYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.chromatogram.getLabel(), (String)"run time", (String)"intensity", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        XYPlot plot = this.configureChart(chart);
        XYSplineRenderer renderer = new XYSplineRenderer();
        renderer.setSeriesShapesVisible(0, false);
        plot.setRenderer((XYItemRenderer)renderer);
        return chart;
    }

    private JFreeChart createAreaChart(IntervalXYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYAreaChart((String)this.chromatogram.getLabel(), (String)"run time", (String)"intensity", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        this.configureChart(chart);
        return chart;
    }

    private IntervalXYDataset createDataset() {
        XYSeries s1 = new XYSeries((Comparable)((Object)this.chromatogram.getLabel()));
        float[] runTimes = this.chromatogram.getRunTimes();
        float[] intensities = this.chromatogram.getIntensities();
        int i = 0;
        while (i < intensities.length) {
            s1.add((double)runTimes[i], (double)intensities[i]);
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(s1);
        return dataset;
    }

    private XYPlot configureChart(JFreeChart chart) {
        Font font = JFreeChart.DEFAULT_TITLE_FONT;
        chart.getTitle().setFont(this.cloneFontWithNewSize(font, Math.max(11, this.imageHeight / 30)));
        chart.setBackgroundPaint((Paint)Color.WHITE);
        XYPlot plot = (XYPlot)chart.getPlot();
        this.setAxisLabelFontSize((Axis)plot.getDomainAxis());
        this.setAxisLabelFontSize((Axis)plot.getRangeAxis());
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setDomainCrosshairVisible(false);
        plot.setRangeCrosshairVisible(false);
        ValueAxis axis = plot.getDomainAxis();
        axis.setAutoRange(true);
        return plot;
    }

    private void setAxisLabelFontSize(Axis axis) {
        Font labelFont = axis.getLabelFont();
        axis.setLabelFont(this.cloneFontWithNewSize(labelFont, Math.max(10, this.imageHeight / 40)));
    }

    private Font cloneFontWithNewSize(Font font, int newSize) {
        return new Font(font.getName(), font.getStyle(), newSize);
    }

    public static enum ChartType {
        AREA,
        BAR,
        LINE,
        SPLINE;

    }
}

