/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.etl;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.yeastx.etl.DataSetMappingInformation;
import ch.systemsx.cisd.yeastx.etl.DataSetMappingInformationParser;
import ch.systemsx.cisd.yeastx.etl.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

class DatasetMappingUtil {
    private static final String[] MAPPING_FILE_EXTENSIONS = new String[]{"tsv"};

    DatasetMappingUtil() {
    }

    private static TableMap<String, DataSetMappingInformation> tryAsFileMap(List<DataSetMappingInformation> list, LogUtils log, File mappingFile) {
        IKeyExtractor<String, DataSetMappingInformation> extractor = new IKeyExtractor<String, DataSetMappingInformation>(){

            public String getKey(DataSetMappingInformation dataset) {
                return dataset.getFileName().toLowerCase();
            }
        };
        try {
            return new TableMap(list, (IKeyExtractor)extractor, TableMap.UniqueKeyViolationStrategy.ERROR);
        }
        catch (TableMap.UniqueKeyViolationException e) {
            log.mappingFileError(mappingFile, "the file '%s' appears more than once.", e.getInvalidKey());
            return null;
        }
    }

    public static DataSetMappingInformation tryGetDatasetMapping(File datasetFile, LogUtils log) {
        DataSetMappingInformationFile datasetsMappings = DatasetMappingUtil.tryGetDatasetsMapping(datasetFile.getParentFile(), log);
        if (datasetsMappings == null || datasetsMappings.tryGetMappings() == null) {
            return null;
        }
        return DatasetMappingUtil.tryGetDatasetMapping(datasetFile, datasetsMappings.tryGetMappings());
    }

    public static DataSetMappingInformation tryGetDatasetMapping(File datasetFile, TableMap<String, DataSetMappingInformation> datasetsMapping) {
        String datasetFileName = datasetFile.getName();
        return (DataSetMappingInformation)datasetsMapping.tryGet((Object)datasetFileName.toLowerCase());
    }

    private static String tryGetFirstLineCommentContent(File mappingFile, LogUtils log) {
        List<String> lines;
        try {
            lines = DatasetMappingUtil.readLines(mappingFile);
        }
        catch (IOException e) {
            Object[] arguments = new Object[]{};
            log.mappingFileError(mappingFile, e.getMessage(), arguments);
            return null;
        }
        if (lines.size() == 0) {
            return null;
        }
        String firstLine = lines.get(0);
        if (StringUtils.isBlank((String)firstLine)) {
            return null;
        }
        if (!(firstLine = firstLine.trim()).startsWith("#")) {
            return null;
        }
        firstLine = firstLine.substring(1).trim();
        return firstLine;
    }

    private static String tryGetEmail(File mappingFile, LogUtils log) {
        String email = DatasetMappingUtil.tryGetFirstLineCommentContent(mappingFile, log);
        if (email == null) {
            log.mappingFileError(mappingFile, "There should be a '%s' character followed by an email address in the first line of the file. The email is needed to send messages about errors.", "#");
            return null;
        }
        if (!email.contains("@") || !email.contains(".")) {
            log.mappingFileError(mappingFile, "The text '%s' does not seem to be an email address.", email);
            return null;
        }
        return email;
    }

    public static DataSetMappingInformationFile tryGetDatasetsMapping(File batchDir, LogUtils log) {
        File mappingFile = DatasetMappingUtil.tryGetMappingFile(batchDir, log);
        if (mappingFile == null) {
            return null;
        }
        String notificationEmail = DatasetMappingUtil.tryGetEmail(mappingFile, log);
        if (notificationEmail == null) {
            return null;
        }
        TableMap<String, DataSetMappingInformation> mappingsOrNull = null;
        List<DataSetMappingInformation> list = DataSetMappingInformationParser.tryParse(mappingFile, log);
        if (list != null) {
            mappingsOrNull = DatasetMappingUtil.tryAsFileMap(list, log, mappingFile);
        }
        return new DataSetMappingInformationFile(mappingsOrNull, notificationEmail);
    }

    public static boolean isMappingFile(File file) {
        String ext = FilenameUtils.getExtension((String)file.getName());
        String[] stringArray = MAPPING_FILE_EXTENSIONS;
        int n = MAPPING_FILE_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String mappingExt = stringArray[n2];
            if (mappingExt.equalsIgnoreCase(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isMappingFilePresent(File batchDir) {
        List<File> potentialMappingFiles = DatasetMappingUtil.listPotentialMappingFiles(batchDir);
        return potentialMappingFiles.size() > 0;
    }

    private static File tryGetMappingFile(File batchDir, LogUtils log) {
        List<File> potentialMappingFiles = DatasetMappingUtil.listPotentialMappingFiles(batchDir);
        String errorMsgPrefix = "No datasets from the directory '%s' can be processed because ";
        String batchDirName = batchDir.getName();
        if (potentialMappingFiles.size() == 0) {
            log.error(String.valueOf(errorMsgPrefix) + "there is no file with extension '%s' which contains dataset descriptions.", batchDirName, CollectionUtils.abbreviate((Object[])MAPPING_FILE_EXTENSIONS, (int)-1));
            return null;
        }
        if (potentialMappingFiles.size() > 1) {
            log.error(String.valueOf(errorMsgPrefix) + "there is more than one file with extension '%s'.", batchDirName, CollectionUtils.abbreviate((Object[])MAPPING_FILE_EXTENSIONS, (int)-1));
            return null;
        }
        File indexFile = potentialMappingFiles.get(0);
        if (!indexFile.isFile()) {
            log.error(String.valueOf(errorMsgPrefix) + "'%s' is not a file.", batchDirName, indexFile.getName());
            return null;
        }
        return indexFile;
    }

    private static List<File> listPotentialMappingFiles(File dataSet) {
        return FileUtilities.listFiles((File)dataSet, (String[])MAPPING_FILE_EXTENSIONS, (boolean)false, null);
    }

    public static boolean deleteMappingFile(File batchDir, LogUtils log) {
        File mappingFile = DatasetMappingUtil.tryGetMappingFile(batchDir, log);
        if (mappingFile != null && mappingFile.isFile()) {
            return mappingFile.delete();
        }
        return true;
    }

    public static void cleanMappingFile(File batchDir, Set<String> processedFiles, LogUtils log) {
        File mappingFile = DatasetMappingUtil.tryGetMappingFile(batchDir, log);
        if (mappingFile == null) {
            return;
        }
        try {
            List<String> lines = DatasetMappingUtil.readLines(mappingFile);
            ArrayList<String> unprocessedLines = new ArrayList<String>();
            for (String line : lines) {
                String[] tokens = line.trim().split("\t");
                if (tokens.length != 0 && processedFiles.contains(tokens[0].toLowerCase())) continue;
                unprocessedLines.add(line);
            }
            DatasetMappingUtil.writeLines(mappingFile, unprocessedLines);
        }
        catch (IOException ex) {
            log.mappingFileError(mappingFile, "cannot clean dataset mappings file: " + ex.getMessage(), new Object[0]);
        }
    }

    private static void writeLines(File file, List<String> lines) throws IOException, FileNotFoundException {
        FileOutputStream stream = new FileOutputStream(file);
        IOUtils.writeLines(lines, (String)"\n", (OutputStream)stream);
        IOUtils.closeQuietly((OutputStream)stream);
    }

    private static List<String> readLines(File mappingFile) throws IOException, FileNotFoundException {
        FileInputStream stream = new FileInputStream(mappingFile);
        List lines = IOUtils.readLines((InputStream)stream);
        IOUtils.closeQuietly((InputStream)stream);
        return lines;
    }

    static class DataSetMappingInformationFile {
        private final TableMap<String, DataSetMappingInformation> mappingsOrNull;
        private final String notificationEmail;

        public DataSetMappingInformationFile(TableMap<String, DataSetMappingInformation> mappingsOrNull, String notificationEmail) {
            this.mappingsOrNull = mappingsOrNull;
            this.notificationEmail = notificationEmail;
        }

        public TableMap<String, DataSetMappingInformation> tryGetMappings() {
            return this.mappingsOrNull;
        }

        public String getNotificationEmail() {
            return this.notificationEmail;
        }
    }
}

