/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Resolution;

@Entity
@Table(name="data_set_relationships", uniqueConstraints={@UniqueConstraint(columnNames={"data_id_parent", "data_id_child"})})
@IdClass(value=DataSetRelationshipId.class)
public class DataSetRelationshipPE
implements Serializable {
    private static final long serialVersionUID = 35L;
    private DataPE parentDataSet;
    private DataPE childDataSet;
    private PersonPE author;
    private Date registrationDate;
    private Date modificationDate;
    private DeletionPE deletion;

    private DataSetRelationshipPE() {
    }

    public DataSetRelationshipPE(DataPE parentDataSet, DataPE childDataSet, PersonPE author) {
        this.parentDataSet = parentDataSet;
        this.childDataSet = childDataSet;
        this.author = author;
    }

    @NotNull(message="Parent can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="data_id_parent")
    @Id
    public DataPE getParentDataSet() {
        return this.parentDataSet;
    }

    public void setParentDataSet(DataPE parentDataSet) {
        this.parentDataSet = parentDataSet;
    }

    @NotNull(message="Child can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="data_id_child")
    @Id
    public DataPE getChildDataSet() {
        return this.childDataSet;
    }

    public void setChildDataSet(DataPE childDataSet) {
        this.childDataSet = childDataSet;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pers_id_author")
    public PersonPE getAuthor() {
        return this.author;
    }

    public void setAuthor(PersonPE author) {
        this.author = author;
    }

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    @DateBridge(resolution=Resolution.SECOND)
    public Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Version
    @Column(name="modification_timestamp", nullable=false)
    @DateBridge(resolution=Resolution.SECOND)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="del_id")
    public DeletionPE getDeletion() {
        return this.deletion;
    }

    public void setDeletion(DeletionPE deletion) {
        this.deletion = deletion;
    }
}

