/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.hdf5;

import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntry;
import ch.systemsx.cisd.hdf5.h5ar.HDF5ArchiverFactory;
import ch.systemsx.cisd.hdf5.h5ar.IHDF5ArchiveReader;
import ch.systemsx.cisd.hdf5.h5ar.ListParameters;
import ch.systemsx.cisd.openbis.common.hdf5.IHDF5ContainerReader;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

final class HDF5ContainerReader
implements IHDF5ContainerReader {
    private static final long CACHE_CLEANER_INTERVAL_MILLIS = 60000L;
    private static final Map<File, Reader> fileToReaderMap;
    private static boolean noCaching;
    private final Reader reader;

    static {
        Timer t = new Timer("HDF5ContainerReader - Cache Cleaner", true);
        t.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = fileToReaderMap;
                synchronized (map) {
                    Iterator it = fileToReaderMap.values().iterator();
                    while (it.hasNext()) {
                        Reader container = (Reader)it.next();
                        if (!container.isExpired()) continue;
                        container.getArchiveReader().close();
                        it.remove();
                    }
                }
            }
        }, 60000L, 60000L);
        fileToReaderMap = new HashMap<File, Reader>();
        noCaching = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableCaching() {
        noCaching = true;
        Map<File, Reader> map = fileToReaderMap;
        synchronized (map) {
            for (Reader r : fileToReaderMap.values()) {
                r.getArchiveReader().close();
            }
            fileToReaderMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Reader openReader(File hdf5Container) {
        Reader entryOrNull;
        Map<File, Reader> map = fileToReaderMap;
        synchronized (map) {
            entryOrNull = fileToReaderMap.get(hdf5Container);
            if (entryOrNull == null) {
                entryOrNull = new Reader(hdf5Container, HDF5ArchiverFactory.openForReading((File)hdf5Container));
                fileToReaderMap.put(hdf5Container, entryOrNull);
            } else {
                entryOrNull.incCount();
            }
        }
        return entryOrNull;
    }

    HDF5ContainerReader(File hdf5Container) {
        this.reader = HDF5ContainerReader.openReader(hdf5Container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.reader.decCount();
        if (noCaching && this.reader.isUnreferenced()) {
            Map<File, Reader> map = fileToReaderMap;
            synchronized (map) {
                this.reader.getArchiveReader().close();
                fileToReaderMap.remove(this.reader.getArchiveFile());
            }
        }
    }

    @Override
    public boolean exists(String objectPath) {
        return this.reader.getArchiveReader().exists(objectPath);
    }

    @Override
    public ArchiveEntry tryGetEntry(String path) {
        return this.reader.getArchiveReader().tryGetResolvedEntry(path, true);
    }

    @Override
    public List<ArchiveEntry> getGroupMembers(String groupPath) {
        return this.reader.getArchiveReader().list(groupPath, ListParameters.build().nonRecursive().resolveSymbolicLinks().get());
    }

    @Override
    public void readFromHDF5Container(String objectPath, OutputStream ostream) {
        this.reader.getArchiveReader().extractFile(objectPath, ostream);
    }

    private static class Reader {
        private static final long RETENTION_TIME_MILLIS = 300000L;
        private final IHDF5ArchiveReader archiveReader;
        private final File archiveFile;
        private long lastAccessed;
        private int referenceCount;

        Reader(File archiveFile, IHDF5ArchiveReader archiveReader) {
            this.archiveFile = archiveFile;
            this.archiveReader = archiveReader;
            this.lastAccessed = System.currentTimeMillis();
            this.referenceCount = 1;
        }

        IHDF5ArchiveReader getArchiveReader() {
            this.lastAccessed = System.currentTimeMillis();
            return this.archiveReader;
        }

        File getArchiveFile() {
            return this.archiveFile;
        }

        void incCount() {
            ++this.referenceCount;
        }

        void decCount() {
            --this.referenceCount;
        }

        boolean isUnreferenced() {
            return this.referenceCount == 0;
        }

        boolean isExpired() {
            return this.referenceCount == 0 && System.currentTimeMillis() - this.lastAccessed > 300000L;
        }
    }
}

