/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.openbis.installer.izpack.AbstractDataValidator;
import ch.systemsx.cisd.openbis.installer.izpack.GlobalInstallationContext;
import ch.systemsx.cisd.openbis.installer.izpack.Utils;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DBConnectionValidator
extends AbstractDataValidator {
    private static final String DEFAULT_ERROR_MESSAGE = "Cannot connect to the specified database.";
    private static final String JDBC_DRIVER_NAME = "org.postgresql.Driver";
    private static final String CONNECTION_STRING = "jdbc:postgresql://localhost/template1";
    private static final String NO_PASSWORD = "";

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    public String getErrorMessageId() {
        if (this.getErrorMessage() != null) {
            return this.getErrorMessage();
        }
        return DEFAULT_ERROR_MESSAGE;
    }

    @Override
    public String getWarningMessageId() {
        return this.getErrorMessageId();
    }

    @Override
    public DataValidator.Status validateData(AutomatedInstallData data) {
        String ownerPassword;
        if (!Utils.isASInstalled(GlobalInstallationContext.installDir)) {
            return DataValidator.Status.OK;
        }
        String owner = this.getOwner();
        if (!this.testConnectionOK(owner, ownerPassword = this.getOwnerPassword(), "database.owner")) {
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    private String getOwner() {
        String user = System.getProperty("user.name").toLowerCase();
        if (GlobalInstallationContext.isFirstTimeInstallation) {
            return user;
        }
        String owner = Utils.tryToGetServicePropertyOfAS(GlobalInstallationContext.installDir, "database.owner");
        if (owner != null && owner.length() > 0) {
            return owner;
        }
        return user;
    }

    private String getOwnerPassword() {
        if (GlobalInstallationContext.isFirstTimeInstallation) {
            return NO_PASSWORD;
        }
        String password = Utils.tryToGetServicePropertyOfAS(GlobalInstallationContext.installDir, "database.owner-password");
        return password == null ? NO_PASSWORD : password;
    }

    private boolean testConnectionOK(String username, String password, String messagePostfix) {
        boolean connected = false;
        try {
            Class.forName(JDBC_DRIVER_NAME);
            Connection connection = DriverManager.getConnection(CONNECTION_STRING, username, password);
            if (connection != null) {
                connected = true;
                connection.close();
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.createMessage(cnfe, messagePostfix);
        }
        catch (SQLException e) {
            this.createMessage(e, messagePostfix);
        }
        return connected;
    }

    private void createMessage(Exception exception, String messagePostfix) {
        this.setErrorMessage(String.valueOf(exception.getMessage()) + ".\nThe error is probably caused by an ill-configured " + messagePostfix + ".");
    }
}

