/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import ch.systemsx.cisd.openbis.installer.izpack.AbstractScriptExecutor;
import ch.systemsx.cisd.openbis.installer.izpack.GlobalInstallationContext;
import ch.systemsx.cisd.openbis.installer.izpack.JarClassLoader;
import ch.systemsx.cisd.openbis.installer.izpack.Utils;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class SetDatabasesToBackupAction
extends AbstractScriptExecutor
implements PanelAction {
    private static final String HELPER_CLASS = "ch.systemsx.cisd.openbis.dss.generic.server.dbbackup.BackupDatabaseDescriptionGenerator";
    static final String DATABASES_TO_BACKUP_VARNAME = "DATABASES_TO_BACKUP";

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }

    @Override
    public void executeAction(AutomatedInstallData data, AbstractUIHandler handler) {
        try {
            String descriptions = this.extractDescriptions().trim();
            String databases = this.extractDatabases(data, descriptions);
            data.setVariable(DATABASES_TO_BACKUP_VARNAME, databases);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handler.emitError("Exception", ex.toString());
            return;
        }
    }

    private String extractDatabases(AutomatedInstallData data, String descriptions) {
        CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
        if (descriptions.length() > 0) {
            String[] stringArray = descriptions.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String description = stringArray[n2];
                String[] splitted = description.split(";")[0].split("=");
                if (splitted.length < 2) {
                    throw new IllegalArgumentException("Invalid database description: " + description);
                }
                String database = splitted[1].trim();
                if (this.databaseExists(data, database)) {
                    builder.append(database);
                }
                ++n2;
            }
        }
        return builder.toString();
    }

    private boolean databaseExists(AutomatedInstallData data, String database) {
        File scriptFile = this.getAdminScriptFile(data, "database-existence-check.sh");
        if (!scriptFile.exists()) {
            return true;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String owner = Utils.tryToGetServicePropertyOfAS(GlobalInstallationContext.installDir, "database.owner");
        String password = Utils.tryToGetServicePropertyOfAS(GlobalInstallationContext.installDir, "database.owner-password");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PGPASSWORD", password);
        this.executeAdminScript(env, outputStream, outputStream, scriptFile.getAbsolutePath(), database, owner);
        return !outputStream.toString().trim().equals("FALSE");
    }

    private String extractDescriptions() throws Exception {
        Object[] arguments = this.createArguments();
        File dssLibFolder = new File(GlobalInstallationContext.installDir, "servers/datastore_server/lib");
        Class<?> clazz = new JarClassLoader(dssLibFolder).loadClass(HELPER_CLASS);
        Method method = clazz.getMethod("getDescriptions", String[].class);
        return (String)method.invoke(null, arguments);
    }

    private Object[] createArguments() {
        ArrayList<String> paths = new ArrayList<String>();
        if (Utils.isASInstalled(GlobalInstallationContext.installDir)) {
            paths.add(new File(GlobalInstallationContext.installDir, "servers/openBIS-server/jetty/etc/service.properties").getAbsolutePath());
        }
        paths.add(new File(GlobalInstallationContext.installDir, "servers/datastore_server/etc/service.properties").getAbsolutePath());
        System.out.println("Scan following properties file for data source definitions: " + paths);
        return new Object[]{paths.toArray(new String[0])};
    }
}

