/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.htmlinfo;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.base.InstallerFrame;
import com.izforge.izpack.installer.base.IzPanel;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.util.HyperlinkHandler;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class HTMLInfoPanel
extends IzPanel {
    private static final long serialVersionUID = 3257008769514025270L;
    protected String panelResourcePrefixStr;
    protected String panelResourceNameStr;
    private JEditorPane textArea;

    public HTMLInfoPanel(InstallerFrame parent, GUIInstallData idata, ResourceManager resourceManager) {
        this(parent, idata, "HTMLInfoPanel", true, resourceManager);
    }

    public HTMLInfoPanel(InstallerFrame parent, GUIInstallData idata, String resPrefixStr, boolean showInfoLabelFlag, ResourceManager resourceManager) {
        super(parent, idata, new IzPanelLayout(), resourceManager);
        this.panelResourcePrefixStr = resPrefixStr;
        this.panelResourceNameStr = String.valueOf(resPrefixStr) + ".info";
        if (showInfoLabelFlag) {
            this.add((Component)LabelFactory.create(this.installData.getLangpack().getString("InfoPanel.info"), (Icon)parent.getIcons().get("edit"), 10), "nextLine");
        }
        try {
            this.textArea = new JEditorPane(){

                @Override
                protected InputStream getStream(URL urlObj) throws IOException {
                    int b;
                    InputStream inStm = super.getStream(urlObj);
                    ByteArrayOutputStream btArrOutStm = new ByteArrayOutputStream();
                    byte[] buff = new byte[2048];
                    while ((b = inStm.read(buff, 0, buff.length)) > 0) {
                        btArrOutStm.write(buff, 0, b);
                    }
                    String parsedStr = HTMLInfoPanel.this.parseText(btArrOutStm.toString());
                    return new ByteArrayInputStream(parsedStr.getBytes());
                }
            };
            this.textArea.setName(GuiId.HTML_INFO_PANEL_TEXT.id);
            this.textArea.setContentType("text/html; charset=utf-8");
            this.textArea.setEditable(false);
            this.textArea.addHyperlinkListener(new HyperlinkHandler());
            JScrollPane scroller = new JScrollPane(this.textArea);
            this.textArea.setCaretPosition(0);
            this.add((Component)scroller, "nextLine");
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        this.getLayoutHelper().completeLayout();
    }

    private URL loadHTMLInfoContent() {
        if (this.getMetadata() != null && this.getMetadata().getPanelid() != null) {
            try {
                String panelSpecificResName = String.valueOf(this.panelResourcePrefixStr) + '.' + this.getMetadata().getPanelid();
                String panelspecificResContent = this.resourceManager.getTextResource(panelSpecificResName);
                if (panelspecificResContent != null) {
                    this.panelResourceNameStr = panelSpecificResName;
                }
            }
            catch (Exception panelSpecificResName) {
                // empty catch block
            }
        }
        try {
            return this.resourceManager.getLocalizedURL(this.panelResourceNameStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void panelActivate() {
        this.textArea.getDocument().putProperty("stream", null);
        try {
            this.textArea.setPage(this.loadHTMLInfoContent());
            this.textArea.setCaretPosition(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

