/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import com.marathon.util.spring.StreamSupportingHttpInvokerProxyFactoryBean;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.springframework.remoting.httpinvoker.CommonsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;

public class HttpInvokerUtils {
    public static <T> T createServiceStub(Class<T> serviceInterface, String serviceURL, long serverTimeoutInMillis) {
        HttpInvokerProxyFactoryBean httpInvokerProxy = new HttpInvokerProxyFactoryBean();
        httpInvokerProxy.setBeanClassLoader(serviceInterface.getClassLoader());
        httpInvokerProxy.setServiceUrl(serviceURL);
        httpInvokerProxy.setServiceInterface(serviceInterface);
        CommonsHttpInvokerRequestExecutor httpInvokerRequestExecutor = new CommonsHttpInvokerRequestExecutor();
        httpInvokerRequestExecutor.setReadTimeout((int)serverTimeoutInMillis);
        InetSocketAddress proxyAddressOrNull = HttpInvokerUtils.tryFindProxy(serviceURL);
        if (proxyAddressOrNull != null) {
            httpInvokerRequestExecutor.getHttpClient().getHostConfiguration().setProxy(proxyAddressOrNull.getHostName(), proxyAddressOrNull.getPort());
        }
        httpInvokerProxy.setHttpInvokerRequestExecutor(httpInvokerRequestExecutor);
        httpInvokerProxy.afterPropertiesSet();
        return HttpInvokerUtils.getCastedService(httpInvokerProxy);
    }

    public static <T> T createStreamSupportingServiceStub(Class<T> serviceInterface, String serviceURL, long serverTimeoutInMillis) {
        StreamSupportingHttpInvokerProxyFactoryBean httpInvokerProxy = new StreamSupportingHttpInvokerProxyFactoryBean();
        httpInvokerProxy.setBeanClassLoader(serviceInterface.getClassLoader());
        httpInvokerProxy.setServiceUrl(serviceURL);
        httpInvokerProxy.setServiceInterface(serviceInterface);
        ((CommonsHttpInvokerRequestExecutor)httpInvokerProxy.getHttpInvokerRequestExecutor()).setReadTimeout((int)serverTimeoutInMillis);
        InetSocketAddress proxyAddressOrNull = HttpInvokerUtils.tryFindProxy(serviceURL);
        if (proxyAddressOrNull != null) {
            ((CommonsHttpInvokerRequestExecutor)httpInvokerProxy.getHttpInvokerRequestExecutor()).getHttpClient().getHostConfiguration().setProxy(proxyAddressOrNull.getHostName(), proxyAddressOrNull.getPort());
        }
        httpInvokerProxy.afterPropertiesSet();
        return HttpInvokerUtils.getCastedService(httpInvokerProxy);
    }

    private static final <T> T getCastedService(HttpInvokerProxyFactoryBean httpInvokerProxy) {
        return (T)httpInvokerProxy.getObject();
    }

    public static InetSocketAddress tryFindProxy(String serviceURL) {
        try {
            ProxySelector selector = ProxySelector.getDefault();
            List<Proxy> proxyList = selector.select(new URI(serviceURL));
            for (Proxy proxy : proxyList) {
                if (Proxy.Type.HTTP != proxy.type()) continue;
                return (InetSocketAddress)proxy.address();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (URISyntaxException uRISyntaxException) {}
        return null;
    }

    private HttpInvokerUtils() {
    }
}

