/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.xml;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.security.CodeSource;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLInfraStructure {
    private static final SchemaFactory SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private EntityResolver entityResolver;

    public static Schema createSchema(String schemaAsClasspathResource) {
        return XMLInfraStructure.createSchema(XMLInfraStructure.class.getResourceAsStream(schemaAsClasspathResource));
    }

    public static Schema createSchema(InputStream schemaAsInputStream) {
        try {
            return SCHEMA_FACTORY.newSchema(new StreamSource(schemaAsInputStream));
        }
        catch (SAXException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public static Schema createSchema(File schemaFile) {
        try {
            return SCHEMA_FACTORY.newSchema(new StreamSource(schemaFile));
        }
        catch (SAXException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public static Schema createSchema(URL schemaURL) {
        try {
            return SCHEMA_FACTORY.newSchema(schemaURL);
        }
        catch (SAXException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public static Schema createSchema(Source schemaAsSource) {
        try {
            return SCHEMA_FACTORY.newSchema(schemaAsSource);
        }
        catch (SAXException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public XMLInfraStructure(boolean validating) {
        this.parserFactory.setNamespaceAware(true);
        this.parserFactory.setValidating(validating);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void parse(Reader xmlDocument, ContentHandler contentHandler) {
        try {
            SAXParser saxParser = this.parserFactory.newSAXParser();
            if (this.parserFactory.isValidating()) {
                if (this.parserFactory.getSchema() == null) {
                    saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                }
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setEntityResolver(this.entityResolver);
                final ArrayList exceptions2 = new ArrayList();
                xmlReader.setErrorHandler(new ErrorHandler(){

                    @Override
                    public void warning(SAXParseException exception) throws SAXException {
                    }

                    @Override
                    public void fatalError(SAXParseException exception) throws SAXException {
                        exceptions2.add(exception);
                    }

                    @Override
                    public void error(SAXParseException exception) throws SAXException {
                        exceptions2.add(exception);
                    }
                });
                xmlReader.setContentHandler(contentHandler);
                xmlReader.parse(new InputSource(xmlDocument));
                if (!exceptions2.isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    for (SAXParseException exception : exceptions2) {
                        builder.append("\n");
                        builder.append("Error in line ").append(exception.getLineNumber());
                        builder.append(" column ").append(exception.getColumnNumber());
                        builder.append(":").append(exception.getMessage());
                    }
                    throw new SAXException("XML validation errors:" + builder);
                }
            } else {
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setContentHandler(contentHandler);
                xmlReader.parse(new InputSource(xmlDocument));
            }
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    public static String getJaxpImplementationInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(XMLInfraStructure.getJaxpImplementationInfo("DocumentBuilderFactory", DocumentBuilderFactory.newInstance().getClass()));
        sb.append("\n");
        sb.append(XMLInfraStructure.getJaxpImplementationInfo("XPathFactory", XPathFactory.newInstance().getClass()));
        sb.append("\n");
        sb.append(XMLInfraStructure.getJaxpImplementationInfo("TransformerFactory", TransformerFactory.newInstance().getClass()));
        sb.append("\n");
        sb.append(XMLInfraStructure.getJaxpImplementationInfo("SAXParserFactory", SAXParserFactory.newInstance().getClass()));
        sb.append("\n");
        sb.append(XMLInfraStructure.getJaxpImplementationInfo("SchemaFactory", SCHEMA_FACTORY.getClass()));
        sb.append("\n");
        return sb.toString();
    }

    private static String getJaxpImplementationInfo(String componentName, Class<?> componentClass) {
        CodeSource source = componentClass.getProtectionDomain().getCodeSource();
        Package p = componentClass.getPackage();
        return MessageFormat.format("{0} loaded from: {1},\n\timpl: {2}\n\tpackage: {3},\n\timplVendor: {4},\n\tspecVer: {5},\n\timplVer: {6}", componentName, source == null ? "Java Runtime" : source.getLocation(), componentClass.getName(), p.getName(), p.getImplementationVendor(), p.getSpecificationVersion(), p.getImplementationVersion());
    }
}

