/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.AliasRegistry;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class SimpleAliasRegistry
implements AliasRegistry {
    private final Map aliasMap = CollectionFactory.createConcurrentMapIfPossible(16);

    public void registerAlias(String name, String alias2) {
        Assert.hasText(name, "'name' must not be empty");
        Assert.hasText(alias2, "'alias' must not be empty");
        if (alias2.equals(name)) {
            this.aliasMap.remove(alias2);
        } else {
            String registeredName;
            if (!this.allowAliasOverriding() && (registeredName = (String)this.aliasMap.get(alias2)) != null && !registeredName.equals(name)) {
                throw new IllegalStateException("Cannot register alias '" + alias2 + "' for name '" + name + "': It is already registered for name '" + registeredName + "'.");
            }
            this.aliasMap.put(alias2, name);
        }
    }

    protected boolean allowAliasOverriding() {
        return true;
    }

    public void removeAlias(String alias2) {
        String name = (String)this.aliasMap.remove(alias2);
        if (name == null) {
            throw new IllegalStateException("No alias '" + alias2 + "' registered");
        }
    }

    public boolean isAlias(String name) {
        return this.aliasMap.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAliases(String name) {
        ArrayList aliases = new ArrayList();
        Map map = this.aliasMap;
        synchronized (map) {
            Iterator it = this.aliasMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String registeredName = (String)entry.getValue();
                if (!registeredName.equals(name)) continue;
                aliases.add(entry.getKey());
            }
        }
        return StringUtils.toStringArray(aliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAliases(StringValueResolver valueResolver) {
        Assert.notNull(valueResolver, "StringValueResolver must not be null");
        Map map = this.aliasMap;
        synchronized (map) {
            HashMap aliasCopy = new HashMap(this.aliasMap);
            Iterator it = aliasCopy.keySet().iterator();
            while (it.hasNext()) {
                String alias2 = (String)it.next();
                String registeredName = (String)aliasCopy.get(alias2);
                String resolvedAlias = valueResolver.resolveStringValue(alias2);
                String resolvedName = valueResolver.resolveStringValue(registeredName);
                if (!resolvedAlias.equals(alias2)) {
                    String existingName = (String)this.aliasMap.get(resolvedAlias);
                    if (existingName != null && !existingName.equals(resolvedName)) {
                        throw new IllegalStateException("Cannot register resolved alias '" + resolvedAlias + "' (original: '" + alias2 + "') for name '" + resolvedName + "': It is already registered for name '" + registeredName + "'.");
                    }
                    this.aliasMap.put(resolvedAlias, resolvedName);
                    this.aliasMap.remove(alias2);
                    continue;
                }
                if (registeredName.equals(resolvedName)) continue;
                this.aliasMap.put(alias2, resolvedName);
            }
        }
    }

    public String canonicalName(String name) {
        String canonicalName = name;
        String resolvedName = null;
        do {
            if ((resolvedName = (String)this.aliasMap.get(canonicalName)) == null) continue;
            canonicalName = resolvedName;
        } while (resolvedName != null);
        return canonicalName;
    }
}

