/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.ITableModel;
import java.io.Serializable;
import java.util.List;

public class TableModel
implements Serializable,
ITableModel {
    private static final long serialVersionUID = 35L;
    private String messageOrNull;
    private List<TableModelRow> rows;
    private List<TableModelColumnHeader> header;

    public TableModel(List<TableModelColumnHeader> header, List<TableModelRow> rows) {
        this(header, rows, null);
    }

    public TableModel(List<TableModelColumnHeader> header, List<TableModelRow> rows, String messageOrNull) {
        this.rows = rows;
        this.header = header;
        this.messageOrNull = messageOrNull;
        this.validate();
    }

    private void validate() {
        int columnsNo = this.header.size();
        for (TableModelRow row : this.rows) {
            assert (row.getValues().size() == columnsNo) : "row has a different number of columns than the table header";
        }
    }

    public List<TableModelRow> getRows() {
        return this.rows;
    }

    public List<TableModelColumnHeader> getHeader() {
        return this.header;
    }

    public String tryGetMessage() {
        return this.messageOrNull;
    }

    private TableModel() {
    }
}

