/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.common.concurrent.MonitoringProxy;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.CopyModeExisting;
import ch.systemsx.cisd.common.filesystem.IFileImmutableCopier;
import ch.systemsx.cisd.common.time.TimingParameters;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileCopyUtils;

public class FastHardLinkMaker
implements IFileImmutableCopier {
    private static final IFileImmutableCopier nativeCopier = new IFileImmutableCopier(){

        @Override
        public Status copyFileImmutably(File source, File destinationDirectory, String nameOrNull) {
            return this.copyFileImmutably(source, destinationDirectory, nameOrNull, CopyModeExisting.ERROR);
        }

        @Override
        public Status copyFileImmutably(File source, File destinationDirectory, String nameOrNull, CopyModeExisting mode) {
            File destination = new File(destinationDirectory, nameOrNull == null ? source.getName() : nameOrNull);
            if (destination.exists()) {
                switch (mode) {
                    case OVERWRITE: {
                        destination.delete();
                        break;
                    }
                    case IGNORE: {
                        return Status.OK;
                    }
                    default: {
                        return Status.createError("File '" + destination + "' already exists.");
                    }
                }
            }
            try {
                Unix.createHardLink((String)source.getAbsolutePath(), (String)destination.getAbsolutePath());
                return Status.OK;
            }
            catch (IOExceptionUnchecked ex) {
                String errorMsg = ex.getCause().getMessage();
                if (errorMsg.endsWith("Operation not supported")) {
                    try {
                        FileCopyUtils.copyFile((File)source, (File)destination);
                        return Status.OK;
                    }
                    catch (IOException ex2) {
                        return Status.createError(ex2.getMessage());
                    }
                }
                return Status.createError(errorMsg);
            }
        }
    };
    private final IFileImmutableCopier monitoringProxy;

    public static final boolean isOperational() {
        return Unix.isOperational();
    }

    public static final IFileImmutableCopier tryCreate(TimingParameters timingParameters) {
        if (!Unix.isOperational()) {
            return null;
        }
        return new FastHardLinkMaker(timingParameters);
    }

    public static final IFileImmutableCopier tryCreate() {
        return FastHardLinkMaker.tryCreate(TimingParameters.getDefaultParameters());
    }

    private FastHardLinkMaker(TimingParameters timingParameters) {
        this.monitoringProxy = MonitoringProxy.create(IFileImmutableCopier.class, nativeCopier).timing(timingParameters).get();
    }

    @Override
    public Status copyFileImmutably(File source, File destinationDirectory, String nameOrNull) {
        return this.monitoringProxy.copyFileImmutably(source, destinationDirectory, nameOrNull);
    }

    @Override
    public Status copyFileImmutably(File source, File destinationDirectory, String nameOrNull, CopyModeExisting mode) {
        return this.monitoringProxy.copyFileImmutably(source, destinationDirectory, nameOrNull, mode);
    }
}

