/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.ldap;

import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.authentication.ldap.LDAPDirectoryConfiguration;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidAuthenticationException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.ISelfTestable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

public final class LDAPPrincipalQuery
implements ISelfTestable {
    private static final String DISTINGUISHED_NAME_ATTRIBUTE_NAME = "distinguishedName";
    private static final String UID_NUMBER_ATTRIBUTE_NAME = "uidNumber";
    private static final String LOGIN_DN_MSG_TEMPLATE = "User '%s' <DN='%s'>: authentication %s";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, LDAPPrincipalQuery.class);
    private static final String LDAP_CONTEXT_FACTORY_CLASSNAME = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_CONTEXT_READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private static final String LDAP_CONTEXT_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String AUTHENTICATION_FAILURE_TEMPLATE = "Authentication failure connecting to LDAP server '%s'.";
    private static final String LDAP_ERROR_TEMPLATE = "Error connecting to LDAP server '%s'.";
    private final LDAPDirectoryConfiguration config;
    private final ThreadLocal<DirContext> contextHolder;

    public LDAPPrincipalQuery(LDAPDirectoryConfiguration config) {
        this.config = config;
        this.contextHolder = new ThreadLocal();
    }

    public Principal tryGetPrincipal(String userId) throws IllegalArgumentException {
        List<Principal> principals = this.listPrincipalsByUserId(userId, 1);
        return this.tryGetPrincipal(principals, "User '%s' is not unique.", userId);
    }

    public Principal tryGetPrincipalByEmail(String email) {
        List<Principal> principals = this.listPrincipalsByEmail(email, 1);
        return this.tryGetPrincipal(principals, "Email '%s' is not unique.", email);
    }

    private Principal tryGetPrincipal(List<Principal> principals, String msgTemplate, String user) {
        if (principals.size() == 0) {
            return null;
        }
        if (principals.size() == 1) {
            return principals.get(0);
        }
        throw new IllegalArgumentException(String.format(msgTemplate, user));
    }

    public List<Principal> listPrincipalsByUserId(String userId) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("listPrincipalsByUserId(%s)", userId));
        }
        return this.listPrincipalsByKeyValue(this.config.getUserIdAttributeName(), userId, null, Integer.MAX_VALUE);
    }

    private List<Principal> listPrincipalsByUserId(String userId, int limit) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("listPrincipalsByUserId(%s,%s)", userId, limit));
        }
        return this.listPrincipalsByKeyValue(this.config.getUserIdAttributeName(), userId, null, limit);
    }

    public List<Principal> listPrincipalsByEmail(String email, int limit) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("listPrincipalsByEmail(%s,%s)", email, limit));
        }
        return this.listPrincipalsByKeyValue(this.getEmailAttributeForQueries(), this.getEmailKeyForQueries(email), null, limit);
    }

    private String getEmailAttributeForQueries() {
        if (Boolean.parseBoolean(this.config.getQueryEmailForAliases())) {
            return this.config.getEmailAliasesAttributeName();
        }
        return this.config.getEmailAttributeName();
    }

    private String getEmailKeyForQueries(String emailQuery) {
        if (Boolean.parseBoolean(this.config.getQueryEmailForAliases())) {
            return String.valueOf(this.config.getEmailAttributePrefix()) + emailQuery;
        }
        return emailQuery;
    }

    public List<Principal> listPrincipalsByEmail(String email) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("listPrincipalsByEmail(%s)", email));
        }
        return this.listPrincipalsByKeyValue(this.getEmailAttributeForQueries(), this.getEmailKeyForQueries(email), null, Integer.MAX_VALUE);
    }

    public List<Principal> listPrincipalsByLastName(String lastName, int limit) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("listPrincipalsByLastName(%s,%s)", lastName, limit));
        }
        return this.listPrincipalsByKeyValue(this.config.getLastNameAttributeName(), lastName, null, limit);
    }

    public List<Principal> listPrincipalsByLastName(String lastName) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("listPrincipalsByLastName(%s)", lastName));
        }
        return this.listPrincipalsByKeyValue(this.config.getLastNameAttributeName(), lastName, null, Integer.MAX_VALUE);
    }

    public boolean authenticateUser(String userId, String password) {
        if (password != null && password.isEmpty()) {
            return false;
        }
        Principal principal = this.tryGetAndAuthenticatePrincipal(userId, password);
        return principal == null ? false : principal.isAuthenticated();
    }

    public Principal tryGetAndAuthenticatePrincipal(String userId, String passwordOrNull) {
        Principal principal = this.tryGetPrincipal(userId);
        if (principal == null) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format("User '%s' not found in LDAP directory.", userId));
            }
            return null;
        }
        this.authenticatePrincipal(principal, passwordOrNull);
        return principal;
    }

    public Principal tryGetAndAuthenticatePrincipalByEmail(String email, String passwordOrNull) {
        if (passwordOrNull != null && passwordOrNull.isEmpty()) {
            return null;
        }
        Principal principal = this.tryGetPrincipalByEmail(email);
        if (principal == null) {
            return null;
        }
        this.authenticatePrincipal(principal, passwordOrNull);
        return principal;
    }

    private void authenticatePrincipal(Principal principal, String passwordOrNull) {
        String distinguishedName = principal.getProperty(DISTINGUISHED_NAME_ATTRIBUTE_NAME);
        boolean authenticated = passwordOrNull == null ? false : this.authenticateUserByDistinguishedName(distinguishedName, passwordOrNull);
        principal.setAuthenticated(authenticated);
        if (operationLog.isDebugEnabled() && passwordOrNull != null) {
            operationLog.debug(String.format(LOGIN_DN_MSG_TEMPLATE, principal.getUserId(), distinguishedName, this.getStatus(authenticated)));
        }
    }

    private String getStatus(boolean status) {
        return status ? "OK" : "FAILURE";
    }

    private boolean authenticateUserByDistinguishedName(String dn, String password) {
        try {
            this.createContextForDistinguishedName(dn, password, false, true);
            return true;
        }
        catch (InvalidAuthenticationException invalidAuthenticationException) {
            return false;
        }
        catch (RuntimeException ex) {
            operationLog.error(String.format("Error on creating context to authenticate dn=<%s>", dn), ex);
            throw ex;
        }
    }

    public List<Principal> listPrincipalsByKeyValue(String key, String value) {
        return this.listPrincipalsByKeyValue(key, value, null, Integer.MAX_VALUE);
    }

    public List<Principal> listPrincipalsByKeyValue(String key, String value, Collection<String> additionalAttributesOrNull, int limit) {
        RuntimeException firstException = null;
        int i = 0;
        while (i <= this.config.getMaxRetries()) {
            try {
                return this.primListPrincipalsByKeyValue(key, value, additionalAttributesOrNull, limit);
            }
            catch (RuntimeException ex) {
                this.contextHolder.set(null);
                if (firstException == null) {
                    firstException = ex;
                    if (operationLog.isDebugEnabled() && i < this.config.getMaxRetries()) {
                        operationLog.debug(String.format("Error listing principle by %s=%s, retrying...", key, value), ex);
                    }
                }
                if (i < this.config.getMaxRetries()) {
                    ConcurrencyUtilities.sleep(this.config.getTimeToWaitAfterFailure());
                }
                ++i;
            }
        }
        operationLog.error(String.format("Error on LDAP query %s=%s", key, value), firstException);
        throw firstException;
    }

    private List<Principal> primListPrincipalsByKeyValue(String key, String value, Collection<String> additionalAttributesOrNull, int limit) {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        String filter = String.format("%s=%s", key, value);
        String query = String.format(this.config.getQueryTemplate(), filter);
        try {
            DirContext context = this.createContext(false);
            SearchControls ctrl = new SearchControls();
            ctrl.setSearchScope(2);
            NamingEnumeration<SearchResult> enumeration = context.search("", query, ctrl);
            int count = 0;
            while (count++ < limit && enumeration.hasMore()) {
                SearchResult result = enumeration.next();
                Attributes attributes = result.getAttributes();
                String userId = LDAPPrincipalQuery.tryGetAttribute(attributes, this.config.getUserIdAttributeName());
                String email = LDAPPrincipalQuery.tryGetAttribute(attributes, this.config.getEmailAttributeName());
                String distinguishedName = result.getNameInNamespace();
                if (userId == null || email == null || distinguishedName == null) continue;
                String firstName = LDAPPrincipalQuery.tryGetAttribute(attributes, this.config.getFirstNameAttributeName(), "?");
                String lastName = LDAPPrincipalQuery.tryGetAttribute(attributes, this.config.getLastNameAttributeName(), "?");
                String uidNumber = LDAPPrincipalQuery.tryGetAttribute(attributes, UID_NUMBER_ATTRIBUTE_NAME);
                Principal principal = new Principal(userId, firstName, lastName, email, false);
                principal.getProperties().put(DISTINGUISHED_NAME_ATTRIBUTE_NAME, distinguishedName);
                if (uidNumber != null) {
                    principal.getProperties().put(UID_NUMBER_ATTRIBUTE_NAME, uidNumber);
                }
                if (additionalAttributesOrNull != null) {
                    if (additionalAttributesOrNull.isEmpty()) {
                        principal.setProperties(LDAPPrincipalQuery.getAllAttributes(attributes));
                    } else {
                        for (String attributeName : additionalAttributesOrNull) {
                            String attributeValue = LDAPPrincipalQuery.tryGetAttribute(attributes, attributeName);
                            if (attributeValue == null) continue;
                            principal.getProperties().put(attributeName, attributeValue);
                        }
                    }
                }
                principals.add(principal);
            }
            return principals;
        }
        catch (AuthenticationException ex) {
            throw ConfigurationFailureException.fromTemplate(ex, AUTHENTICATION_FAILURE_TEMPLATE, this.config.getServerUrl());
        }
        catch (NamingException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private DirContext createContext(boolean retry) {
        return this.createContextForDistinguishedName(this.config.getSecurityPrincipalDistinguishedName(), this.config.getSecurityPrincipalPassword(), true, retry);
    }

    private DirContext createContextForDistinguishedName(String dn, String password, boolean useThreadContext, boolean retry) {
        DirContext threadContext;
        DirContext dirContext = threadContext = useThreadContext ? this.contextHolder.get() : null;
        if (threadContext != null) {
            return threadContext;
        }
        if (password != null && password.isEmpty()) {
            throw new RuntimeException("Try to login user '" + dn + "' with empty password.");
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", LDAP_CONTEXT_FACTORY_CLASSNAME);
        env.put("java.naming.provider.url", this.config.getServerUrl());
        env.put("java.naming.security.protocol", this.config.getSecurityProtocol());
        env.put("java.naming.security.authentication", this.config.getSecurityAuthenticationMethod());
        env.put("java.naming.referral", this.config.getReferral());
        env.put("java.naming.security.principal", dn);
        env.put("java.naming.security.credentials", password);
        env.put(LDAP_CONTEXT_READ_TIMEOUT, Long.toString(this.config.getTimeout()));
        env.put(LDAP_CONTEXT_CONNECT_TIMEOUT, Long.toString(this.config.getTimeout()));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Try to login to %s with dn=%s", this.config.getServerUrl(), dn));
        }
        RuntimeException firstException = null;
        int i = 0;
        while (i <= this.config.getMaxRetries()) {
            try {
                InitialDirContext initialDirContext = new InitialDirContext(env);
                if (useThreadContext) {
                    this.contextHolder.set(initialDirContext);
                }
                return initialDirContext;
            }
            catch (Exception ex) {
                if (ex instanceof AuthenticationException) {
                    throw new InvalidAuthenticationException("Failed to authenticate dn=<" + dn + ">", ex);
                }
                if (firstException == null) {
                    firstException = CheckedExceptionTunnel.wrapIfNecessary(ex);
                    if (operationLog.isDebugEnabled() && retry) {
                        operationLog.debug("Error connecting to LDAP service: cannot open a context for dn=<" + dn + ">, retrying...", ex);
                    }
                }
                if (!retry) break;
                if (i < this.config.getMaxRetries()) {
                    ConcurrencyUtilities.sleep(this.config.getTimeToWaitAfterFailure());
                }
                ++i;
            }
        }
        throw firstException;
    }

    private static String tryGetAttribute(Attributes attributes, String attributeName) throws NamingException {
        return LDAPPrincipalQuery.tryGetAttribute(attributes, attributeName, null);
    }

    private static String tryGetAttribute(Attributes attributes, String attributeName, String defaultValue) throws NamingException {
        BasicAttribute basicAttribute = (BasicAttribute)attributes.get(attributeName);
        if (basicAttribute == null) {
            return defaultValue;
        }
        NamingEnumeration<?> values = basicAttribute.getAll();
        StringBuilder builder = new StringBuilder();
        while (values.hasMore()) {
            builder.append(values.next().toString());
            builder.append("::");
        }
        if (builder.length() == 0) {
            return defaultValue;
        }
        builder.setLength(builder.length() - 2);
        return builder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, String> getAllAttributes(Attributes attributes) throws NamingException {
        result = new HashMap<String, String>();
        attributeEnum = attributes.getAll();
        if (attributeEnum != null) ** GOTO lbl19
        return result;
lbl-1000:
        // 1 sources

        {
            attribute = (BasicAttribute)attributeEnum.next();
            attributeName = attribute.getID();
            values = attribute.getAll();
            builder = new StringBuilder();
            while (values.hasMore()) {
                builder.append(values.next().toString());
                builder.append("::");
            }
            if (builder.length() <= 2) continue;
            builder.setLength(builder.length() - 2);
            result.put(attributeName, builder.toString());
lbl19:
            // 3 sources

            ** while (attributeEnum.hasMore())
        }
lbl20:
        // 1 sources

        return result;
    }

    @Override
    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        try {
            this.createContext(true);
        }
        catch (InvalidAuthenticationException ex) {
            throw ConfigurationFailureException.fromTemplate(ex, AUTHENTICATION_FAILURE_TEMPLATE, this.config.getServerUrl());
        }
        catch (RuntimeException ex) {
            throw EnvironmentFailureException.fromTemplate(CheckedExceptionTunnel.unwrapIfNecessary(ex), LDAP_ERROR_TEMPLATE, this.config.getServerUrl());
        }
    }

    @Override
    public boolean isRemote() {
        return !this.config.getServerUrl().contains("localhost") && !this.config.getServerUrl().contains("127.0.0.1");
    }
}

