/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.FilteredHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentNodeFilter;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationError;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPackageManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiveFolders;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IdentifierAttributeMappingManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DistributedPackagingDataSetFileOperationsManager
implements IDataSetFileOperationsManager {
    static final String MAPPING_FILE_KEY = "mapping-file";
    static final String CREATE_ARCHIVES_KEY = "mapping-file.create-archives";
    static final String DEFAULT_DESTINATION_KEY = "default-archive-folder";
    static final String DEFAULT_SMALL_DATA_SETS_DESTINATION_KEY = "default-small-data-sets-archive-folder";
    static final String SMALL_DATA_SETS_SIZE_LIMIT_KEY = "small-data-sets-size-limit";
    static final String WITH_SHARDING_KEY = "with-sharding";
    static final String IGNORE_EXISTING_KEY = "ignore-existing";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DistributedPackagingDataSetFileOperationsManager.class);
    private static final IHierarchicalContentNodeFilter FILTER = new IHierarchicalContentNodeFilter(){

        @Override
        public boolean accept(IHierarchicalContentNode node) {
            return !"meta-data.tsv".equals(node.getRelativePath());
        }
    };
    private boolean ignoreExisting;
    private File defaultFolder;
    private File defaultSmallDataSetsFolder;
    private Long smallDataSetsSizeLimit;
    private boolean withSharding;
    private String mappingFilePathOrNull;
    private boolean createArchives;
    private transient IEncapsulatedOpenBISService service;
    private transient IDataSetDirectoryProvider directoryProvider;
    private transient IdentifierAttributeMappingManager archiveFolderMapping;
    private IPackageManager packageManager;

    public DistributedPackagingDataSetFileOperationsManager(Properties properties, IPackageManager packageManager) {
        this(properties, null, null, packageManager);
    }

    DistributedPackagingDataSetFileOperationsManager(Properties properties, IEncapsulatedOpenBISService service, IDataSetDirectoryProvider directoryProvider, IPackageManager packageManager) {
        long aSmallDataSetsSizeLimit;
        this.service = service;
        this.directoryProvider = directoryProvider;
        this.packageManager = packageManager;
        this.ignoreExisting = PropertyUtils.getBoolean(properties, IGNORE_EXISTING_KEY, false);
        this.withSharding = PropertyUtils.getBoolean(properties, WITH_SHARDING_KEY, false);
        this.defaultFolder = new File(PropertyUtils.getMandatoryProperty(properties, DEFAULT_DESTINATION_KEY));
        if (!this.defaultFolder.isDirectory()) {
            throw new ConfigurationFailureException("Default archive folder '" + this.defaultFolder.getPath() + "' doesn't exist or is not a folder.");
        }
        String aDefaultSmallDataSetsFolder = PropertyUtils.getProperty(properties, DEFAULT_SMALL_DATA_SETS_DESTINATION_KEY);
        if (!StringUtils.isBlank(aDefaultSmallDataSetsFolder)) {
            this.defaultSmallDataSetsFolder = new File(aDefaultSmallDataSetsFolder);
            if (!this.defaultSmallDataSetsFolder.isDirectory()) {
                throw new ConfigurationFailureException("Default small data sets archive folder '" + this.defaultSmallDataSetsFolder.getPath() + "' doesn't exist or is not a folder.");
            }
        }
        if ((aSmallDataSetsSizeLimit = PropertyUtils.getLong(properties, SMALL_DATA_SETS_SIZE_LIMIT_KEY, -1L)) > 0L) {
            this.smallDataSetsSizeLimit = aSmallDataSetsSizeLimit * 1024L;
        }
        this.mappingFilePathOrNull = properties.getProperty(MAPPING_FILE_KEY);
        this.createArchives = PropertyUtils.getBoolean(properties, CREATE_ARCHIVES_KEY, false);
        this.getArchiveFolderMapping();
    }

    @Override
    public Status copyToDestination(File originalData, DatasetDescription datasetDescription) {
        AbstractExternalData dataSet = this.getDataSetWithAllMetaData(datasetDescription);
        IShareIdManager shareIdManager = this.getDirectoryProvider().getShareIdManager();
        Status status = Status.OK;
        String dataSetCode = datasetDescription.getDataSetCode();
        File file = this.getArchiveFile(datasetDescription);
        shareIdManager.lock(dataSetCode);
        try {
            try {
                this.packageManager.create(file, dataSet);
            }
            catch (Exception ex) {
                status = Status.createError(ex.toString());
                operationLog.error("Couldn't create package file: " + file, ex);
                try {
                    List<VerificationError> errors;
                    if (Status.OK.equals(status) && (errors = this.packageManager.verify(file)).size() > 0) {
                        status = Status.createError(errors.toString());
                        throw new RuntimeException(errors.toString());
                    }
                    operationLog.info("Data set '" + dataSetCode + "' archived: " + file);
                }
                catch (Exception ex2) {
                    operationLog.error("Couldn't create package file: " + file, ex2);
                }
                shareIdManager.releaseLock(dataSetCode);
            }
        }
        finally {
            try {
                List<VerificationError> errors;
                if (Status.OK.equals(status) && (errors = this.packageManager.verify(file)).size() > 0) {
                    status = Status.createError(errors.toString());
                    throw new RuntimeException(errors.toString());
                }
                operationLog.info("Data set '" + dataSetCode + "' archived: " + file);
            }
            catch (Exception ex) {
                operationLog.error("Couldn't create package file: " + file, ex);
            }
            shareIdManager.releaseLock(dataSetCode);
        }
        return status;
    }

    @Override
    public Status retrieveFromDestination(File originalData, DatasetDescription datasetDescription) {
        File file = this.getArchiveFile(datasetDescription);
        Status status = this.packageManager.extract(file, originalData);
        if (status.isOK()) {
            operationLog.info("Data set '" + datasetDescription.getDataSetCode() + "' retrieved from archive '" + file.getPath() + "' to '" + originalData + "'.");
        }
        return status;
    }

    @Override
    public Status deleteFromDestination(IDatasetLocation dataset) {
        File archiveFile = this.tryFindArchiveFile(dataset);
        if (archiveFile == null) {
            operationLog.warn("Archive file for data set '" + dataset.getDataSetCode() + "' no konger exists.");
            return Status.OK;
        }
        boolean success = archiveFile.delete();
        return success ? Status.OK : Status.createError("Couldn't delete archive file '" + archiveFile + "'.");
    }

    private File tryFindArchiveFile(IDatasetLocation datasetLocation) {
        File archiveFile = this.getArchiveFile(this.defaultFolder, datasetLocation, false);
        if (archiveFile.isFile()) {
            return archiveFile;
        }
        if (this.defaultSmallDataSetsFolder != null && (archiveFile = this.getArchiveFile(this.defaultSmallDataSetsFolder, datasetLocation, false)).isFile()) {
            return archiveFile;
        }
        Collection<File> folders = this.getArchiveFolderMapping().getAllFolders();
        for (File folder : folders) {
            archiveFile = this.getArchiveFile(folder, datasetLocation, false);
            if (!archiveFile.isFile()) continue;
            return archiveFile;
        }
        return null;
    }

    @Override
    public Status markAsDeleted(IDatasetLocation dataset) {
        File archiveFile = this.tryFindArchiveFile(dataset);
        if (archiveFile == null) {
            operationLog.warn("Archive file for data set '" + dataset.getDataSetCode() + "' no konger exists.");
            return Status.OK;
        }
        String relPath = String.valueOf(this.withSharding ? String.valueOf(dataset.getDataSetLocation()) + "/" : "") + this.createPackageFileName(dataset);
        String path = archiveFile.getPath();
        int index = path.lastIndexOf(relPath);
        File archiveFolder = new File(path.substring(0, index));
        File folderOfMarkers = new File(archiveFolder, "DELETED");
        folderOfMarkers.mkdirs();
        File markerFile = new File(folderOfMarkers, dataset.getDataSetCode());
        try {
            if (!markerFile.createNewFile()) {
                throw new IOException("Marker file already exists.");
            }
            return Status.OK;
        }
        catch (IOException ex) {
            String message = "Couldn't create marker file '" + markerFile + "': " + ex;
            operationLog.error(message, ex);
            return Status.createError(message);
        }
    }

    @Override
    public BooleanStatus isSynchronizedWithDestination(File originalData, DatasetDescription datasetDescription) {
        return this.isPresentInDestination(datasetDescription);
    }

    @Override
    public BooleanStatus isPresentInDestination(DatasetDescription datasetDescription) {
        if (this.ignoreExisting) {
            File file = this.getArchiveFile(datasetDescription);
            if (file.exists() && file.length() > 0L) {
                operationLog.info("Data set '" + datasetDescription.getDataSetCode() + "' will be ignored as it already exists in the archive.");
                return BooleanStatus.createTrue();
            }
            return BooleanStatus.createFalse();
        }
        return BooleanStatus.createFalse();
    }

    @Override
    public boolean isHosted() {
        return false;
    }

    @Override
    public IHierarchicalContent getAsHierarchicalContent(DatasetDescription dataset) {
        return new FilteredHierarchicalContent(this.packageManager.asHierarchialContent(this.getArchiveFile(dataset)), FILTER);
    }

    private AbstractExternalData getDataSetWithAllMetaData(DatasetDescription datasetDescription) {
        ContainerDataSet containerDataSet;
        AbstractExternalData dataSet = this.getService().tryGetDataSet(datasetDescription.getDataSetCode());
        String experimentIdentifier = datasetDescription.getExperimentIdentifier();
        dataSet.setExperiment(this.getService().tryGetExperiment(ExperimentIdentifierFactory.parse(experimentIdentifier)));
        String sampleIdentifier = datasetDescription.getSampleIdentifier();
        if (sampleIdentifier != null) {
            dataSet.setSample(this.getService().tryGetSampleWithExperiment(SampleIdentifierFactory.parse(sampleIdentifier)));
        }
        if ((containerDataSet = dataSet.tryGetAsContainerDataSet()) != null) {
            if (containerDataSet.getProperties() == null) {
                containerDataSet.setDataSetProperties(this.getService().tryGetDataSet(containerDataSet.getCode()).getProperties());
            }
            String containerExperimentIdentifier = containerDataSet.getExperiment().getIdentifier();
            containerDataSet.setExperiment(this.getService().tryGetExperiment(ExperimentIdentifierFactory.parse(containerExperimentIdentifier)));
            Sample sample = containerDataSet.getSample();
            if (sample != null) {
                String containerSampleIdentifier = sample.getIdentifier();
                containerDataSet.setSample(this.getService().tryGetSampleWithExperiment(SampleIdentifierFactory.parse(containerSampleIdentifier)));
            }
        }
        return dataSet;
    }

    private File getArchiveFile(DatasetDescription datasetDescription) {
        File folder = this.getArchiveFolderMapping().getArchiveFolder(datasetDescription, null);
        if (folder == null) {
            File[] folders = new File[]{this.defaultFolder, this.defaultSmallDataSetsFolder};
            ArchiveFolders archiveFolders = ArchiveFolders.create(folders, false, this.smallDataSetsSizeLimit);
            folder = archiveFolders.getFolder(datasetDescription);
        }
        return this.getArchiveFile(folder, datasetDescription, true);
    }

    private File getArchiveFile(File baseFolder, IDatasetLocation datasetLocation, boolean forWriting) {
        File folder = this.getArchiveFolder(baseFolder, datasetLocation, forWriting);
        return new File(folder, this.createPackageFileName(datasetLocation));
    }

    private String createPackageFileName(IDatasetLocation datasetLocation) {
        return this.packageManager.getName(datasetLocation);
    }

    private File getArchiveFolder(File baseFolder, IDatasetLocation datasetLocation, boolean forWriting) {
        File folder = baseFolder;
        if (this.withSharding) {
            folder = new File(folder, datasetLocation.getDataSetLocation());
            if (forWriting && !folder.exists()) {
                folder.mkdirs();
            }
        }
        return folder;
    }

    private IEncapsulatedOpenBISService getService() {
        if (this.service == null) {
            this.service = ServiceProvider.getOpenBISService();
        }
        return this.service;
    }

    private IDataSetDirectoryProvider getDirectoryProvider() {
        if (this.directoryProvider == null) {
            this.directoryProvider = ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
        }
        return this.directoryProvider;
    }

    private IdentifierAttributeMappingManager getArchiveFolderMapping() {
        if (this.archiveFolderMapping == null) {
            this.archiveFolderMapping = new IdentifierAttributeMappingManager(this.mappingFilePathOrNull, this.createArchives, this.smallDataSetsSizeLimit);
        }
        return this.archiveFolderMapping;
    }
}

