/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.tar.Untar;
import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.TarBasedHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationError;
import ch.systemsx.cisd.openbis.dss.generic.server.TarDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPackageManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class TarPackageManager
implements IPackageManager {
    private transient IHierarchicalContentProvider contentProvider;
    private transient IDataSetDirectoryProvider directoryProvider;

    @Override
    public String getName(IDatasetLocation dataSetLocation) {
        return String.valueOf(dataSetLocation.getDataSetCode()) + ".tar";
    }

    @Override
    public void create(File packageFile, AbstractExternalData dataSet) {
        TarDataSetPackager packager = null;
        try {
            DataSetExistenceChecker existenceChecker = new DataSetExistenceChecker(this.getDirectoryProvider(), TimingParameters.create(new Properties()));
            packager = new TarDataSetPackager(packageFile, this.getContentProvider(), existenceChecker);
            packager.addDataSetTo("", dataSet);
        }
        finally {
            if (packager != null) {
                packager.close();
            }
        }
    }

    @Override
    public List<VerificationError> verify(File packageFile) {
        return Collections.emptyList();
    }

    @Override
    public Status extract(File packageFile, File toDirectory) {
        Untar untar = null;
        try {
            untar = new Untar(packageFile);
            untar.extract(toDirectory);
            File metadataFile = new File(toDirectory, "meta-data.tsv");
            if (metadataFile.exists() && metadataFile.isFile()) {
                FileUtilities.delete(metadataFile);
            }
            Status status = Status.OK;
            return status;
        }
        catch (Exception ex) {
            Status status = Status.createError(ex.toString());
            return status;
        }
        finally {
            if (untar != null) {
                try {
                    untar.close();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
        }
    }

    @Override
    public IHierarchicalContent asHierarchialContent(File packageFile) {
        return new TarBasedHierarchicalContent(packageFile);
    }

    private IHierarchicalContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.contentProvider;
    }

    private IDataSetDirectoryProvider getDirectoryProvider() {
        if (this.directoryProvider == null) {
            this.directoryProvider = ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
        }
        return this.directoryProvider;
    }
}

