/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.IValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SimpleSpaceValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.ICodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;

abstract class AbstractIdentifierValidator
extends AbstractValidator<IIdentifierHolder> {
    private final IValidator<ICodeHolder> spaceValidator = new SimpleSpaceValidator();

    AbstractIdentifierValidator() {
    }

    @Override
    public boolean doValidation(PersonPE person, IIdentifierHolder value) {
        final String spaceCodeOrNull = this.extractSpaceCodeOrNull(value.getIdentifier());
        return this.spaceValidator.isValid(person, new ICodeHolder(){

            @Override
            public String getCode() {
                return spaceCodeOrNull;
            }
        });
    }

    protected abstract String extractSpaceCodeOrNull(String var1);
}

