/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleOwner;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleOwnerFinder;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.HashMap;
import java.util.Map;

abstract class AbstractSampleIdentifierBusinessObject
extends AbstractBusinessObject {
    private final Map<SampleIdentifier, SamplePE> sampleByIdentifierCache = new HashMap<SampleIdentifier, SamplePE>();
    private final SampleOwnerFinder sampleOwnerFinder;
    private static final String PROPERTY_TYPES = "sampleType.sampleTypePropertyTypesInternal";
    private static final String EXPERIMENT = "experimentInternal";

    AbstractSampleIdentifierBusinessObject(IDAOFactory daoFactory, Session session, EntityKind entityKind, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, entityKind, managedPropertyEvaluatorFactory);
        this.sampleOwnerFinder = new SampleOwnerFinder(daoFactory, this.findPerson());
    }

    public AbstractSampleIdentifierBusinessObject(IDAOFactory daoFactory, Session session, IEntityPropertiesConverter converter, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, converter, managedPropertyEvaluatorFactory);
        this.sampleOwnerFinder = new SampleOwnerFinder(daoFactory, this.findPerson());
    }

    final SampleOwnerFinder getSampleOwnerFinder() {
        return this.sampleOwnerFinder;
    }

    final SamplePE getSampleByIdentifier(SampleIdentifier sampleIdentifier) throws UserFailureException {
        SamplePE sample = this.tryToGetSampleByIdentifier(sampleIdentifier);
        if (sample == null) {
            throw UserFailureException.fromTemplate("No sample could be found for identifier '%s'.", sampleIdentifier);
        }
        return sample;
    }

    protected SamplePE tryToGetSampleByIdentifier(SampleIdentifier sampleIdentifier) {
        SamplePE result;
        assert (sampleIdentifier != null) : "Sample identifier unspecified.";
        SamplePE cachedResult = this.sampleByIdentifierCache.get(sampleIdentifier);
        if (cachedResult != null) {
            return cachedResult;
        }
        SampleOwner sampleOwner = this.sampleOwnerFinder.figureSampleOwner(sampleIdentifier);
        String sampleCode = sampleIdentifier.getSampleCode();
        ISampleDAO sampleDAO = this.getSampleDAO();
        if (sampleOwner.isDatabaseInstanceLevel()) {
            result = sampleDAO.tryFindByCodeAndDatabaseInstance(sampleCode, sampleOwner.tryGetDatabaseInstance());
        } else {
            assert (sampleOwner.isSpaceLevel()) : "Must be of space level.";
            result = sampleDAO.tryFindByCodeAndSpace(sampleCode, sampleOwner.tryGetSpace());
        }
        if (result != null) {
            HibernateUtils.initialize(result.getExperiment());
            this.sampleByIdentifierCache.put(sampleIdentifier, result);
        }
        return result;
    }

    final SamplePE getSampleByTechId(TechId sampleId) throws UserFailureException {
        SamplePE sample = this.tryToGetSampleByTechId(sampleId);
        if (sample == null) {
            throw UserFailureException.fromTemplate("No sample could be found for ID '%s'.", sampleId);
        }
        return sample;
    }

    protected SamplePE tryToGetSampleByTechId(TechId sampleId) {
        String[] connections = new String[]{PROPERTY_TYPES, EXPERIMENT};
        return (SamplePE)this.getSampleDAO().tryGetByTechId(sampleId, connections);
    }
}

