/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IEntityOperationChecker;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractSampleBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.RelationshipUtils;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleOwner;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.ListSamplesByPropertyCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleBatchUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.LocalExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public final class SampleTable
extends AbstractSampleBusinessObject
implements ISampleTable {
    private List<SamplePE> samples;
    private boolean dataChanged;
    private boolean businessRulesChecked;

    public SampleTable(IDAOFactory daoFactory, Session session, IRelationshipService relationshipService, IEntityOperationChecker entityOperationChecker, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, relationshipService, entityOperationChecker, managedPropertyEvaluatorFactory);
    }

    @Override
    public final void loadSamplesByCriteria(ListSamplesByPropertyCriteria criteria) {
        this.onlyNewSamples = false;
        SpacePE group = this.findGroup(criteria.getSpaceCode());
        List<SamplePE> foundSamples = this.getSampleDAO().listSamplesBySpaceAndProperty(criteria.getPropertyCode(), criteria.getPropertyValue(), group);
        LocalExperimentIdentifier localExperimentIdentifier = criteria.tryGetLocalExperimentIdentifier();
        if (localExperimentIdentifier != null) {
            String experimentPropertyCode = localExperimentIdentifier.tryGetPropertyCode();
            if (experimentPropertyCode != null) {
                foundSamples = this.filterSamplesByExperiment(foundSamples, criteria.getProjectIdentifier(), experimentPropertyCode, localExperimentIdentifier.getPropertyValue());
            } else {
                ExperimentIdentifier ident = new ExperimentIdentifier(criteria.getProjectIdentifier(), localExperimentIdentifier.getExperimentCode());
                foundSamples = this.filterSamplesByExperiment(foundSamples, ident);
            }
        }
        this.samples = foundSamples;
        this.attachmentHolderPermIdToAttachmentsMap = null;
    }

    private List<SamplePE> filterSamplesByExperiment(List<SamplePE> foundSamples, ProjectIdentifier projectIdentifier, String experimentPropertyCode, String propertyValue) {
        ProjectPE project = this.findProject(projectIdentifier);
        ExperimentPE expectedExperiment = this.findExperiment(project, experimentPropertyCode, propertyValue);
        return SampleTable.filterSamplesByExperiment(foundSamples, expectedExperiment);
    }

    private ExperimentPE findExperiment(ProjectPE project, String propertyCode, String propertyValue) {
        List<ExperimentPE> experiments = this.getExperimentDAO().listExperimentsByProjectAndProperty(propertyCode, propertyValue, project);
        if (experiments.size() != 1) {
            throw UserFailureException.fromTemplate("It was expected that there is exactly one experiment in the '%s/%s' project with property '%s' set to '%s', but %d were found!", project.getSpace().getCode(), project.getCode(), propertyCode, propertyValue, experiments.size());
        }
        return experiments.get(0);
    }

    private List<SamplePE> filterSamplesByExperiment(List<SamplePE> foundSamples, ExperimentIdentifier experimentIdentifier) {
        ExperimentPE expectedExperiment = this.findExperiment(experimentIdentifier);
        return SampleTable.filterSamplesByExperiment(foundSamples, expectedExperiment);
    }

    private static List<SamplePE> filterSamplesByExperiment(List<SamplePE> foundSamples, ExperimentPE expectedExperiment) {
        ArrayList<SamplePE> filteredSamples = new ArrayList<SamplePE>();
        for (SamplePE sample : foundSamples) {
            if (!expectedExperiment.equals(sample.getExperiment())) continue;
            filteredSamples.add(sample);
        }
        return filteredSamples;
    }

    private SpacePE findGroup(String groupCode) {
        SpacePE group = this.getSpaceDAO().tryFindSpaceByCodeAndDatabaseInstance(groupCode, this.getHomeDatabaseInstance());
        if (group == null) {
            throw UserFailureException.fromTemplate("No group with the name '%s' found!", groupCode);
        }
        return group;
    }

    @Override
    public final List<SamplePE> getSamples() {
        return this.samples;
    }

    @Override
    public void prepareForRegistration(List<NewSample> newSamples, PersonPE registratorOrNull) throws UserFailureException {
        this.assertInstanceSampleCreationAllowed(newSamples);
        this.onlyNewSamples = true;
        this.samples = new ArrayList<SamplePE>(newSamples.size());
        this.attachmentHolderPermIdToAttachmentsMap = new HashMap(this.samples.size());
        this.setBatchUpdateMode(true);
        HashMap<String, SampleTypePE> sampleTypeCache = new HashMap<String, SampleTypePE>();
        HashMap<String, ExperimentPE> experimentCache = new HashMap<String, ExperimentPE>();
        HashMap<SampleOwnerIdentifier, SampleOwner> sampleOwnerCache = new HashMap<SampleOwnerIdentifier, SampleOwner>();
        for (NewSample sample : newSamples) {
            this.add(sample, sampleTypeCache, sampleOwnerCache, experimentCache, registratorOrNull);
        }
        this.setBatchUpdateMode(false);
    }

    private void add(NewSample newSample, Map<String, SampleTypePE> sampleTypeCache, Map<SampleOwnerIdentifier, SampleOwner> sampleOwnerCache, Map<String, ExperimentPE> experimentCache, PersonPE registratorOrNull) throws UserFailureException {
        assert (newSample != null) : "Unspecified new sample.";
        SamplePE samplePE = this.createSample(newSample, sampleTypeCache, sampleOwnerCache, experimentCache, registratorOrNull);
        this.samples.add(samplePE);
        ArrayList<AttachmentPE> attachments = new ArrayList<AttachmentPE>();
        this.addAttachments(samplePE, newSample.getAttachments(), attachments);
        this.putAttachments(samplePE.getPermId(), attachments);
        this.dataChanged = true;
    }

    @Override
    public void save() throws UserFailureException {
        this.save(false);
    }

    @Override
    public void save(boolean clearCache) throws UserFailureException {
        assert (this.samples != null) : "Samples not loaded.";
        if (this.dataChanged) {
            try {
                if (!this.businessRulesChecked) {
                    this.checkAllBusinessRules();
                }
                this.getSampleDAO().createOrUpdateSamples(this.samples, this.findPerson(), clearCache);
            }
            catch (DataAccessException ex) {
                SampleTable.throwException(ex, String.format("One of samples", new Object[0]));
            }
            this.dataChanged = false;
            this.businessRulesChecked = false;
            this.onlyNewSamples = false;
        }
        this.saveAttachments(this.samples, this.attachmentHolderPermIdToAttachmentsMap);
    }

    private void checkAllBusinessRules() {
        HashMap<EntityTypePE, List<EntityTypePropertyTypePE>> cache = new HashMap<EntityTypePE, List<EntityTypePropertyTypePE>>();
        for (SamplePE s : this.samples) {
            this.checkAllBusinessRules(s, this.getDataDAO(), cache, true);
        }
    }

    private void prepareBatchUpdate(SamplePE sample, List<AttachmentPE> attachments, SampleBatchUpdatesDTO updates, Map<SampleOwnerIdentifier, SampleOwner> sampleOwnerCache, Map<String, ExperimentPE> experimentCache, Map<EntityTypePE, List<EntityTypePropertyTypePE>> propertiesCache) {
        String[] parents;
        if (sample == null) {
            throw UserFailureException.fromTemplate("No sample could be found with given identifier '%s'.", updates.getOldSampleIdentifierOrNull());
        }
        SampleBatchUpdateDetails details = updates.getDetails();
        this.batchUpdateProperties(sample, updates.getProperties(), details.getPropertiesToUpdate());
        this.checkPropertiesBusinessRules(sample, propertiesCache);
        if (details.isExperimentUpdateRequested()) {
            this.updateSpace(sample, updates.getSampleIdentifier(), sampleOwnerCache);
            this.updateExperiment(sample, updates.getExperimentIdentifierOrNull(), experimentCache);
            this.checkExperimentBusinessRules(this.getDataDAO(), sample);
        }
        if (details.isParentsUpdateRequested() && (parents = updates.getModifiedParentCodesOrNull()) != null) {
            this.setParents(sample, parents, updates.tryGetDefaultSpaceIdentifier());
        }
        if (details.isContainerUpdateRequested()) {
            this.setContainer(updates.getSampleIdentifier(), sample, updates.getContainerIdentifierOrNull(), updates.tryGetDefaultSpaceIdentifier());
        }
        this.addAttachments(sample, updates.getAttachments(), attachments);
        if (details.isExperimentUpdateRequested() || details.isParentsUpdateRequested()) {
            this.checkParentBusinessRules(sample);
        }
        if (details.isExperimentUpdateRequested() || details.isContainerUpdateRequested()) {
            this.checkContainerBusinessRules(sample);
        }
    }

    private void prepareBatchUpdate(SamplePE sample, List<AttachmentPE> attachments, SampleUpdatesDTO updates, Map<SampleOwnerIdentifier, SampleOwner> sampleOwnerCache, Map<String, ExperimentPE> experimentCache, Map<EntityTypePE, List<EntityTypePropertyTypePE>> propertiesCache) {
        if (sample == null) {
            throw UserFailureException.fromTemplate("No sample could be found with given identifier '%s'.", updates.getSampleIdentifier());
        }
        this.updateProperties(sample, updates.getProperties());
        this.checkPropertiesBusinessRules(sample, propertiesCache);
        this.updateSpace(sample, updates.getSampleIdentifier(), sampleOwnerCache);
        if (updates.isUpdateExperimentLink()) {
            this.updateExperiment(sample, updates.getExperimentIdentifierOrNull(), experimentCache);
            this.checkExperimentBusinessRules(this.getDataDAO(), sample);
        }
        boolean parentsUpdated = this.updateParents(sample, updates);
        boolean containerUpdated = this.updateContainer(sample, updates);
        this.addAttachments(sample, updates.getAttachments(), attachments);
        if (updates.isUpdateExperimentLink() || parentsUpdated) {
            this.checkParentBusinessRules(sample);
        }
        if (updates.isUpdateExperimentLink() || containerUpdated) {
            this.checkContainerBusinessRules(sample);
        }
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, this.session);
    }

    private boolean updateContainer(SamplePE sample, SampleUpdatesDTO updates) {
        String oldContainerIdentifierOrNull;
        SamplePE container = sample.getContainer();
        String string = oldContainerIdentifierOrNull = container == null ? null : container.getIdentifier();
        if (oldContainerIdentifierOrNull == null ? updates.getContainerIdentifierOrNull() == null : oldContainerIdentifierOrNull.equals(updates.getContainerIdentifierOrNull())) {
            return false;
        }
        this.setContainer(updates.getSampleIdentifier(), sample, updates.getContainerIdentifierOrNull(), null);
        return true;
    }

    private boolean updateParents(SamplePE sample, SampleUpdatesDTO updates) {
        String[] newParents = updates.getModifiedParentCodesOrNull();
        if (newParents == null) {
            return false;
        }
        HashSet<String> oldParentsSet = new HashSet<String>();
        for (SamplePE parent : sample.getParents()) {
            oldParentsSet.add(parent.getCode());
        }
        HashSet<String> newParentsSet = new HashSet<String>();
        newParentsSet.addAll(Arrays.asList(newParents));
        if (oldParentsSet.equals(newParentsSet)) {
            return false;
        }
        this.setParents(sample, newParents, null);
        return true;
    }

    private void updateProperties(SamplePE sample, List<IEntityProperty> properties) {
        Set<SamplePropertyPE> existingProperties = sample.getProperties();
        SampleTypePE type = sample.getSampleType();
        sample.setProperties(this.convertProperties(type, existingProperties, properties, this.extractPropertiesCodes(properties)));
    }

    private void batchUpdateProperties(SamplePE sample, List<IEntityProperty> properties, Set<String> propertiesToUpdate) {
        Set<SamplePropertyPE> existingProperties = sample.getProperties();
        SampleTypePE type = sample.getSampleType();
        PersonPE registrator = this.findPerson();
        sample.setProperties(this.entityPropertiesConverter.updateProperties(existingProperties, type, properties, registrator, propertiesToUpdate));
    }

    @Override
    public void prepareForUpdate(List<SampleBatchUpdatesDTO> updates) {
        assert (updates != null) : "Unspecified samples.";
        this.setBatchUpdateMode(true);
        HashMap<SampleOwnerIdentifier, SampleOwner> sampleOwnerCache = new HashMap<SampleOwnerIdentifier, SampleOwner>();
        HashMap<String, ExperimentPE> experimentCache = new HashMap<String, ExperimentPE>();
        HashMap<EntityTypePE, List<EntityTypePropertyTypePE>> propertiesCache = new HashMap<EntityTypePE, List<EntityTypePropertyTypePE>>();
        this.samples = this.loadSamples(updates, sampleOwnerCache);
        this.attachmentHolderPermIdToAttachmentsMap = new HashMap(this.samples.size());
        this.assertInstanceSampleUpdateAllowed(this.samples);
        HashMap<SampleIdentifier, SamplePE> samplesByIdentifiers = new HashMap<SampleIdentifier, SamplePE>();
        for (SamplePE sample : this.samples) {
            samplesByIdentifiers.put(sample.getSampleIdentifier(), sample);
        }
        for (SampleBatchUpdatesDTO sampleUpdates : updates) {
            SamplePE sample = (SamplePE)samplesByIdentifiers.get(sampleUpdates.getOldSampleIdentifierOrNull());
            ArrayList<AttachmentPE> attachments = new ArrayList<AttachmentPE>();
            this.prepareBatchUpdate(sample, attachments, sampleUpdates, sampleOwnerCache, experimentCache, propertiesCache);
            this.putAttachments(sample.getPermId(), attachments);
        }
        this.dataChanged = true;
        this.businessRulesChecked = true;
        this.setBatchUpdateMode(false);
    }

    @Override
    public void checkBeforeUpdate(List<SampleUpdatesDTO> updates) throws UserFailureException {
        if (updates == null) {
            throw new IllegalArgumentException("Sample updates list cannot be null.");
        }
        HashMap<Long, Integer> versionsMap = new HashMap<Long, Integer>();
        for (SamplePE sample : this.loadSamplesByTechId(updates)) {
            versionsMap.put(sample.getId(), sample.getVersion());
        }
        for (SampleUpdatesDTO update : updates) {
            if (update.getSampleIdOrNull() == null || update.getSampleIdOrNull().getId() == null) {
                throw new UserFailureException("Sample with identifier " + update.getSampleIdentifier() + " doesn't have a specified id and therefore cannot be updated.");
            }
            Integer version = (Integer)versionsMap.get(update.getSampleIdOrNull().getId());
            if (version == null) {
                throw new UserFailureException("Sample with identifier " + update.getSampleIdentifier() + " is not in the database and therefore cannot be updated.");
            }
            if (version.intValue() == update.getVersion()) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("Sample ");
            sb.append(update.getSampleIdentifier());
            sb.append(" has been updated since it was retrieved.\n");
            sb.append("[Current: " + version);
            sb.append(", Retrieved: " + update.getVersion());
            sb.append("]");
            throw new EnvironmentFailureException(sb.toString());
        }
    }

    @Override
    public void prepareForUpdateWithSampleUpdates(List<SampleUpdatesDTO> updates) {
        assert (updates != null) : "Unspecified samples.";
        this.setBatchUpdateMode(true);
        HashMap<SampleOwnerIdentifier, SampleOwner> sampleOwnerCache = new HashMap<SampleOwnerIdentifier, SampleOwner>();
        HashMap<String, ExperimentPE> experimentCache = new HashMap<String, ExperimentPE>();
        HashMap<EntityTypePE, List<EntityTypePropertyTypePE>> propertiesCache = new HashMap<EntityTypePE, List<EntityTypePropertyTypePE>>();
        this.samples = this.loadSamplesByTechId(updates);
        this.attachmentHolderPermIdToAttachmentsMap = new HashMap(this.samples.size());
        this.assertInstanceSampleUpdateAllowed(this.samples);
        HashMap<Long, SamplePE> samplesById = new HashMap<Long, SamplePE>();
        for (SamplePE sample : this.samples) {
            samplesById.put(sample.getId(), sample);
        }
        for (SampleUpdatesDTO sampleUpdates : updates) {
            TechId id = sampleUpdates.getSampleIdOrNull();
            if (id == null) {
                throw new UserFailureException("Sample with identifier " + sampleUpdates.getSampleIdentifier() + " is not in the database and therefore cannot be updated.");
            }
            SamplePE sample = (SamplePE)samplesById.get(id.getId());
            if (sample == null) {
                throw new UserFailureException("Sample with identifier " + sampleUpdates.getSampleIdentifier() + " is not in the database and therefore cannot be updated.");
            }
            ArrayList<AttachmentPE> attachments = new ArrayList<AttachmentPE>();
            this.prepareBatchUpdate(sample, attachments, sampleUpdates, sampleOwnerCache, experimentCache, propertiesCache);
            this.putAttachments(sample.getPermId(), attachments);
        }
        this.dataChanged = true;
        this.businessRulesChecked = true;
        this.setBatchUpdateMode(false);
    }

    private List<SamplePE> loadSamplesByTechId(List<SampleUpdatesDTO> updates) {
        ArrayList<SamplePE> results = new ArrayList<SamplePE>();
        ArrayList<TechId> identifiers = new ArrayList<TechId>();
        for (SampleUpdatesDTO sampleUpdates : updates) {
            TechId id = sampleUpdates.getSampleIdOrNull();
            if (id == null) continue;
            identifiers.add(id);
        }
        results.addAll(this.listSamplesByTechIds(identifiers));
        return results;
    }

    private List<SamplePE> loadSamples(List<SampleBatchUpdatesDTO> updates, Map<SampleOwnerIdentifier, SampleOwner> sampleOwnerCache) {
        ArrayList<SamplePE> results = new ArrayList<SamplePE>();
        ArrayList<SampleIdentifier> identifiers = new ArrayList<SampleIdentifier>();
        for (SampleBatchUpdatesDTO sampleUpdates : updates) {
            SampleIdentifier identifier = sampleUpdates.getOldSampleIdentifierOrNull();
            identifiers.add(identifier);
        }
        results.addAll(this.listSamplesByIdentifiers(identifiers, sampleOwnerCache));
        return results;
    }

    @Override
    public void deleteByTechIds(List<TechId> sampleIds, String reason) throws UserFailureException {
        try {
            this.getSessionFactory().getCurrentSession().flush();
            this.getSessionFactory().getCurrentSession().clear();
            this.getSampleDAO().delete(sampleIds, this.session.tryGetPerson(), reason);
        }
        catch (DataAccessException ex) {
            SampleTable.throwException(ex, "Sample", EntityKind.SAMPLE);
        }
    }
}

