/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.VocabularyTermWithStats;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.StatelessSession;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

final class EntityPropertyTypeDAO
extends AbstractDAO
implements IEntityPropertyTypeDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, EntityPropertyTypeDAO.class);
    private final EntityKind entityKind;
    private final IDynamicPropertyEvaluationScheduler dynamicPropertyEvaluationScheduler;

    public EntityPropertyTypeDAO(EntityKind entityKind, PersistencyResources persistencyResources, DatabaseInstancePE databaseInstance) {
        super(persistencyResources.getSessionFactory(), databaseInstance);
        this.entityKind = entityKind;
        this.dynamicPropertyEvaluationScheduler = persistencyResources.getDynamicPropertyEvaluationScheduler();
    }

    private final <T extends EntityTypePropertyTypePE> Class<T> getEntityTypePropertyTypeAssignmentClass() {
        return this.entityKind.getEntityTypePropertyTypeAssignmentClass();
    }

    @Override
    public final List<EntityTypePropertyTypePE> listEntityPropertyTypes(EntityTypePE entityType) throws DataAccessException {
        assert (entityType != null) : "Unspecified EntityType";
        List<EntityTypePropertyTypePE> assignments = EntityPropertyTypeDAO.cast(this.getHibernateTemplate().find(String.format("from %s etpt where etpt.entityTypeInternal = ?", this.getEntityTypePropertyTypeAssignmentClass().getSimpleName()), EntityPropertyTypeDAO.toArray(entityType)));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d assignments have been found for entity type '%s'.", assignments.size(), entityType));
        }
        return assignments;
    }

    @Override
    public List<String> listPropertyTypeCodes() throws DataAccessException {
        List<EntityTypePropertyTypePE> assignments = EntityPropertyTypeDAO.cast(this.getHibernateTemplate().loadAll(this.getEntityTypePropertyTypeAssignmentClass()));
        HashSet<String> propertyTypeCodes = new HashSet<String>();
        for (EntityTypePropertyTypePE assignment : assignments) {
            propertyTypeCodes.add(assignment.getPropertyType().getCode());
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d property types have been found for entity kind '%s'.", new Object[]{propertyTypeCodes.size(), this.entityKind}));
        }
        return new ArrayList<String>(propertyTypeCodes);
    }

    @Override
    public EntityTypePropertyTypePE tryFindAssignment(EntityTypePE entityType, PropertyTypePE propertyType) {
        assert (entityType != null) : "Unspecified entity type.";
        assert (propertyType != null) : "Unspecified property type.";
        Criteria criteria = this.getSession().createCriteria(this.getEntityTypePropertyTypeAssignmentClass());
        criteria.add((Criterion)Restrictions.eq((String)"propertyTypeInternal", (Object)propertyType));
        criteria.add((Criterion)Restrictions.eq((String)"entityTypeInternal", (Object)entityType));
        EntityTypePropertyTypePE etpt = (EntityTypePropertyTypePE)criteria.uniqueResult();
        return etpt;
    }

    @Override
    public final void createEntityPropertyTypeAssignment(EntityTypePropertyTypePE entityPropertyTypeAssignement) throws DataAccessException {
        assert (entityPropertyTypeAssignement != null) : "Unspecified EntityTypePropertyType";
        EntityPropertyTypeDAO.validatePE(entityPropertyTypeAssignement);
        HibernateTemplate template = this.getHibernateTemplate();
        template.save((Object)entityPropertyTypeAssignement);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info("ADD: assignment of property '" + entityPropertyTypeAssignement.getPropertyType().getCode() + "' with entity type '" + entityPropertyTypeAssignement.getEntityType().getCode() + "'.");
        }
    }

    @Override
    public List<Long> listEntityIds(EntityTypePE entityType) throws DataAccessException {
        assert (entityType != null) : "Unspecified entity type.";
        DetachedCriteria criteria = DetachedCriteria.forClass(this.entityKind.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)this.entityKind.getEntityTypeFieldName(), (Object)entityType));
        criteria.setProjection((Projection)Projections.id());
        List<Long> list = EntityPropertyTypeDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("LIST: found %s ids of entities of type '%s'.", list.size(), entityType));
        }
        return list;
    }

    @Override
    public void scheduleDynamicPropertiesEvaluation(EntityTypePropertyTypePE assignment) throws DataAccessException {
        assert (assignment != null) : "Unspecified assignment.";
        if (assignment.isDynamic()) {
            List<Long> entityIds = this.listEntityIds(assignment);
            this.scheduleDynamicPropertiesEvaluation(entityIds);
        }
    }

    private List<Long> listEntityIds(EntityTypePropertyTypePE assignment) throws DataAccessException {
        assert (assignment != null) : "Unspecified assignment.";
        String query = null;
        switch (this.entityKind) {
            case SAMPLE: {
                query = String.format("SELECT DISTINCT sample.id FROM SamplePE sample, SampleTypePropertyTypePE stpt WHERE sample.sampleType = stpt.entityTypeInternal AND stpt = ?", new Object[0]);
                break;
            }
            case DATA_SET: {
                query = String.format("SELECT DISTINCT data.id FROM DataPE data, DataSetTypePropertyTypePE dtpt WHERE data.dataSetType = dtpt.entityTypeInternal AND dtpt = ?", new Object[0]);
                break;
            }
            case MATERIAL: {
                query = String.format("SELECT DISTINCT material.id FROM MaterialPE material, MaterialTypePropertyTypePE mtpt WHERE material.materialType = mtpt.entityTypeInternal AND mtpt = ?", new Object[0]);
                break;
            }
            case EXPERIMENT: {
                query = String.format("SELECT DISTINCT experiment.id FROM ExperimentPE experiment, ExperimentTypePropertyTypePE etpt WHERE experiment.experimentType = etpt.entityTypeInternal AND etpt = ?", new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.entityKind.toString());
            }
        }
        List<Long> list = EntityPropertyTypeDAO.cast(this.getHibernateTemplate().find(query, EntityPropertyTypeDAO.toArray(assignment)));
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("LIST: found %s ids of entities of type '%s' assigned to property '%s'.", list.size(), assignment.getEntityType(), assignment.getPropertyType()));
        }
        return list;
    }

    @Override
    public List<Long> listIdsOfEntitiesWithoutPropertyValue(EntityTypePropertyTypePE assignment) throws DataAccessException {
        assert (assignment != null) : "Unspecified assignment.";
        String query = String.format("SELECT e.id FROM %s e WHERE e.%s = ? AND e not in (SELECT p.entity FROM %s p WHERE p.entityTypePropertyType = ?)", this.entityKind.getEntityClass().getSimpleName(), this.entityKind.getEntityTypeFieldName(), this.entityKind.getEntityPropertyClass().getSimpleName());
        List<Long> list = EntityPropertyTypeDAO.cast(this.getHibernateTemplate().find(query, EntityPropertyTypeDAO.toArray(assignment.getEntityType(), assignment)));
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("LIST: found %s ids of entities of type '%s' assigned to property '%s'.", list.size(), assignment.getEntityType(), assignment.getPropertyType()));
        }
        return list;
    }

    @Override
    public void createProperties(EntityPropertyPE property, List<Long> entityIds) {
        Object valueObject;
        String valueColumn;
        assert (property != null) : "Given property data can not be null.";
        final Long etptId = property.getEntityTypePropertyType().getId();
        final Long registratorId = property.getRegistrator().getId();
        EntityKindPropertyTableNames propertyTableNames = EntityPropertyTypeDAO.getEntityKindPropertyTableNames(this.entityKind);
        String tableName = propertyTableNames.getPropertiesTable();
        String sequenceName = propertyTableNames.getPropertiesSequence();
        String entityColumn = propertyTableNames.getEntityColumn();
        String propertyTypeColumn = propertyTableNames.getPropertyTypeColumn();
        if (property.getVocabularyTerm() != null) {
            valueColumn = "cvte_id";
            valueObject = property.getVocabularyTerm().getId();
        } else if (property.getMaterialValue() != null) {
            valueColumn = "mate_prop_id";
            valueObject = property.getMaterialValue().getId();
        } else {
            assert (property.getValue() != null);
            valueColumn = "value";
            valueObject = property.getValue();
        }
        final String sql = String.format("INSERT INTO %s (id, pers_id_registerer, pers_id_author, %s, %s, %s) VALUES (nextval('%s'), :registratorId, :registratorId, :entityId, :etptId, :value)", tableName, entityColumn, propertyTypeColumn, valueColumn, sequenceName);
        this.executeStatelessAction(new AbstractDAO.StatelessHibernateCallback((Serializable)valueObject, entityIds, property){
            private final /* synthetic */ Serializable val$valueObject;
            private final /* synthetic */ List val$entityIds;
            private final /* synthetic */ EntityPropertyPE val$property;
            {
                this.val$valueObject = serializable;
                this.val$entityIds = list;
                this.val$property = entityPropertyPE;
            }

            @Override
            public Object doInStatelessSession(StatelessSession session) {
                SQLQuery sqlQuery = session.createSQLQuery(sql);
                sqlQuery.setParameter("registratorId", (Object)registratorId);
                sqlQuery.setParameter("etptId", (Object)etptId);
                sqlQuery.setParameter("value", (Object)this.val$valueObject);
                int counter = 0;
                for (Long entityId : this.val$entityIds) {
                    sqlQuery.setParameter("entityId", (Object)entityId);
                    sqlQuery.executeUpdate();
                    if (operationLog.isDebugEnabled()) {
                        operationLog.debug(String.format("Created property '%s' for %s with id %s", this.val$property, EntityPropertyTypeDAO.this.entityKind.getLabel(), entityId));
                    }
                    if (++counter % 1000 != 0) continue;
                    operationLog.info(String.format("%d %s properties have been created...", counter, EntityPropertyTypeDAO.this.entityKind.getLabel()));
                    if (!operationLog.isDebugEnabled()) continue;
                    operationLog.debug(EntityPropertyTypeDAO.this.getMemoryUsageMessage());
                }
                return null;
            }
        });
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("Created %s %s properties : %s", entityIds.size(), this.entityKind.getLabel(), property));
        }
        this.scheduleDynamicPropertiesEvaluation(entityIds);
    }

    private String getMemoryUsageMessage() {
        Runtime runtime = Runtime.getRuntime();
        long mb = 0x100000L;
        long totalMemory = runtime.totalMemory() / mb;
        long freeMemory = runtime.freeMemory() / mb;
        long maxMemory = runtime.maxMemory() / mb;
        return "MEMORY (in MB): free:" + freeMemory + " total:" + totalMemory + " max:" + maxMemory;
    }

    @Override
    public void fillTermUsageStatistics(List<VocabularyTermWithStats> termsWithStats, VocabularyPE vocabulary) {
        assert (termsWithStats != null) : "Unspecified terms.";
        assert (vocabulary != null) : "Unspecified vocabulary.";
        assert (termsWithStats.size() == vocabulary.getTerms().size()) : "Sizes of terms to be filled and vocabulary terms don't match.";
        HashMap<Long, VocabularyTermWithStats> termsById = new HashMap<Long, VocabularyTermWithStats>(termsWithStats.size());
        for (VocabularyTermWithStats termWithStats : termsWithStats) {
            Long id = termWithStats.getTerm().getId();
            termsById.put(id, termWithStats);
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(this.entityKind.getEntityPropertyClass());
        criteria.createAlias("vocabularyTerm", "term");
        criteria.add((Criterion)Restrictions.eq((String)"term.vocabularyInternal", (Object)vocabulary));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add(Projections.rowCount());
        projectionList.add((Projection)Projections.groupProperty((String)"term.id"));
        criteria.setProjection((Projection)projectionList);
        List<Object[]> results = EntityPropertyTypeDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        for (Object[] result : results) {
            Integer numberOfUsages = ((Number)result[0]).intValue();
            Long termId = (Long)result[1];
            ((VocabularyTermWithStats)termsById.get(termId)).registerUsage(this.entityKind, numberOfUsages.intValue());
        }
    }

    @Override
    public List<EntityPropertyPE> listPropertiesByVocabularyTerm(String vocabularyTermCode) {
        String query = String.format("from %s props join fetch props.entity where props.vocabularyTerm.code = ?", this.entityKind.getEntityPropertyClass().getSimpleName());
        List<EntityPropertyPE> properties = EntityPropertyTypeDAO.cast(this.getHibernateTemplate().find(query, EntityPropertyTypeDAO.toArray(vocabularyTermCode)));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Term '%s' is used in %d properties of kind %s.", new Object[]{vocabularyTermCode, properties.size(), this.entityKind}));
        }
        return properties;
    }

    @Override
    public void updateProperties(List<EntityPropertyPE> properties) {
        HibernateTemplate template = this.getHibernateTemplate();
        for (EntityPropertyPE entityProperty : properties) {
            template.save((Object)entityProperty);
        }
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info("UPDATE: " + properties.size() + " of kind " + (Object)((Object)this.entityKind) + " updated.");
        }
    }

    @Override
    public void increaseOrdinals(EntityTypePE entityType, Long fromOrdinal, int increment) {
        assert (entityType != null) : "Unspecified entity type.";
        assert (fromOrdinal != null) : "Unspecified ordinal.";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        String query = String.format("UPDATE %s etpt SET etpt.ordinal = etpt.ordinal + ? WHERE etpt.entityTypeInternal = ? AND etpt.ordinal >= ?", this.entityKind.getEntityTypePropertyTypeAssignmentClass().getSimpleName());
        int updatedRows = hibernateTemplate.bulkUpdate(query, EntityPropertyTypeDAO.toArray(new Long(increment), entityType, fromOrdinal));
        hibernateTemplate.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.debug(String.format("%d etpt(s) updated for entity type '%s' with ordinal increased by %d.", updatedRows, entityType.getCode(), increment));
        }
    }

    @Override
    public Long getMaxOrdinal(EntityTypePE entityType) {
        assert (entityType != null) : "Unspecified entity type.";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        String query = String.format("select max(etpt.ordinal) from %s etpt WHERE etpt.entityTypeInternal = ?", this.entityKind.getEntityTypePropertyTypeAssignmentClass().getSimpleName());
        List resultList = EntityPropertyTypeDAO.cast(hibernateTemplate.find(query, (Object)entityType));
        Long maxOrdinal = (Long)resultList.get(0);
        return maxOrdinal == null ? 0L : maxOrdinal;
    }

    @Override
    public final void validateAndSaveUpdatedEntity(EntityTypePropertyTypePE entity) {
        assert (entity != null) : "entity is null";
        EntityPropertyTypeDAO.validatePE(entity);
        this.getHibernateTemplate().flush();
    }

    @Override
    public int countAssignmentValues(String entityTypeCode, String propertyTypeCode) {
        assert (entityTypeCode != null) : "Unspecified entity type.";
        assert (propertyTypeCode != null) : "Unspecified property type.";
        String query = String.format("SELECT count(pv) FROM %s pa join pa.propertyValues pv WHERE pa.propertyTypeInternal.simpleCode = ? AND pa.entityTypeInternal.code = ?", this.entityKind.getEntityTypePropertyTypeAssignmentClass().getSimpleName());
        return ((Long)this.getHibernateTemplate().find(query, EntityPropertyTypeDAO.toArray(propertyTypeCode, entityTypeCode)).get(0)).intValue();
    }

    @Override
    public void delete(EntityTypePropertyTypePE assignment) {
        HibernateTemplate template = this.getHibernateTemplate();
        List<Long> entityIds = this.listEntityIds(assignment);
        template.bulkUpdate(String.format("DELETE FROM %s WHERE entityTypePropertyType = ?", this.entityKind.getEntityPropertyClass().getSimpleName()), (Object)assignment);
        template.flush();
        template.clear();
        template.delete((Object)assignment);
        this.scheduleDynamicPropertiesEvaluation(entityIds);
        if (operationLog.isInfoEnabled()) {
            operationLog.info("DELETE: assignment between " + (Object)((Object)this.entityKind) + " of type " + assignment.getEntityType().getCode() + " and property type " + assignment.getPropertyType().getCode());
        }
    }

    private void scheduleDynamicPropertiesEvaluation(List<Long> entityIds) {
        EntityPropertyTypeDAO.scheduleDynamicPropertiesEvaluationForIds(this.dynamicPropertyEvaluationScheduler, EntityPropertyTypeDAO.getIndexedEntityClass(this.entityKind), entityIds);
    }

    private static <T extends IEntityInformationWithPropertiesHolder> Class<T> getIndexedEntityClass(EntityKind entityKind) {
        switch (entityKind) {
            case DATA_SET: {
                return EntityPropertyTypeDAO.cast(ExternalDataPE.class);
            }
        }
        return entityKind.getEntityClass();
    }

    private static EntityKindPropertyTableNames getEntityKindPropertyTableNames(EntityKind entityKind) {
        switch (entityKind) {
            case DATA_SET: {
                return new EntityKindPropertyTableNames("data_set_properties", "DATA_SET_PROPERTY_ID_SEQ", "dstpt_id", "ds_id");
            }
            case EXPERIMENT: {
                return new EntityKindPropertyTableNames("experiment_properties", "EXPERIMENT_PROPERTY_ID_SEQ", "etpt_id", "expe_id");
            }
            case MATERIAL: {
                return new EntityKindPropertyTableNames("material_properties", "MATERIAL_PROPERTY_ID_SEQ", "mtpt_id", "mate_id");
            }
            case SAMPLE: {
                return new EntityKindPropertyTableNames("sample_properties", "SAMPLE_PROPERTY_ID_SEQ", "stpt_id", "samp_id");
            }
        }
        return null;
    }

    private static class EntityKindPropertyTableNames {
        private final String propertiesTable;
        private final String propertiesSequence;
        private final String propertyTypeColumn;
        private final String entityColumn;

        public EntityKindPropertyTableNames(String propertiesTable, String propertiesSequence, String propertyTypeColumn, String entityColumn) {
            this.propertiesTable = propertiesTable;
            this.propertiesSequence = propertiesSequence;
            this.propertyTypeColumn = propertyTypeColumn;
            this.entityColumn = entityColumn;
        }

        public String getPropertiesTable() {
            return this.propertiesTable;
        }

        public String getPropertiesSequence() {
            return this.propertiesSequence;
        }

        public String getPropertyTypeColumn() {
            return this.propertyTypeColumn;
        }

        public String getEntityColumn() {
            return this.entityColumn;
        }
    }
}

