/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CharacterHelper {
    private static final char ESCAPE_CHARACTER = '\\';
    public static final Set<Character> SPECIAL_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('.'), Character.valueOf(':'), Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('\'')));
    private static final Set<Character> TRIMMED_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('.'), Character.valueOf(':'), Character.valueOf('\'')));

    public static boolean isTokenCharacter(char c) {
        return Character.isLetterOrDigit(c) || SPECIAL_CHARACTERS.contains(Character.valueOf(c));
    }

    public static Collection<Character> getTokenSeparators() {
        HashSet<Character> separators = new HashSet<Character>();
        char ch = ' ';
        while (ch < '\u0100') {
            if (!CharacterHelper.isTokenCharacter(ch) && ch != '\\') {
                separators.add(Character.valueOf(ch));
            }
            ch = (char)(ch + '\u0001');
        }
        return separators;
    }

    public static Set<Character> getTrimmedSpecialCharacters() {
        return TRIMMED_CHARACTERS;
    }
}

