/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.SimpleFreeSpaceProvider;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractDatastorePlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IStatusChecker;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiverTaskContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IArchiverPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDeleter;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetStatusUpdater;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareFinder;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IUnarchivingPreparation;
import ch.systemsx.cisd.openbis.dss.generic.shared.IncomingShareIdProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ProcessingStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.QueueingDataSetStatusUpdaterService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.StandardShareFinder;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetCodesWithStatus;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.SegmentedStoreUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.Share;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import ch.systemsx.cisd.openbis.generic.shared.translator.SimpleDataSetHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractArchiverProcessingPlugin
extends AbstractDatastorePlugin
implements IArchiverPlugin {
    private static final long serialVersionUID = 1L;
    @Private
    public static final String SHARE_FINDER_KEY = "share-finder";
    public static final String SYNCHRONIZE_ARCHIVE = "synchronize-archive";
    public static final String BATCH_SIZE_IN_BYTES = "batch-size-in-bytes";
    public static final String TEMP_FOLDER = "temp-folder";
    private final IStatusChecker archivePrerequisiteOrNull;
    private final IStatusChecker unarchivePrerequisiteOrNull;
    private final boolean synchronizeArchive;
    private final File tempFolder;
    private transient IShareIdManager shareIdManager;
    private transient IEncapsulatedOpenBISService service;
    @Private
    transient IDataSetStatusUpdater statusUpdater;
    private final long maximumBatchSizeInBytes;

    public AbstractArchiverProcessingPlugin(Properties properties, File storeRoot, IStatusChecker archivePrerequisiteOrNull, IStatusChecker unarchivePrerequisiteOrNull) {
        super(properties, storeRoot);
        this.archivePrerequisiteOrNull = archivePrerequisiteOrNull;
        this.unarchivePrerequisiteOrNull = unarchivePrerequisiteOrNull;
        this.synchronizeArchive = PropertyUtils.getBoolean(properties, SYNCHRONIZE_ARCHIVE, true);
        this.maximumBatchSizeInBytes = PropertyUtils.getLong(properties, BATCH_SIZE_IN_BYTES, 0x40000000L);
        this.tempFolder = PropertyUtils.getDirectory(properties, TEMP_FOLDER, null);
    }

    protected abstract DatasetProcessingStatuses doArchive(List<DatasetDescription> var1, ArchiverTaskContext var2);

    protected abstract DatasetProcessingStatuses doUnarchive(List<DatasetDescription> var1, ArchiverTaskContext var2);

    protected abstract DatasetProcessingStatuses doDeleteFromArchive(List<? extends IDatasetLocation> var1);

    protected abstract BooleanStatus isDataSetSynchronizedWithArchive(DatasetDescription var1, ArchiverTaskContext var2);

    protected abstract BooleanStatus isDataSetPresentInArchive(DatasetDescription var1);

    @Override
    public ProcessingStatus archive(List<DatasetDescription> datasets, ArchiverTaskContext context, boolean removeFromDataStore) {
        operationLog.info((Object)("Archiving of the following datasets has been requested: " + CollectionUtils.abbreviate(datasets, 10)));
        DatasetProcessingStatuses finalstatuses = new DatasetProcessingStatuses();
        try {
            this.initializeDatasetSizesIfNeeded(datasets);
        }
        catch (Throwable t) {
            String errorMessage = "Archiving failed to calculate dataset sizes:" + t.getMessage();
            operationLog.error((Object)errorMessage, t);
            Status errorStatus = Status.createError(errorMessage);
            return AbstractArchiverProcessingPlugin.createStatuses(errorStatus, datasets, Operation.ARCHIVE).getProcessingStatus();
        }
        for (List<DatasetDescription> datasetGroup : this.splitIntoGroups(datasets)) {
            DatasetProcessingStatuses statuses = this.archiveSingleBatch(context, removeFromDataStore, finalstatuses, datasetGroup);
            finalstatuses.addResults(statuses);
        }
        return finalstatuses.getProcessingStatus();
    }

    protected List<List<DatasetDescription>> splitIntoGroups(List<DatasetDescription> datasets) {
        LinkedList<List<DatasetDescription>> results = new LinkedList<List<DatasetDescription>>();
        LinkedList<DatasetDescription> currentResult = new LinkedList<DatasetDescription>();
        long runningSum = 0L;
        for (DatasetDescription dataset : datasets) {
            if (dataset.getDataSetSize() > this.maximumBatchSizeInBytes) {
                results.add(Collections.singletonList(dataset));
                continue;
            }
            currentResult.add(dataset);
            if ((runningSum += dataset.getDataSetSize().longValue()) <= this.maximumBatchSizeInBytes) continue;
            results.add(currentResult);
            runningSum = 0L;
            currentResult = new LinkedList();
        }
        if (!currentResult.isEmpty()) {
            results.add(currentResult);
        }
        return results;
    }

    private DatasetProcessingStatuses archiveSingleBatch(ArchiverTaskContext context, boolean removeFromDataStore, DatasetProcessingStatuses finalstatuses, List<DatasetDescription> singleBatch) {
        DatasetProcessingStatuses statuses = this.safeArchive(singleBatch, context, removeFromDataStore);
        DataSetArchivingStatus successStatus = removeFromDataStore ? DataSetArchivingStatus.ARCHIVED : DataSetArchivingStatus.AVAILABLE;
        this.asyncUpdateStatuses(statuses.getSuccessfulDatasetCodes(), successStatus, true);
        this.asyncUpdateStatuses(statuses.getFailedDatasetCodes(), DataSetArchivingStatus.AVAILABLE, false);
        return statuses;
    }

    private void initializeDatasetSizesIfNeeded(List<DatasetDescription> datasets) {
        for (DatasetDescription dataset : datasets) {
            if (dataset.getDataSetSize() != null) continue;
            String dataSetCode = dataset.getDataSetCode();
            String shareId = this.getShareIdManager().getShareId(dataSetCode);
            File shareFolder = new File(this.storeRoot, shareId);
            String dataSetLocation = dataset.getDataSetLocation();
            long size = FileUtils.sizeOfDirectory((File)new File(shareFolder, dataSetLocation));
            this.getService().updateShareIdAndSize(dataSetCode, shareId, size);
            dataset.setDataSetSize(size);
        }
    }

    private DatasetProcessingStatuses safeArchive(List<DatasetDescription> datasets, ArchiverTaskContext context, boolean removeFromDataStore) {
        Status prerequisiteStatus = this.checkArchivePrerequisite(datasets);
        DatasetProcessingStatuses statuses = null;
        if (prerequisiteStatus.isError()) {
            statuses = AbstractArchiverProcessingPlugin.createStatuses(prerequisiteStatus, datasets, Operation.ARCHIVE);
        } else {
            try {
                statuses = this.unsafeArchive(datasets, context, removeFromDataStore);
            }
            catch (Throwable t) {
                String errorMessage = "Archiving failed :" + t.getMessage();
                operationLog.error((Object)errorMessage, t);
                Status errorStatus = Status.createError(errorMessage);
                statuses = AbstractArchiverProcessingPlugin.createStatuses(errorStatus, datasets, Operation.ARCHIVE);
            }
        }
        return statuses;
    }

    private DatasetProcessingStatuses unsafeArchive(List<DatasetDescription> datasets, ArchiverTaskContext context, boolean removeFromDataStore) {
        GroupedDatasets groupedDataSets = this.groupByArchiveDifferencies(datasets, context);
        DatasetProcessingStatuses statuses = this.doArchive(groupedDataSets.getDifferentInArchive(), context);
        this.deletePermanentlyFromArchive(this.getDataSetsFailedToBeArchived(datasets, statuses));
        if (removeFromDataStore) {
            this.removeFromDataStore(this.getArchivedDataSets(datasets, statuses), context);
        }
        statuses.addResult(groupedDataSets.getUpToDateInArchive(), Status.OK, Operation.ARCHIVE);
        return statuses;
    }

    private GroupedDatasets groupByArchiveDifferencies(List<DatasetDescription> datasets, ArchiverTaskContext context) {
        ArrayList<DatasetDescription> upToDateInArchive = new ArrayList<DatasetDescription>();
        ArrayList<DatasetDescription> differentInArchive = new ArrayList<DatasetDescription>();
        for (DatasetDescription dataset : datasets) {
            BooleanStatus upToDateStatus = this.synchronizeArchive ? this.isDataSetSynchronizedWithArchive(dataset, context) : this.isDataSetPresentInArchive(dataset);
            (upToDateStatus.isSuccess() ? upToDateInArchive : differentInArchive).add(dataset);
        }
        return new GroupedDatasets(upToDateInArchive, differentInArchive);
    }

    private List<DatasetDescription> getDataSetsFailedToBeArchived(List<DatasetDescription> datasets, DatasetProcessingStatuses statuses) {
        HashSet<String> dataSetsFailedToArchive = new HashSet<String>(statuses.getFailedDatasetCodes());
        ArrayList<DatasetDescription> failedDataSets = new ArrayList<DatasetDescription>();
        for (DatasetDescription dataSet : datasets) {
            if (!dataSetsFailedToArchive.contains(dataSet.getDataSetCode())) continue;
            failedDataSets.add(dataSet);
        }
        return failedDataSets;
    }

    private List<DatasetDescription> getArchivedDataSets(List<DatasetDescription> datasets, DatasetProcessingStatuses statuses) {
        HashSet<String> dataSetsFailedToArchive = new HashSet<String>(statuses.getFailedDatasetCodes());
        ArrayList<DatasetDescription> archivedDataSets = new ArrayList<DatasetDescription>();
        for (DatasetDescription dataSet : datasets) {
            if (dataSetsFailedToArchive.contains(dataSet.getDataSetCode())) continue;
            archivedDataSets.add(dataSet);
        }
        return archivedDataSets;
    }

    protected void removeFromDataStore(List<DatasetDescription> datasets, ArchiverTaskContext context) {
        IDataSetDeleter dataSetDeleter = ServiceProvider.getDataStoreService().getDataSetDeleter();
        dataSetDeleter.scheduleDeletionOfDataSets(datasets, 11, 10L);
    }

    @Override
    public ProcessingStatus unarchive(List<DatasetDescription> datasets, ArchiverTaskContext context) {
        operationLog.info((Object)("Unarchiving of the following datasets has been requested: " + CollectionUtils.abbreviate(datasets, 10)));
        DatasetProcessingStatuses statuses = this.safeUnarchive(datasets, context);
        this.asyncUpdateStatuses(statuses.getSuccessfulDatasetCodes(), DataSetArchivingStatus.AVAILABLE, true);
        this.asyncUpdateStatuses(statuses.getFailedDatasetCodes(), DataSetArchivingStatus.ARCHIVED, true);
        return statuses.getProcessingStatus();
    }

    private void setUpUnarchivingPreparation(ArchiverTaskContext context) {
        context.setUnarchivingPreparation(this.getUnarchivingPreparation());
    }

    protected IUnarchivingPreparation getUnarchivingPreparation() {
        String dataStoreCode = ServiceProvider.getConfigProvider().getDataStoreCode();
        Set<String> incomingShares = IncomingShareIdProvider.getIdsOfIncomingShares();
        IFreeSpaceProvider freeSpaceProvider = this.createFreeSpaceProvider();
        List<Share> shares = SegmentedStoreUtils.getSharesWithDataSets(this.storeRoot, dataStoreCode, SegmentedStoreUtils.FilterOptions.ALL, incomingShares, freeSpaceProvider, this.getService(), new Log4jSimpleLogger(operationLog));
        return new UnarchivingPreparation(this.getShareFinder(), this.getShareIdManager(), this.getService(), shares);
    }

    protected IFreeSpaceProvider createFreeSpaceProvider() {
        return new SimpleFreeSpaceProvider();
    }

    private DatasetProcessingStatuses safeUnarchive(List<DatasetDescription> datasets, ArchiverTaskContext context) {
        Status prerequisiteStatus = this.checkUnarchivePrerequisite(datasets);
        DatasetProcessingStatuses statuses = null;
        if (prerequisiteStatus.isError()) {
            statuses = AbstractArchiverProcessingPlugin.createStatuses(prerequisiteStatus, datasets, Operation.UNARCHIVE);
        } else {
            try {
                this.setUpUnarchivingPreparation(context);
                statuses = this.doUnarchive(datasets, context);
            }
            catch (Throwable t) {
                String errorMessage = "Unarchiving failed: " + t.getMessage();
                operationLog.error((Object)errorMessage, t);
                Status errorStatus = Status.createError(errorMessage);
                statuses = AbstractArchiverProcessingPlugin.createStatuses(errorStatus, datasets, Operation.UNARCHIVE);
            }
        }
        return statuses;
    }

    @Override
    public ProcessingStatus deleteFromArchive(List<DatasetLocation> datasets) {
        DatasetProcessingStatuses status = this.doDeleteFromArchive(datasets);
        return status != null ? status.getProcessingStatus() : null;
    }

    protected DatasetProcessingStatuses deletePermanentlyFromArchive(List<? extends IDatasetLocation> dataSets) {
        return this.doDeleteFromArchive(dataSets);
    }

    protected final Status checkUnarchivePrerequisite(List<DatasetDescription> datasets) {
        if (this.unarchivePrerequisiteOrNull != null) {
            return this.unarchivePrerequisiteOrNull.check(datasets.size());
        }
        return Status.OK;
    }

    protected final Status checkArchivePrerequisite(List<DatasetDescription> datasets) {
        if (this.archivePrerequisiteOrNull != null) {
            return this.archivePrerequisiteOrNull.check(datasets.size());
        }
        return Status.OK;
    }

    protected static final DatasetProcessingStatuses createStatuesFailIfAnyFailed(DatasetProcessingStatuses statuses) {
        if (statuses.getFailedDatasetCodes().isEmpty()) {
            return statuses;
        }
        DatasetProcessingStatuses result = new DatasetProcessingStatuses();
        ProcessingStatus otherProcessingStatus = statuses.getProcessingStatus();
        for (Status error : otherProcessingStatus.getErrorStatuses()) {
            for (String datasetCode : otherProcessingStatus.getDatasetsByStatus(error)) {
                result.addResultQuietly(datasetCode, error);
            }
        }
        for (String datasetCode : otherProcessingStatus.getDatasetsByStatus(Status.OK)) {
            result.addResultQuietly(datasetCode, Status.createError("Successful, but part of a failed batch."));
        }
        return result;
    }

    protected static final DatasetProcessingStatuses createStatuses(Status status, List<DatasetDescription> datasets, Operation operation) {
        return AbstractArchiverProcessingPlugin.createStatuses(status, datasets, operation.getDescription());
    }

    protected static final DatasetProcessingStatuses createStatuses(Status status, List<DatasetDescription> datasets, String operationDescription) {
        DatasetProcessingStatuses statuses = new DatasetProcessingStatuses();
        for (DatasetDescription dataset : datasets) {
            statuses.addResult(dataset.getDataSetCode(), status, operationDescription);
        }
        return statuses;
    }

    private void asyncUpdateStatuses(List<String> dataSetCodes, DataSetArchivingStatus newStatus, boolean presentInArchive) {
        if (dataSetCodes.isEmpty()) {
            return;
        }
        if (this.statusUpdater == null) {
            this.statusUpdater = new IDataSetStatusUpdater(){

                @Override
                public void update(List<String> codes, DataSetArchivingStatus status, boolean present) {
                    QueueingDataSetStatusUpdaterService.update(new DataSetCodesWithStatus(codes, status, present));
                }
            };
        }
        this.statusUpdater.update(dataSetCodes, newStatus, presentInArchive);
    }

    protected IShareIdManager getShareIdManager() {
        if (this.shareIdManager == null) {
            this.shareIdManager = ServiceProvider.getShareIdManager();
        }
        return this.shareIdManager;
    }

    protected File getTemporaryFolder() {
        return this.tempFolder;
    }

    protected IShareFinder getShareFinder() {
        Properties props = PropertyParametersUtil.extractSingleSectionProperties(this.properties, SHARE_FINDER_KEY, false).getProperties();
        String className = props.getProperty("class");
        if (StringUtils.isEmpty((String)className)) {
            className = StandardShareFinder.class.getName();
        }
        IShareFinder shareFinder = ClassUtils.create(IShareFinder.class, className, props);
        return shareFinder;
    }

    protected IEncapsulatedOpenBISService getService() {
        if (this.service == null) {
            this.service = ServiceProvider.getOpenBISService();
        }
        return this.service;
    }

    protected void setStatusUpdater(IDataSetStatusUpdater statusUpdater) {
        this.statusUpdater = statusUpdater;
    }

    protected void setShareIdManager(IShareIdManager shareIdManager) {
        this.shareIdManager = shareIdManager;
    }

    protected void setService(IEncapsulatedOpenBISService service) {
        this.service = service;
    }

    public long getMaximumBatchSizeInBytes() {
        return this.maximumBatchSizeInBytes;
    }

    @Override
    public List<String> getDataSetCodesForUnarchiving(List<String> dataSetCodes) {
        return dataSetCodes;
    }

    protected static class DatasetProcessingStatuses {
        private final List<String> successfulDatasetCodes = new ArrayList<String>();
        private final List<String> failedDatasetCodes = new ArrayList<String>();
        private final ProcessingStatus processingStatus = new ProcessingStatus();

        public void addResults(DatasetProcessingStatuses otherStatuses) {
            ProcessingStatus otherProcessingStatus = otherStatuses.getProcessingStatus();
            for (String datasetCode : otherProcessingStatus.getDatasetsByStatus(Status.OK)) {
                this.addResultQuietly(datasetCode, Status.OK);
            }
            for (Status error : otherProcessingStatus.getErrorStatuses()) {
                for (String datasetCode : otherProcessingStatus.getDatasetsByStatus(error)) {
                    this.addResultQuietly(datasetCode, error);
                }
            }
        }

        public void addResult(Collection<DatasetDescription> datasets, Status status, Operation operation) {
            for (DatasetDescription dataset : datasets) {
                this.addResult(dataset.getDataSetCode(), status, operation.getDescription());
            }
        }

        public void addResult(String datasetCode, Status status, Operation operation) {
            this.addResult(datasetCode, status, operation.getDescription());
        }

        public void addResult(String datasetCode, Status status, String operationDescription) {
            String logMessage = this.createLogMessage(datasetCode, status, operationDescription);
            if (status.isError()) {
                notifyLog.error((Object)logMessage);
                this.failedDatasetCodes.add(datasetCode);
            } else {
                operationLog.debug((Object)logMessage);
                this.successfulDatasetCodes.add(datasetCode);
            }
            this.processingStatus.addDatasetStatus(datasetCode, status);
        }

        private void addResultQuietly(String datasetCode, Status status) {
            if (status.isError()) {
                this.failedDatasetCodes.add(datasetCode);
            } else {
                this.successfulDatasetCodes.add(datasetCode);
            }
            this.processingStatus.addDatasetStatus(datasetCode, status);
        }

        private String createLogMessage(String datasetCode, Status status, String operation) {
            return String.format("%s for dataset %s finished with the status: %s.", operation, datasetCode, status);
        }

        public List<String> getSuccessfulDatasetCodes() {
            return this.successfulDatasetCodes;
        }

        public List<String> getFailedDatasetCodes() {
            return this.failedDatasetCodes;
        }

        public ProcessingStatus getProcessingStatus() {
            return this.processingStatus;
        }
    }

    protected static class GroupedDatasets {
        private List<DatasetDescription> upToDateInArchive;
        private List<DatasetDescription> differentInArchive;

        GroupedDatasets(List<DatasetDescription> upToDateInArchive, List<DatasetDescription> differentInArchive) {
            this.upToDateInArchive = upToDateInArchive;
            this.differentInArchive = differentInArchive;
        }

        public List<DatasetDescription> getUpToDateInArchive() {
            return this.upToDateInArchive;
        }

        public List<DatasetDescription> getDifferentInArchive() {
            return this.differentInArchive;
        }
    }

    protected static enum Operation {
        ARCHIVE("Archiving"),
        UNARCHIVE("Unarchiving"),
        DELETE_FROM_ARCHIVE("Deleting from archive"),
        MARK_AS_DELETED("Marking as deleted");

        private final String description;

        private Operation(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static final class UnarchivingPreparation
    implements IUnarchivingPreparation {
        private final IShareFinder shareFinder;
        private final IEncapsulatedOpenBISService service;
        private final List<Share> shares;
        private final IShareIdManager shareIdManager;

        UnarchivingPreparation(IShareFinder shareFinder, IShareIdManager shareIdManager, IEncapsulatedOpenBISService service, List<Share> shares) {
            this.shareFinder = shareFinder;
            this.shareIdManager = shareIdManager;
            this.service = service;
            this.shares = shares;
        }

        @Override
        public void prepareForUnarchiving(List<DatasetDescription> dataSets) {
            for (DatasetDescription datasetDescription : dataSets) {
                this.findAndUpdateShareForDataset(datasetDescription);
            }
        }

        protected void findAndUpdateShareForDataset(DatasetDescription dataSet) {
            SimpleDataSetInformationDTO translatedDataSet = SimpleDataSetHelper.translate(dataSet);
            String dataSetCode = dataSet.getDataSetCode();
            translatedDataSet.setDataSetShareId(null);
            Share share = this.shareFinder.tryToFindShare(translatedDataSet, this.shares);
            if (share != null) {
                String oldShareId = this.shareIdManager.getShareId(dataSetCode);
                String newShareId = share.getShareId();
                if (!newShareId.equals(oldShareId)) {
                    this.service.updateShareIdAndSize(dataSetCode, newShareId, dataSet.getDataSetSize());
                    this.shareIdManager.setShareId(dataSetCode, newShareId);
                }
            } else {
                throw ConfigurationFailureException.fromTemplate("Unarchiving of data set '%s' has failed, because no appropriate destination share was found. Most probably there is not enough free space in the data store.", dataSetCode);
            }
        }
    }
}

