/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProcessingStatus {
    private Map<Status, List<String>> datasetByStatus = new LinkedHashMap<Status, List<String>>();

    public void addDatasetStatus(String datasetCode, Status status) {
        List<String> datasets = this.datasetByStatus.get(status);
        if (datasets == null) {
            datasets = new ArrayList<String>();
            this.datasetByStatus.put(status, datasets);
        }
        datasets.add(datasetCode);
    }

    public List<Status> getErrorStatuses() {
        ArrayList<Status> result = new ArrayList<Status>(this.datasetByStatus.keySet());
        result.remove(Status.OK);
        return result;
    }

    public List<String> getDatasetsByStatus(Status status) {
        if (this.datasetByStatus.containsKey(status)) {
            return this.datasetByStatus.get(status);
        }
        return Collections.emptyList();
    }

    public void addDatasetStatus(DatasetDescription dataset, Status status) {
        this.addDatasetStatus(dataset.getDataSetCode(), status);
    }

    public void addDatasetStatuses(List<DatasetDescription> datasets, Status status) {
        for (DatasetDescription dataset : datasets) {
            this.addDatasetStatus(dataset, status);
        }
    }

    public Status tryGetStatusByDataset(String datasetCode) {
        for (Map.Entry<Status, List<String>> entry : this.datasetByStatus.entrySet()) {
            if (!entry.getValue().contains(datasetCode)) continue;
            return entry.getKey();
        }
        return null;
    }
}

