/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISearchDomainSearcher;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFileSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityPropertySearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ISearchDomainResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomain;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchDomainSearchResultWithFullEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SearchDomainSearcher
extends AbstractBusinessObject
implements ISearchDomainSearcher {
    private static final Map<Long, Set<Metaproject>> EMPTY_METAPROJECTS = Collections.emptyMap();
    private static final IKeyExtractor<String, IEntityInformationHolderWithPermId> PERM_ID_EXTRACTOR = new IKeyExtractor<String, IEntityInformationHolderWithPermId>(){

        @Override
        public String getKey(IEntityInformationHolderWithPermId e) {
            return e.getPermId();
        }
    };
    private final IDataStoreServiceFactory dssFactory;

    public SearchDomainSearcher(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, IDataStoreServiceFactory dssFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
        this.dssFactory = dssFactory;
    }

    @Override
    public List<SearchDomain> listAvailableSearchDomains() {
        ArrayList<SearchDomain> result = new ArrayList<SearchDomain>();
        List<DataStorePE> stores = this.getDataStoreDAO().listDataStores();
        for (DataStorePE dataStore : stores) {
            IDataStoreService service = SearchDomainSearcher.tryGetDataStoreService(dataStore, this.dssFactory);
            if (service == null) continue;
            result.addAll(service.listAvailableSearchDomains(dataStore.getSessionToken()));
        }
        return result;
    }

    @Override
    public List<SearchDomainSearchResultWithFullEntity> searchForEntitiesWithSequences(String preferredSearchDomainOrNull, String sequenceSnippet, Map<String, String> optionalParametersOrNull) {
        List<SearchDomainSearchResult> searchResults = this.askAllDataStoreServers(preferredSearchDomainOrNull, sequenceSnippet, optionalParametersOrNull);
        return this.enrichWithEntities(searchResults);
    }

    private List<SearchDomainSearchResult> askAllDataStoreServers(String preferredSearchDomainOrNull, String sequenceSnippet, Map<String, String> optionalParametersOrNull) {
        ArrayList<SearchDomainSearchResult> result = new ArrayList<SearchDomainSearchResult>();
        List<DataStorePE> stores = this.getDataStoreDAO().listDataStores();
        for (DataStorePE dataStore : stores) {
            IDataStoreService service = SearchDomainSearcher.tryGetDataStoreService(dataStore, this.dssFactory);
            if (service == null) continue;
            result.addAll(service.searchForEntitiesWithSequences(dataStore.getSessionToken(), preferredSearchDomainOrNull, sequenceSnippet, optionalParametersOrNull));
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    private List<SearchDomainSearchResultWithFullEntity> enrichWithEntities(List<SearchDomainSearchResult> searchResults) {
        Map<EntityLoader, List<String>> map = this.separate(searchResults);
        Map<EntityLoader, TableMap<String, IEntityInformationHolderWithPermId>> result = this.loadEntities(map);
        ArrayList<SearchDomainSearchResultWithFullEntity> enrichedResults = new ArrayList<SearchDomainSearchResultWithFullEntity>();
        for (SearchDomainSearchResult searchResult : searchResults) {
            Selector selector = new Selector(searchResult.getResultLocation());
            EntityLoader loader = selector.getLoader();
            IEntityInformationHolderWithPermId entity = result.get((Object)loader).getOrDie(selector.getPermId());
            SearchDomainSearchResultWithFullEntity searchResultWithEntity = new SearchDomainSearchResultWithFullEntity();
            searchResultWithEntity.setSearchResult(searchResult);
            searchResultWithEntity.setEntity(entity);
            enrichedResults.add(searchResultWithEntity);
        }
        return enrichedResults;
    }

    private Map<EntityLoader, List<String>> separate(List<SearchDomainSearchResult> searchResults) {
        EnumMap<EntityLoader, List<String>> map = new EnumMap<EntityLoader, List<String>>(EntityLoader.class);
        for (SearchDomainSearchResult searchResult : searchResults) {
            ISearchDomainResultLocation resultLocation = searchResult.getResultLocation();
            Selector selector = new Selector(resultLocation);
            EntityLoader loader = selector.getLoader();
            ArrayList<String> list = (ArrayList<String>)map.get((Object)loader);
            if (list == null) {
                list = new ArrayList<String>();
                map.put(loader, list);
            }
            list.add(selector.getPermId());
        }
        return map;
    }

    private Map<EntityLoader, TableMap<String, IEntityInformationHolderWithPermId>> loadEntities(Map<EntityLoader, List<String>> map) {
        EnumMap<EntityLoader, TableMap<String, IEntityInformationHolderWithPermId>> result = new EnumMap<EntityLoader, TableMap<String, IEntityInformationHolderWithPermId>>(EntityLoader.class);
        Set<Map.Entry<EntityLoader, List<String>>> entrySet = map.entrySet();
        for (Map.Entry<EntityLoader, List<String>> entry : entrySet) {
            EntityLoader loader = entry.getKey();
            List<String> permIds = entry.getValue();
            List<IEntityInformationHolderWithPermId> entities = loader.loadEntities(this, this.managedPropertyEvaluatorFactory, permIds);
            result.put(loader, new TableMap<String, IEntityInformationHolderWithPermId>(entities, PERM_ID_EXTRACTOR));
        }
        return result;
    }

    private static enum EntityLoader {
        SAMPLE{

            @Override
            public List<? extends IEntityInformationHolderWithPermId> doLoadEntities(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory evaluatorFactory, List<String> permIds) {
                List<SamplePE> samples = daoFactory.getSampleDAO().listByPermID(new HashSet<String>(permIds));
                return SampleTranslator.translate(samples, "", EMPTY_METAPROJECTS, evaluatorFactory);
            }
        }
        ,
        DATA_SET{

            @Override
            public List<? extends IEntityInformationHolderWithPermId> doLoadEntities(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory evaluatorFactory, List<String> permIds) {
                List<DataPE> dataSets = daoFactory.getDataDAO().listByCode(new HashSet<String>(permIds));
                return DataSetTranslator.translate(dataSets, "", "", EMPTY_METAPROJECTS, evaluatorFactory);
            }
        }
        ,
        EXPERIMENT{

            @Override
            public List<? extends IEntityInformationHolderWithPermId> doLoadEntities(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory evaluatorFactory, List<String> permIds) {
                List<ExperimentPE> experiments = daoFactory.getExperimentDAO().listByPermID(new HashSet<String>(permIds));
                return ExperimentTranslator.translate(experiments, "", EMPTY_METAPROJECTS, evaluatorFactory);
            }
        }
        ,
        MATERIAL{

            @Override
            public List<? extends IEntityInformationHolderWithPermId> doLoadEntities(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory evaluatorFactory, List<String> permIds) {
                throw new UnsupportedOperationException();
            }
        };


        public List<IEntityInformationHolderWithPermId> loadEntities(IDAOFactory daoFactory, IManagedPropertyEvaluatorFactory evaluatorFactory, List<String> permIds) {
            ArrayList<IEntityInformationHolderWithPermId> result = new ArrayList<IEntityInformationHolderWithPermId>();
            for (IEntityInformationHolderWithPermId iEntityInformationHolderWithPermId : this.doLoadEntities(daoFactory, evaluatorFactory, permIds)) {
                result.add(iEntityInformationHolderWithPermId);
            }
            return result;
        }

        public abstract List<? extends IEntityInformationHolderWithPermId> doLoadEntities(IDAOFactory var1, IManagedPropertyEvaluatorFactory var2, List<String> var3);
    }

    private static final class Selector {
        private EntityLoader loader = EntityLoader.DATA_SET;
        private String permId = null;

        Selector(ISearchDomainResultLocation resultLocation) {
            if (resultLocation instanceof DataSetFileSearchResultLocation) {
                this.permId = ((DataSetFileSearchResultLocation)resultLocation).getDataSetCode();
            } else if (resultLocation instanceof EntityPropertySearchResultLocation) {
                EntityPropertySearchResultLocation location = (EntityPropertySearchResultLocation)resultLocation;
                this.permId = location.getPermId();
                this.loader = EntityLoader.valueOf(location.getEntityKind().toString());
            }
        }

        EntityLoader getLoader() {
            return this.loader;
        }

        String getPermId() {
            return this.permId;
        }
    }
}

