/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity.ExperimentProjectSpaceCodeRecord;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity.ISecondaryEntityListingQuery;
import ch.systemsx.cisd.openbis.generic.server.business.bo.common.entity.SampleReferenceRecord;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.QueryTool;
import org.springframework.dao.EmptyResultDataAccessException;

@Friend(toClasses={SampleReferenceRecord.class, ExperimentProjectSpaceCodeRecord.class, ISecondaryEntityListingQuery.class})
public class SecondaryEntityDAO {
    private final ISecondaryEntityListingQuery query;
    private final DatabaseInstance databaseInstance;

    public static SecondaryEntityDAO create(IDAOFactory daoFactory) {
        ISecondaryEntityListingQuery query = (ISecondaryEntityListingQuery)QueryTool.getManagedQuery(ISecondaryEntityListingQuery.class);
        return SecondaryEntityDAO.create(daoFactory, query);
    }

    @Private
    public static SecondaryEntityDAO create(IDAOFactory daoFactory, ISecondaryEntityListingQuery query) {
        return new SecondaryEntityDAO(query, daoFactory.getHomeDatabaseInstance());
    }

    private SecondaryEntityDAO(ISecondaryEntityListingQuery query, DatabaseInstancePE databaseInstancePE) {
        this.query = query;
        this.databaseInstance = DatabaseInstanceTranslator.translate(databaseInstancePE);
    }

    public Experiment tryGetExperiment(long experimentId) {
        ExperimentProjectSpaceCodeRecord record = this.query.getExperimentAndProjectAndGroupCodeForId(experimentId);
        if (record == null) {
            throw new EmptyResultDataAccessException(1);
        }
        return this.tryCreateExperiment(experimentId, record);
    }

    private Experiment tryCreateExperiment(long experimentId, ExperimentProjectSpaceCodeRecord record) {
        if (!record.dbin_id.equals(this.databaseInstance.getId())) {
            return null;
        }
        Space space = new Space();
        space.setCode(record.spc_code);
        space.setInstance(this.databaseInstance);
        Experiment experiment = new Experiment();
        experiment.setId(experimentId);
        experiment.setCode(record.e_code);
        experiment.setPermId(record.e_permid);
        experiment.setIdentifier(new ExperimentIdentifier(null, space.getCode(), record.p_code, record.e_code).toString());
        experiment.setDeletion(SecondaryEntityDAO.createDeletion(record.del_id));
        Project project = new Project();
        project.setId(record.p_id);
        project.setPermId(record.p_perm_id);
        project.setCode(record.p_code);
        project.setIdentifier(new ProjectIdentifier(space.getCode(), record.p_code).toString());
        project.setSpace(space);
        experiment.setProject(project);
        ExperimentType experimentType = new ExperimentType();
        experimentType.setCode(record.et_code);
        experiment.setExperimentType(experimentType);
        return experiment;
    }

    public Person getPerson(long personId) {
        Person registrator = this.query.getPersonById(personId);
        if (registrator == null) {
            throw new EmptyResultDataAccessException(1);
        }
        registrator.setUserId(registrator.getUserId());
        registrator.setEmail(registrator.getEmail());
        registrator.setFirstName(registrator.getFirstName());
        registrator.setLastName(registrator.getLastName());
        registrator.setDatabaseInstance(this.databaseInstance);
        return registrator;
    }

    public Long getSampleTypeIdForSampleTypeCode(String sampleTypeCode) {
        Long id = this.query.getSampleTypeIdForSampleTypeCode(sampleTypeCode, this.databaseInstance.getId());
        if (id == null) {
            throw UserFailureException.fromTemplate("No sample type with code '%s' could be found in the database.", sampleTypeCode);
        }
        return id;
    }

    public Space[] getAllSpaces(long databaseInstanceId) {
        return this.query.getAllSpaces(databaseInstanceId);
    }

    public long getGroupIdForCode(String groupCode) {
        return this.query.getGroupIdForCode(groupCode);
    }

    public Long2ObjectMap<Sample> getSamples(LongSet sampleIds) {
        DataIterator<SampleReferenceRecord> sampleRecords = this.query.getSamples(sampleIds);
        Long2ObjectOpenHashMap result = new Long2ObjectOpenHashMap();
        for (SampleReferenceRecord record : sampleRecords) {
            result.put(record.id, (Object)SecondaryEntityDAO.createSample(record, this.databaseInstance));
        }
        return result;
    }

    public LongSet getSampleDescendantIdsAndSelf(Long sampleId) {
        LongOpenHashSet results = new LongOpenHashSet();
        LongOpenHashSet currentLayer = new LongOpenHashSet();
        currentLayer.add((Object)sampleId);
        while (!currentLayer.isEmpty()) {
            results.addAll((LongCollection)currentLayer);
            LongOpenHashSet nextLayer = new LongOpenHashSet(this.query.getChildrenIds((LongSet)currentLayer));
            nextLayer.removeAll((LongCollection)results);
            currentLayer = nextLayer;
        }
        return results;
    }

    private static Sample createSample(SampleReferenceRecord record, DatabaseInstance databaseInstance) {
        Sample sample = new Sample();
        sample.setId(record.id);
        sample.setCode(IdentifierHelper.convertCode(record.s_code, record.c_code));
        sample.setSampleType(SecondaryEntityDAO.createSampleType(record.st_code, databaseInstance));
        sample.setDeletion(SecondaryEntityDAO.createDeletion(record.del_id));
        sample.setSpace(SecondaryEntityDAO.tryCreateGroup(record.spc_code, databaseInstance));
        sample.setDatabaseInstance(SecondaryEntityDAO.tryGetDatabaseInstance(record.spc_code, databaseInstance));
        sample.setPermId(record.perm_id);
        sample.setIdentifier(SecondaryEntityDAO.createIdentifier(sample).toString());
        return sample;
    }

    private static SampleIdentifier createIdentifier(Sample sample) {
        return IdentifierHelper.createSampleIdentifier(sample);
    }

    private static DatabaseInstance tryGetDatabaseInstance(String groupCodeOrNull, DatabaseInstance databaseInstance) {
        if (groupCodeOrNull == null) {
            return databaseInstance;
        }
        return null;
    }

    private static Space tryCreateGroup(String codeOrNull, DatabaseInstance databaseInstance) {
        if (codeOrNull == null) {
            return null;
        }
        Space space = new Space();
        space.setCode(codeOrNull);
        space.setInstance(databaseInstance);
        return space;
    }

    private static Deletion createDeletion(Long deletionIdOrNull) {
        if (deletionIdOrNull == null) {
            return null;
        }
        return new Deletion();
    }

    private static SampleType createSampleType(String code, DatabaseInstance databaseInstance) {
        SampleType sampleType = new SampleType();
        sampleType.setCode(code);
        sampleType.setDatabaseInstance(databaseInstance);
        return sampleType;
    }
}

