/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractTypeDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

final class EntityTypeDAO
extends AbstractTypeDAO<EntityTypePE>
implements IEntityTypeDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, EntityTypeDAO.class);
    private final EntityKind entityKind;

    EntityTypeDAO(EntityKind entityKind, SessionFactory sessionFactory, DatabaseInstancePE databaseInstance) {
        super(sessionFactory, databaseInstance, entityKind.getTypeClass());
        this.entityKind = entityKind;
    }

    @Override
    public final EntityTypePE tryToFindEntityTypeByCode(String code) throws DataAccessException {
        return (EntityTypePE)super.tryFindTypeByCode(code);
    }

    @Override
    public final <T extends EntityTypePE> List<T> listEntityTypes() throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"databaseInstance", (Object)this.getDatabaseInstance()));
        String entityKindName = this.entityKind.getLabel();
        criteria.setFetchMode(String.valueOf(entityKindName) + "TypePropertyTypesInternal", FetchMode.JOIN);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List list = EntityTypeDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        return list;
    }

    @Override
    public final <T extends EntityTypePE> void createOrUpdateEntityType(T entityType) throws DataAccessException {
        assert (entityType != null) : "entityType is null";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        EntityTypeDAO.validatePE(entityType);
        entityType.setCode(CodeConverter.tryToDatabase(entityType.getCode()));
        hibernateTemplate.saveOrUpdate(entityType);
        hibernateTemplate.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("ADD: entity type '%s'.", entityType));
        }
    }

    @Override
    public final <T extends EntityTypePE> void deleteEntityType(T entityType) {
        assert (entityType != null) : "Entity Type unspecified";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        hibernateTemplate.delete(entityType);
        hibernateTemplate.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("DELETE: entity type '%s'.", entityType));
        }
    }
}

