/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISpaceDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

final class SpaceDAO
extends AbstractGenericEntityDAO<SpacePE>
implements ISpaceDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SpaceDAO.class);

    SpaceDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance) {
        super(sessionFactory, databaseInstance, SpacePE.class);
    }

    @Override
    public final SpacePE tryFindSpaceByCodeAndDatabaseInstance(String spaceCode, DatabaseInstancePE databaseInstance) throws DataAccessException {
        assert (spaceCode != null) : "Unspecified space code.";
        assert (databaseInstance != null) : "Unspecified database instance.";
        List list = SpaceDAO.cast(this.getHibernateTemplate().find(String.format("select g from %s g where g.code = ? and g.databaseInstance = ?", this.getEntityClass().getSimpleName()), SpaceDAO.toArray(CodeConverter.tryToDatabase(spaceCode), databaseInstance)));
        SpacePE entity = (SpacePE)SpaceDAO.tryFindEntity(list, "space", new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s, %s): '%s'.", MethodUtils.getCurrentMethod().getName(), spaceCode, databaseInstance, entity));
        }
        return entity;
    }

    @Override
    public final List<SpacePE> listSpaces() throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.setFetchMode("registrator", FetchMode.JOIN);
        List<SpacePE> list = SpaceDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(): %d space(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public final List<SpacePE> listSpaces(DatabaseInstancePE databaseInstance) throws DataAccessException {
        assert (databaseInstance != null) : "Unspecified database instance.";
        DetachedCriteria criteria = DetachedCriteria.forClass(this.getEntityClass());
        criteria.setFetchMode("registrator", FetchMode.JOIN);
        criteria.add((Criterion)Restrictions.eq((String)"databaseInstance", (Object)databaseInstance));
        List<SpacePE> list = SpaceDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s(%s): %d space(s) have been found.", MethodUtils.getCurrentMethod().getName(), databaseInstance, list.size()));
        }
        return list;
    }

    @Override
    public final void createSpace(SpacePE space) throws DataAccessException {
        assert (space != null) : "Unspecified space";
        SpaceDAO.validatePE(space);
        HibernateTemplate template = this.getHibernateTemplate();
        space.setCode(CodeConverter.tryToDatabase(space.getCode()));
        template.save((Object)space);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("ADD: space '%s'.", space));
        }
    }
}

