/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.managed;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.managed.TransactionRegistry;
import org.apache.commons.dbcp.managed.XAConnectionFactory;

public class LocalXAConnectionFactory
implements XAConnectionFactory {
    protected TransactionRegistry transactionRegistry;
    protected ConnectionFactory connectionFactory;

    public LocalXAConnectionFactory(TransactionManager transactionManager, ConnectionFactory connectionFactory) {
        if (transactionManager == null) {
            throw new NullPointerException("transactionManager is null");
        }
        if (connectionFactory == null) {
            throw new NullPointerException("connectionFactory is null");
        }
        this.transactionRegistry = new TransactionRegistry(transactionManager);
        this.connectionFactory = connectionFactory;
    }

    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    public Connection createConnection() throws SQLException {
        Connection connection = this.connectionFactory.createConnection();
        LocalXAResource localXAResource = new LocalXAResource(connection);
        this.transactionRegistry.registerConnection(connection, localXAResource);
        return connection;
    }

    protected static class LocalXAResource
    implements XAResource {
        private final Connection connection;
        private Xid currentXid;
        private boolean originalAutoCommit;

        public LocalXAResource(Connection connection) {
            this.connection = connection;
        }

        public synchronized Xid getXid() {
            return this.currentXid;
        }

        public synchronized void start(Xid xid, int n) throws XAException {
            if (n == 0) {
                if (this.currentXid != null) {
                    throw new XAException("Already enlisted in another transaction with xid " + xid);
                }
                try {
                    this.originalAutoCommit = this.connection.getAutoCommit();
                }
                catch (SQLException sQLException) {
                    this.originalAutoCommit = true;
                }
                try {
                    this.connection.setAutoCommit(false);
                }
                catch (SQLException sQLException) {
                    throw (XAException)new XAException("Count not turn off auto commit for a XA transaction").initCause(sQLException);
                }
                this.currentXid = xid;
            } else if (n == 0x8000000) {
                if (xid != this.currentXid) {
                    throw new XAException("Attempting to resume in different transaction: expected " + this.currentXid + ", but was " + xid);
                }
            } else {
                throw new XAException("Unknown start flag " + n);
            }
        }

        public synchronized void end(Xid xid, int n) throws XAException {
            if (xid == null) {
                throw new NullPointerException("xid is null");
            }
            if (!this.currentXid.equals(xid)) {
                throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
            }
        }

        public synchronized int prepare(Xid xid) {
            try {
                if (this.connection.isReadOnly()) {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                    return 3;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return 0;
        }

        public synchronized void commit(Xid xid, boolean bl) throws XAException {
            if (xid == null) {
                throw new NullPointerException("xid is null");
            }
            if (!this.currentXid.equals(xid)) {
                throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
            }
            try {
                if (this.connection.isClosed()) {
                    throw new XAException("Conection is closed");
                }
                if (!this.connection.isReadOnly()) {
                    this.connection.commit();
                }
            }
            catch (SQLException sQLException) {
                throw (XAException)new XAException().initCause(sQLException);
            }
            finally {
                try {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                }
                catch (SQLException sQLException) {}
                this.currentXid = null;
            }
        }

        public synchronized void rollback(Xid xid) throws XAException {
            if (xid == null) {
                throw new NullPointerException("xid is null");
            }
            if (!this.currentXid.equals(xid)) {
                throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
            }
            try {
                this.connection.rollback();
            }
            catch (SQLException sQLException) {
                throw (XAException)new XAException().initCause(sQLException);
            }
            finally {
                try {
                    this.connection.setAutoCommit(this.originalAutoCommit);
                }
                catch (SQLException sQLException) {}
                this.currentXid = null;
            }
        }

        public boolean isSameRM(XAResource xAResource) {
            return this == xAResource;
        }

        public synchronized void forget(Xid xid) {
            if (xid != null && this.currentXid.equals(xid)) {
                this.currentXid = null;
            }
        }

        public Xid[] recover(int n) {
            return new Xid[0];
        }

        public int getTransactionTimeout() {
            return 0;
        }

        public boolean setTransactionTimeout(int n) {
            return false;
        }
    }
}

