/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import java.io.File;
import java.io.IOException;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;

public abstract class ArchiverException
extends RuntimeException {
    private final String fileOrObjectPath;
    private static final long serialVersionUID = 1L;

    protected ArchiverException(String objectPath, String operationName, String detailedMsg) {
        super("Error " + operationName + " object '" + objectPath + "': " + detailedMsg, null);
        this.fileOrObjectPath = objectPath;
    }

    protected ArchiverException(String objectPath, String operationName, HDF5Exception cause) {
        super("Error " + operationName + " object '" + objectPath + "' [" + ((Object)((Object)cause)).getClass().getSimpleName() + "]: " + cause.getMessage(), cause);
        this.fileOrObjectPath = objectPath;
    }

    protected ArchiverException(String objectPath, String operationName, RuntimeException cause) {
        super("Error " + operationName + " object '" + objectPath + "' [" + cause.getClass().getSimpleName() + "]: " + cause.getMessage(), cause);
        this.fileOrObjectPath = objectPath;
    }

    protected ArchiverException(File file, String operationName, IOExceptionUnchecked cause) {
        this(file, operationName, cause.getCause());
    }

    protected ArchiverException(File file, String operationName, IOException cause) {
        super("Error " + operationName + " file '" + file + "' [IO]: " + cause.getMessage(), cause);
        this.fileOrObjectPath = file.getAbsolutePath();
    }

    protected ArchiverException(String filePath, String operationName, IOException cause) {
        super("Error " + operationName + " on reading input stream for object  '" + filePath + "' [IO]: " + cause.getMessage(), cause);
        this.fileOrObjectPath = filePath;
    }

    public final String getFileOrObjectPath() {
        return this.fileOrObjectPath;
    }
}

