/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.ImageTools;
import loci.formats.codec.CompressionType;
import loci.formats.gui.AWTImageTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import loci.formats.tiff.TiffSaver;
import ome.xml.model.primitives.PositiveFloat;

public class TiffWriter
extends FormatWriter {
    public static final String COMPRESSION_UNCOMPRESSED = CompressionType.UNCOMPRESSED.getCompression();
    public static final String COMPRESSION_LZW = CompressionType.LZW.getCompression();
    public static final String COMPRESSION_J2K = CompressionType.J2K.getCompression();
    public static final String COMPRESSION_J2K_LOSSY = CompressionType.J2K_LOSSY.getCompression();
    public static final String COMPRESSION_JPEG = CompressionType.JPEG.getCompression();
    protected boolean isBigTiff;
    protected TiffSaver tiffSaver;
    protected RandomAccessInputStream in;
    private boolean checkParams = true;

    private void formatCompression(IFD ifd) throws FormatException {
        if (this.compression == null) {
            this.compression = "";
        }
        TiffCompression compressType = TiffCompression.UNCOMPRESSED;
        if (this.compression.equals(COMPRESSION_LZW)) {
            compressType = TiffCompression.LZW;
        } else if (this.compression.equals(COMPRESSION_J2K)) {
            compressType = TiffCompression.JPEG_2000;
        } else if (this.compression.equals(COMPRESSION_J2K_LOSSY)) {
            compressType = TiffCompression.JPEG_2000_LOSSY;
        } else if (this.compression.equals(COMPRESSION_JPEG)) {
            compressType = TiffCompression.JPEG;
        }
        Object v = ifd.get(new Integer(259));
        if (v == null) {
            ifd.put(new Integer(259), compressType.getCode());
        }
    }

    public TiffWriter() {
        this("Tagged Image File Format", new String[]{"tif", "tiff"});
    }

    public TiffWriter(String format, String[] exts) {
        super(format, exts);
        this.compressionTypes = new String[]{COMPRESSION_UNCOMPRESSED, COMPRESSION_LZW, COMPRESSION_J2K, COMPRESSION_J2K_LOSSY, COMPRESSION_JPEG};
        this.isBigTiff = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        TiffWriter tiffWriter = this;
        synchronized (tiffWriter) {
            this.setupTiffSaver();
        }
    }

    public void saveBytes(int no, byte[] buf, IFD ifd) throws IOException, FormatException {
        MetadataRetrieve r = this.getMetadataRetrieve();
        int w = (Integer)r.getPixelsSizeX(this.series).getValue();
        int h = (Integer)r.getPixelsSizeY(this.series).getValue();
        this.saveBytes(no, buf, ifd, 0, 0, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBytes(int no, byte[] buf, IFD ifd, int x, int y, int w, int h) throws IOException, FormatException {
        if (this.checkParams) {
            this.checkParams(no, buf, x, y, w, h);
        }
        if (ifd == null) {
            ifd = new IFD();
        }
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        int type = FormatTools.pixelTypeFromString(retrieve.getPixelsType(this.series).toString());
        int index = no;
        TiffWriter tiffWriter = this;
        synchronized (tiffWriter) {
            TiffSaver tiffSaver = this.tiffSaver;
            synchronized (tiffSaver) {
                index = this.prepareToWriteImage(no, buf, ifd, x, y, w, h);
                if (index == -1) {
                    return;
                }
            }
        }
        this.tiffSaver.writeImage(buf, ifd, index, type, x, y, w, h, no == this.getPlaneCount() - 1 && this.getSeries() == retrieve.getImageCount() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int prepareToWriteImage(int no, byte[] buf, IFD ifd, int x, int y, int w, int h) throws IOException, FormatException {
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        Boolean bigEndian = retrieve.getPixelsBinDataBigEndian(this.series, 0);
        boolean littleEndian = bigEndian == null ? false : bigEndian == false;
        TiffWriter tiffWriter = this;
        synchronized (tiffWriter) {
            if (no < this.initialized[this.series].length && !this.initialized[this.series][no]) {
                this.initialized[this.series][no] = true;
                RandomAccessInputStream tmp = new RandomAccessInputStream(this.currentId);
                if (tmp.length() == 0L) {
                    TiffWriter tiffWriter2 = this;
                    synchronized (tiffWriter2) {
                        this.tiffSaver.writeHeader();
                    }
                }
                tmp.close();
            }
        }
        int c = this.getSamplesPerPixel();
        int type = FormatTools.pixelTypeFromString(retrieve.getPixelsType(this.series).toString());
        int bytesPerPixel = FormatTools.getBytesPerPixel(type);
        int blockSize = w * h * c * bytesPerPixel;
        if (blockSize > buf.length) {
            c = buf.length / (w * h * bytesPerPixel);
        }
        if (bytesPerPixel > 1 && c != 1 && c != 3) {
            this.checkParams = false;
            if (no == 0) {
                this.initialized[this.series] = new boolean[this.initialized[this.series].length * c];
            }
            for (int i = 0; i < c; ++i) {
                byte[] b = ImageTools.splitChannels(buf, i, c, bytesPerPixel, false, this.interleaved);
                this.saveBytes(no * c + i, b, (IFD)ifd.clone(), x, y, w, h);
            }
            this.checkParams = true;
            return -1;
        }
        this.formatCompression(ifd);
        byte[][] lut = AWTImageTools.get8BitLookupTable(this.cm);
        if (lut != null) {
            int[] colorMap = new int[lut.length * lut[0].length];
            for (int i = 0; i < lut.length; ++i) {
                for (int j = 0; j < lut[0].length; ++j) {
                    colorMap[i * lut[0].length + j] = (lut[i][j] & 0xFF) << 8;
                }
            }
            ifd.putIFDValue(320, colorMap);
        }
        int width = (Integer)retrieve.getPixelsSizeX(this.series).getValue();
        int height = (Integer)retrieve.getPixelsSizeY(this.series).getValue();
        ifd.put(new Integer(256), new Long(width));
        ifd.put(new Integer(257), new Long(height));
        PositiveFloat px = retrieve.getPixelsPhysicalSizeX(this.series);
        Double physicalSizeX = px == null ? null : (Double)px.getValue();
        physicalSizeX = physicalSizeX == null || physicalSizeX == 0.0 ? Double.valueOf(0.0) : Double.valueOf(1.0 / physicalSizeX);
        PositiveFloat py = retrieve.getPixelsPhysicalSizeY(this.series);
        Double physicalSizeY = py == null ? null : (Double)py.getValue();
        physicalSizeY = physicalSizeY == null || physicalSizeY == 0.0 ? Double.valueOf(0.0) : Double.valueOf(1.0 / physicalSizeY);
        ifd.put(296, 3);
        ifd.put(282, new TiffRational((long)(physicalSizeX * 1000.0 * 10000.0), 1000L));
        ifd.put(283, new TiffRational((long)(physicalSizeY * 1000.0 * 10000.0), 1000L));
        if (!this.isBigTiff) {
            boolean bl = this.isBigTiff = this.out.length() + (long)(2 * (width * height * c * bytesPerPixel)) >= 0x100000000L;
            if (this.isBigTiff) {
                throw new FormatException("File is too large; call setBigTiff(true)");
            }
        }
        ifd.put(new Integer(0), new Boolean(littleEndian));
        if (!ifd.containsKey(3)) {
            ifd.put(3, this.out.length());
            this.out.seek(this.out.length());
        } else {
            this.out.seek((Long)ifd.get(3));
        }
        ifd.putIFDValue(284, this.interleaved || this.getSamplesPerPixel() == 1 ? 1 : 2);
        int sampleFormat = 1;
        if (FormatTools.isSigned(type)) {
            sampleFormat = 2;
        }
        if (FormatTools.isFloatingPoint(type)) {
            sampleFormat = 3;
        }
        ifd.putIFDValue(339, sampleFormat);
        int index = no;
        int realSeries = this.getSeries();
        for (int i = 0; i < realSeries; ++i) {
            this.setSeries(i);
            index += this.getPlaneCount();
        }
        this.setSeries(realSeries);
        return index;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.in != null) {
            this.in.close();
        }
    }

    @Override
    public int getPlaneCount() {
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        int c = this.getSamplesPerPixel();
        int type = FormatTools.pixelTypeFromString(retrieve.getPixelsType(this.series).toString());
        int bytesPerPixel = FormatTools.getBytesPerPixel(type);
        if (bytesPerPixel > 1 && c != 1 && c != 3) {
            return super.getPlaneCount() * c;
        }
        return super.getPlaneCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        IFD ifd = new IFD();
        if (!this.sequential) {
            TiffParser parser = new TiffParser(this.currentId);
            try {
                long[] ifdOffsets = parser.getIFDOffsets();
                if (no < ifdOffsets.length) {
                    ifd = parser.getIFD(ifdOffsets[no]);
                }
            }
            finally {
                RandomAccessInputStream tiffParserStream = parser.getStream();
                if (tiffParserStream != null) {
                    tiffParserStream.close();
                }
            }
        }
        this.saveBytes(no, buf, ifd, x, y, w, h);
    }

    @Override
    public boolean canDoStacks() {
        return true;
    }

    @Override
    public int[] getPixelTypes(String codec) {
        if (codec != null && codec.equals(COMPRESSION_JPEG)) {
            return new int[]{0, 1, 2, 3};
        }
        if (codec != null && codec.equals(COMPRESSION_J2K)) {
            return new int[]{0, 1, 2, 3, 4, 5, 6};
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    }

    public void setBigTiff(boolean bigTiff) {
        FormatTools.assertId(this.currentId, false, 1);
        this.isBigTiff = bigTiff;
    }

    private void setupTiffSaver() throws IOException {
        this.out.close();
        this.out = new RandomAccessOutputStream(this.currentId);
        this.tiffSaver = new TiffSaver(this.out, this.currentId);
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        Boolean bigEndian = retrieve.getPixelsBinDataBigEndian(this.series, 0);
        boolean littleEndian = bigEndian == null ? false : bigEndian == false;
        this.tiffSaver.setWritingSequentially(this.sequential);
        this.tiffSaver.setLittleEndian(littleEndian);
        this.tiffSaver.setBigTiff(this.isBigTiff);
        this.tiffSaver.setCodecOptions(this.options);
    }
}

