/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import java.util.List;
import org.jdom.Element;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.hdf5.ODLparser2;

public class H5eos {
    static void parse(NetcdfFile ncfile) throws IOException {
        Group rootg = ncfile.getRootGroup();
        Group eosInfo = rootg.findGroup("HDFEOS_INFORMATION");
        Variable structMetadata = eosInfo.findVariable("StructMetadata.0");
        if (structMetadata == null) {
            return;
        }
        Array A = structMetadata.read();
        ArrayChar ca = (ArrayChar)A;
        String sval = ca.getString();
        ODLparser2 parser = new ODLparser2();
        Element root = parser.parseFromString(sval);
        Element swathStructure = root.getChild("SwathStructure");
        Element swath1 = swathStructure.getChild("SWATH_1");
        String swathName = swath1.getChild("SwathName").getText();
        swathName = NetcdfFile.createValidNetcdfObjectName(swathName);
        Element d = swath1.getChild("Dimension");
        List dims = d.getChildren();
        for (Element elem : dims) {
            String name = elem.getChild("DimensionName").getText();
            String sizeS = elem.getChild("Size").getText();
            int length = Integer.parseInt(sizeS);
            Dimension dim = new Dimension(name, length);
            rootg.addDimension(dim);
        }
        Group eos = rootg.findGroup("HDFEOS").findGroup("SWATHS");
        Group gloc = eos.findGroup(swathName).findGroup("Geolocation_Fields");
        Element floc = swath1.getChild("GeoField");
        List varsLoc = floc.getChildren();
        for (Element elem : varsLoc) {
            String varname = elem.getChild("GeoFieldName").getText();
            varname = NetcdfFile.createValidNetcdfObjectName(varname);
            Variable v = gloc.findVariable(varname);
            assert (v != null) : varname;
            StringBuffer sbuff = new StringBuffer();
            Element dimList = elem.getChild("DimList");
            List values = dimList.getChildren("value");
            for (Element value : values) {
                sbuff.append(value.getText());
                sbuff.append(" ");
            }
            v.setDimensions(sbuff.toString());
        }
        Group g = eos.findGroup(swathName).findGroup("Data_Fields");
        Element f = swath1.getChild("DataField");
        List vars = f.getChildren();
        for (Element elem : vars) {
            String varname = elem.getChild("DataFieldName").getText();
            varname = NetcdfFile.createValidNetcdfObjectName(varname);
            Variable v = g.findVariable(varname);
            assert (v != null) : varname;
            StringBuffer sbuff = new StringBuffer();
            Element dimList = elem.getChild("DimList");
            List values = dimList.getChildren("value");
            for (Element value : values) {
                sbuff.append(value.getText());
                sbuff.append(" ");
            }
            v.setDimensions(sbuff.toString());
        }
    }
}

