/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.CompoundTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueMDArray;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5ObjectType;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.IHDF5WriterConfigurator;
import ch.systemsx.cisd.hdf5.StringUtils;
import ch.systemsx.cisd.hdf5.cleanup.CleanUpCallable;
import ch.systemsx.cisd.hdf5.cleanup.CleanUpRegistry;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ncsa.hdf.hdf5lib.exceptions.HDF5FileNotFoundException;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

class HDF5BaseReader {
    static final int REFERENCE_SIZE_IN_BYTES = 8;
    protected final File hdf5File;
    protected final CleanUpCallable runner;
    protected final CleanUpRegistry fileRegistry;
    protected final boolean performNumericConversions;
    private final Map<String, Integer> namedDataTypeMap;
    private final List<DataTypeContainer> namedDataTypeList;
    protected final HDF5 h5;
    protected final int fileId;
    protected final int booleanDataTypeId;
    protected final HDF5EnumerationType typeVariantDataType;
    protected State state;
    final String houseKeepingNameSuffix;
    final CharacterEncoding encodingForNewDataSets;

    HDF5BaseReader(File hdf5File, boolean performNumericConversions, boolean autoDereference, IHDF5WriterConfigurator.FileFormat fileFormat, boolean overwrite, String preferredHouseKeepingNameSuffix) {
        this(hdf5File, performNumericConversions, false, autoDereference, fileFormat, overwrite, preferredHouseKeepingNameSuffix);
    }

    HDF5BaseReader(File hdf5File, boolean performNumericConversions, boolean useUTF8CharEncoding, boolean autoDereference, IHDF5WriterConfigurator.FileFormat fileFormat, boolean overwrite, String preferredHouseKeepingNameSuffix) {
        assert (hdf5File != null);
        assert (preferredHouseKeepingNameSuffix != null);
        this.performNumericConversions = performNumericConversions;
        this.hdf5File = hdf5File.getAbsoluteFile();
        this.runner = new CleanUpCallable();
        this.fileRegistry = CleanUpRegistry.createSynchonized();
        this.namedDataTypeMap = new HashMap<String, Integer>();
        this.namedDataTypeList = new ArrayList<DataTypeContainer>();
        this.encodingForNewDataSets = useUTF8CharEncoding ? CharacterEncoding.UTF8 : CharacterEncoding.ASCII;
        this.h5 = new HDF5(this.fileRegistry, this.runner, performNumericConversions, useUTF8CharEncoding, autoDereference);
        this.fileId = this.openFile(fileFormat, overwrite);
        this.state = State.OPEN;
        String houseKeepingNameSuffixFromFileOrNull = this.tryGetHouseKeepingNameSuffix();
        this.houseKeepingNameSuffix = houseKeepingNameSuffixFromFileOrNull == null ? preferredHouseKeepingNameSuffix : houseKeepingNameSuffixFromFileOrNull;
        this.readNamedDataTypes();
        this.booleanDataTypeId = this.openOrCreateBooleanDataType();
        this.typeVariantDataType = this.openOrCreateTypeVariantDataType();
    }

    void copyObject(String srcPath, int dstFileId, String dstPath) {
        boolean dstIsDir = dstPath.endsWith("/");
        if (dstIsDir && !this.h5.exists(dstFileId, dstPath)) {
            this.h5.createGroup(dstFileId, dstPath);
        }
        if ("/".equals(srcPath)) {
            String dstDir = dstIsDir ? dstPath : String.valueOf(dstPath) + "/";
            for (String object : this.getGroupMembers("/")) {
                this.h5.copyObject(this.fileId, object, dstFileId, String.valueOf(dstDir) + object);
            }
        } else if (dstIsDir) {
            int idx = srcPath.lastIndexOf(47);
            String sourceObjectName = srcPath.substring(idx < 0 ? 0 : idx);
            this.h5.copyObject(this.fileId, srcPath, dstFileId, String.valueOf(dstPath) + sourceObjectName);
        } else {
            this.h5.copyObject(this.fileId, srcPath, dstFileId, dstPath);
        }
    }

    int openFile(IHDF5WriterConfigurator.FileFormat fileFormat, boolean overwrite) {
        if (!this.hdf5File.exists()) {
            throw new HDF5FileNotFoundException(this.hdf5File, "Path does not exit.");
        }
        if (!this.hdf5File.canRead()) {
            throw new HDF5FileNotFoundException(this.hdf5File, "Path is not readable.");
        }
        if (!this.hdf5File.isFile()) {
            throw new HDF5FileNotFoundException(this.hdf5File, "Path is not a file.");
        }
        if (!HDF5Factory.isHDF5File(this.hdf5File)) {
            throw new HDF5FileNotFoundException(this.hdf5File, "Path is not a valid HDF5 file.");
        }
        return this.h5.openFileReadOnly(this.hdf5File.getPath(), this.fileRegistry);
    }

    void checkOpen() throws HDF5JavaException {
        if (this.state != State.OPEN) {
            String msg = "HDF5 file '" + this.hdf5File.getPath() + "' is " + (this.state == State.CLOSED ? "closed." : "not opened yet.");
            throw new HDF5JavaException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        CleanUpRegistry cleanUpRegistry = this.fileRegistry;
        synchronized (cleanUpRegistry) {
            if (this.state == State.OPEN) {
                this.fileRegistry.cleanUp(false);
            }
            this.state = State.CLOSED;
        }
    }

    boolean isClosed() {
        return this.state == State.CLOSED;
    }

    String tryGetHouseKeepingNameSuffix() {
        ICallableWithCleanUp<String> readRunnable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                int objectId = HDF5BaseReader.this.h5.openObject(HDF5BaseReader.this.fileId, "/", registry);
                if (HDF5BaseReader.this.h5.existsAttribute(objectId, "__HOUSEKEEPING_SUFFIX__")) {
                    int suffixLen = HDF5BaseReader.this.getHousekeepingAttributeExplicitStringLength(objectId, registry);
                    boolean explicitLengthStored = suffixLen >= 0;
                    String rawSuffix = HDF5BaseReader.this.getStringAttribute(objectId, "/", "__HOUSEKEEPING_SUFFIX__", explicitLengthStored, registry);
                    return explicitLengthStored ? rawSuffix.substring(0, suffixLen) : rawSuffix;
                }
                return null;
            }
        };
        return this.runner.call(readRunnable);
    }

    byte[] getAttributeAsByteArray(int objectId, String attributeName, ICleanUpRegistry registry) {
        int size;
        int attributeId = this.h5.openAttribute(objectId, attributeName, registry);
        int nativeDataTypeId = this.h5.getNativeDataTypeForAttribute(attributeId, registry);
        int dataClass = this.h5.getClassType(nativeDataTypeId);
        if (dataClass == HDF5Constants.H5T_ARRAY) {
            int numberOfElements = MDAbstractArray.getLength((int[])this.h5.getArrayDimensions(nativeDataTypeId));
            int baseDataType = this.h5.getBaseDataType(nativeDataTypeId, registry);
            int elementSize = this.h5.getDataTypeSize(baseDataType);
            size = numberOfElements * elementSize;
        } else if (dataClass == HDF5Constants.H5T_STRING) {
            int stringDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
            size = this.h5.getDataTypeSize(stringDataTypeId);
            if (this.h5.isVariableLengthString(stringDataTypeId)) {
                String[] data = new String[1];
                this.h5.readAttributeVL(attributeId, stringDataTypeId, data);
                return data[0].getBytes();
            }
        } else {
            int numberOfElements = MDAbstractArray.getLength((long[])this.h5.getDataDimensionsForAttribute(attributeId, registry));
            int elementSize = this.h5.getDataTypeSize(nativeDataTypeId);
            size = numberOfElements * elementSize;
        }
        return this.h5.readAttributeAsByteArray(attributeId, nativeDataTypeId, size);
    }

    int openOrCreateBooleanDataType() {
        String booleanDataTypePath = HDF5Utils.getBooleanDataTypePath(this.houseKeepingNameSuffix);
        int dataTypeId = this.getDataTypeId(booleanDataTypePath);
        if (dataTypeId < 0) {
            dataTypeId = this.createBooleanDataType();
            this.commitDataType(booleanDataTypePath, dataTypeId);
        }
        return dataTypeId;
    }

    String tryGetDataTypePath(int dataTypeId) {
        for (DataTypeContainer namedDataType : this.namedDataTypeList) {
            if (!this.h5.dataTypesAreEqual(dataTypeId, namedDataType.typeId)) continue;
            return namedDataType.typePath;
        }
        return this.h5.tryGetDataTypePath(dataTypeId);
    }

    void renameNamedDataType(String oldPath, String newPath) {
        Integer typeIdOrNull = this.namedDataTypeMap.get(oldPath);
        if (typeIdOrNull != null) {
            this.namedDataTypeMap.put(newPath, typeIdOrNull);
        }
        int i = 0;
        while (i < this.namedDataTypeList.size()) {
            DataTypeContainer c = this.namedDataTypeList.get(i);
            if (c.typePath.equals(oldPath)) {
                this.namedDataTypeList.set(i, new DataTypeContainer(c.typeId, newPath));
            }
            ++i;
        }
    }

    String tryGetDataTypeName(int dataTypeId, HDF5DataClass dataClass) {
        String dataTypePathOrNull = this.tryGetDataTypePath(dataTypeId);
        return HDF5Utils.tryGetDataTypeNameFromPath(dataTypePathOrNull, this.houseKeepingNameSuffix, dataClass);
    }

    int getDataTypeId(String dataTypePath) {
        Integer dataTypeIdOrNull = this.namedDataTypeMap.get(dataTypePath);
        if (dataTypeIdOrNull == null) {
            if (this.h5.exists(this.fileId, dataTypePath)) {
                int dataTypeId = this.h5.openDataType(this.fileId, dataTypePath, this.fileRegistry);
                this.namedDataTypeMap.put(dataTypePath, dataTypeId);
                return dataTypeId;
            }
            return -1;
        }
        return dataTypeIdOrNull;
    }

    int createBooleanDataType() {
        return this.h5.createDataTypeEnum(new String[]{"FALSE", "TRUE"}, this.fileRegistry);
    }

    HDF5EnumerationType openOrCreateTypeVariantDataType() {
        String typeVariantTypePath = HDF5Utils.getTypeVariantDataTypePath(this.houseKeepingNameSuffix);
        int dataTypeId = this.getDataTypeId(typeVariantTypePath);
        if (dataTypeId < 0) {
            return this.createTypeVariantDataType();
        }
        int nativeDataTypeId = this.h5.getNativeDataType(dataTypeId, this.fileRegistry);
        String[] typeVariantNames = this.h5.getNamesForEnumOrCompoundMembers(dataTypeId);
        return new HDF5EnumerationType(this.fileId, dataTypeId, nativeDataTypeId, typeVariantTypePath, typeVariantNames, this);
    }

    HDF5EnumerationType createTypeVariantDataType() {
        HDF5DataTypeVariant[] typeVariants = HDF5DataTypeVariant.values();
        String[] typeVariantNames = new String[typeVariants.length];
        int i = 0;
        while (i < typeVariants.length) {
            typeVariantNames[i] = typeVariants[i].name();
            ++i;
        }
        int dataTypeId = this.h5.createDataTypeEnum(typeVariantNames, this.fileRegistry);
        int nativeDataTypeId = this.h5.getNativeDataType(dataTypeId, this.fileRegistry);
        return new HDF5EnumerationType(this.fileId, dataTypeId, nativeDataTypeId, HDF5Utils.getTypeVariantDataTypePath(this.houseKeepingNameSuffix), typeVariantNames, this);
    }

    void readNamedDataTypes() {
        String typeGroup = HDF5Utils.getDataTypeGroup(this.houseKeepingNameSuffix);
        if (!this.h5.exists(this.fileId, typeGroup)) {
            return;
        }
        this.readNamedDataTypes(typeGroup);
    }

    private void readNamedDataTypes(String dataTypePath) {
        for (String dataTypeSubPath : this.getGroupMemberPaths(dataTypePath)) {
            HDF5ObjectType type = this.h5.getObjectTypeInfo(this.fileId, dataTypeSubPath, false);
            if (HDF5ObjectType.isGroup(type)) {
                this.readNamedDataTypes(dataTypeSubPath);
                continue;
            }
            if (!HDF5ObjectType.isDataType(type)) continue;
            int dataTypeId = this.h5.openDataType(this.fileId, dataTypeSubPath, this.fileRegistry);
            this.namedDataTypeMap.put(dataTypeSubPath, dataTypeId);
            this.namedDataTypeList.add(new DataTypeContainer(dataTypeId, dataTypeSubPath));
        }
    }

    void commitDataType(String dataTypePath, int dataTypeId) {
    }

    DataSpaceParameters getSpaceParameters(int dataSetId, ICleanUpRegistry registry) {
        long[] dimensions = this.h5.getDataDimensions(dataSetId, registry);
        return new DataSpaceParameters(HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, MDAbstractArray.getLength((long[])dimensions), dimensions);
    }

    DataSpaceParameters tryGetSpaceParameters(int dataSetId, long offset, int blockSize, boolean nullWhenOutside, ICleanUpRegistry registry) {
        return this.tryGetSpaceParameters(dataSetId, 0L, offset, blockSize, nullWhenOutside, registry);
    }

    DataSpaceParameters getSpaceParameters(int dataSetId, long offset, int blockSize, ICleanUpRegistry registry) {
        return this.tryGetSpaceParameters(dataSetId, 0L, offset, blockSize, false, registry);
    }

    DataSpaceParameters getSpaceParameters(int dataSetId, long memoryOffset, long offset, int blockSize, ICleanUpRegistry registry) {
        return this.tryGetSpaceParameters(dataSetId, memoryOffset, offset, blockSize, false, registry);
    }

    DataSpaceParameters tryGetSpaceParameters(int dataSetId, long memoryOffset, long offset, int blockSize, boolean nullWhenOutside, ICleanUpRegistry registry) {
        int memorySpaceId;
        int effectiveBlockSize;
        long[] dimensions;
        int dataSpaceId;
        if (blockSize > 0) {
            dataSpaceId = this.h5.getDataSpaceForDataSet(dataSetId, registry);
            dimensions = this.h5.getDataSpaceDimensions(dataSpaceId);
            if (dimensions.length != 1) {
                throw new HDF5JavaException("Data Set is expected to be of rank 1 (rank=" + dimensions.length + ")");
            }
            long size = dimensions[0];
            long maxFileBlockSize = size - offset;
            if (maxFileBlockSize <= 0L) {
                if (nullWhenOutside) {
                    return null;
                }
                throw new HDF5JavaException("Offset " + offset + " >= Size " + size);
            }
            long maxMemoryBlockSize = size - memoryOffset;
            if (maxMemoryBlockSize <= 0L) {
                if (nullWhenOutside) {
                    return null;
                }
                throw new HDF5JavaException("Memory offset " + memoryOffset + " >= Size " + size);
            }
            effectiveBlockSize = (int)Math.min((long)blockSize, Math.min(maxMemoryBlockSize, maxFileBlockSize));
            long[] blockShape = new long[]{effectiveBlockSize};
            this.h5.setHyperslabBlock(dataSpaceId, new long[]{offset}, blockShape);
            memorySpaceId = this.h5.createSimpleDataSpace(blockShape, registry);
            this.h5.setHyperslabBlock(memorySpaceId, new long[]{memoryOffset}, blockShape);
        } else {
            memorySpaceId = HDF5Constants.H5S_ALL;
            dataSpaceId = HDF5Constants.H5S_ALL;
            dimensions = this.h5.getDataDimensions(dataSetId, registry);
            effectiveBlockSize = HDF5Utils.getOneDimensionalArraySize(dimensions);
        }
        return new DataSpaceParameters(memorySpaceId, dataSpaceId, effectiveBlockSize, dimensions);
    }

    DataSpaceParameters getSpaceParameters(int dataSetId, long[] offset, int[] blockDimensionsOrNull, ICleanUpRegistry registry) {
        return this.tryGetSpaceParameters(dataSetId, offset, blockDimensionsOrNull, false, registry);
    }

    DataSpaceParameters tryGetSpaceParameters(int dataSetId, long[] offset, int[] blockDimensionsOrNull, boolean nullWhenOutside, ICleanUpRegistry registry) {
        int memorySpaceId;
        long[] effectiveBlockDimensions;
        int dataSpaceId;
        if (blockDimensionsOrNull != null) {
            assert (offset != null);
            assert (blockDimensionsOrNull.length == offset.length);
            dataSpaceId = this.h5.getDataSpaceForDataSet(dataSetId, registry);
            long[] dimensions = this.h5.getDataSpaceDimensions(dataSpaceId);
            if (dimensions.length != blockDimensionsOrNull.length) {
                throw new HDF5JavaException("Data Set is expected to be of rank " + blockDimensionsOrNull.length + " (rank=" + dimensions.length + ")");
            }
            effectiveBlockDimensions = new long[blockDimensionsOrNull.length];
            int i = 0;
            while (i < offset.length) {
                long maxBlockSize = dimensions[i] - offset[i];
                if (maxBlockSize <= 0L) {
                    if (nullWhenOutside) {
                        return null;
                    }
                    throw new HDF5JavaException("Offset " + offset[i] + " >= Size " + dimensions[i]);
                }
                effectiveBlockDimensions[i] = Math.min((long)blockDimensionsOrNull[i], maxBlockSize);
                ++i;
            }
            this.h5.setHyperslabBlock(dataSpaceId, offset, effectiveBlockDimensions);
            memorySpaceId = this.h5.createSimpleDataSpace(effectiveBlockDimensions, registry);
        } else {
            memorySpaceId = HDF5Constants.H5S_ALL;
            dataSpaceId = HDF5Constants.H5S_ALL;
            effectiveBlockDimensions = this.h5.getDataDimensions(dataSetId, registry);
        }
        return new DataSpaceParameters(memorySpaceId, dataSpaceId, MDAbstractArray.getLength((long[])effectiveBlockDimensions), effectiveBlockDimensions);
    }

    DataSpaceParameters getBlockSpaceParameters(int dataSetId, int[] memoryOffset, int[] memoryDimensions, ICleanUpRegistry registry) {
        return this.tryGetBlockSpaceParameters(dataSetId, memoryOffset, memoryDimensions, false, registry);
    }

    DataSpaceParameters tryGetBlockSpaceParameters(int dataSetId, int[] memoryOffset, int[] memoryDimensions, boolean nullWhenOutside, ICleanUpRegistry registry) {
        assert (memoryOffset != null);
        assert (memoryDimensions != null);
        assert (memoryDimensions.length == memoryOffset.length);
        long[] dimensions = this.h5.getDataDimensions(dataSetId, registry);
        int memorySpaceId = this.h5.createSimpleDataSpace(MDAbstractArray.toLong((int[])memoryDimensions), registry);
        int i = 0;
        while (i < dimensions.length) {
            if (dimensions[i] + (long)memoryOffset[i] > (long)memoryDimensions[i]) {
                if (nullWhenOutside) {
                    return null;
                }
                throw new HDF5JavaException("Dimensions " + dimensions[i] + " + memory offset " + memoryOffset[i] + " >= memory buffer " + memoryDimensions[i]);
            }
            ++i;
        }
        this.h5.setHyperslabBlock(memorySpaceId, MDAbstractArray.toLong((int[])memoryOffset), dimensions);
        return new DataSpaceParameters(memorySpaceId, HDF5Constants.H5S_ALL, MDAbstractArray.getLength((long[])dimensions), dimensions);
    }

    DataSpaceParameters getBlockSpaceParameters(int dataSetId, int[] memoryOffset, int[] memoryDimensions, long[] offset, int[] blockDimensions, ICleanUpRegistry registry) {
        return this.tryGetBlockSpaceParameters(dataSetId, memoryOffset, memoryDimensions, offset, blockDimensions, false, registry);
    }

    DataSpaceParameters tryGetBlockSpaceParameters(int dataSetId, int[] memoryOffset, int[] memoryDimensions, long[] offset, int[] blockDimensions, boolean nullWhenOutside, ICleanUpRegistry registry) {
        assert (memoryOffset != null);
        assert (memoryDimensions != null);
        assert (offset != null);
        assert (blockDimensions != null);
        assert (memoryOffset.length == offset.length);
        assert (memoryDimensions.length == memoryOffset.length);
        assert (blockDimensions.length == offset.length);
        int dataSpaceId = this.h5.getDataSpaceForDataSet(dataSetId, registry);
        long[] dimensions = this.h5.getDataSpaceDimensions(dataSpaceId);
        if (dimensions.length != blockDimensions.length) {
            throw new HDF5JavaException("Data Set is expected to be of rank " + blockDimensions.length + " (rank=" + dimensions.length + ")");
        }
        long[] effectiveBlockDimensions = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            long maxFileBlockSize = dimensions[i] - offset[i];
            if (maxFileBlockSize <= 0L) {
                if (nullWhenOutside) {
                    return null;
                }
                throw new HDF5JavaException("Offset " + offset[i] + " >= Size " + dimensions[i]);
            }
            long maxMemoryBlockSize = memoryDimensions[i] - memoryOffset[i];
            if (maxMemoryBlockSize <= 0L) {
                if (nullWhenOutside) {
                    return null;
                }
                throw new HDF5JavaException("Memory offset " + memoryOffset[i] + " >= Size " + memoryDimensions[i]);
            }
            effectiveBlockDimensions[i] = Math.min((long)blockDimensions[i], Math.min(maxMemoryBlockSize, maxFileBlockSize));
            ++i;
        }
        this.h5.setHyperslabBlock(dataSpaceId, offset, effectiveBlockDimensions);
        int memorySpaceId = this.h5.createSimpleDataSpace(MDAbstractArray.toLong((int[])memoryDimensions), registry);
        this.h5.setHyperslabBlock(memorySpaceId, MDAbstractArray.toLong((int[])memoryOffset), effectiveBlockDimensions);
        return new DataSpaceParameters(memorySpaceId, dataSpaceId, MDAbstractArray.getLength((long[])effectiveBlockDimensions), effectiveBlockDimensions);
    }

    int getNativeDataTypeId(int dataSetId, int overrideDataTypeId, ICleanUpRegistry registry) {
        int nativeDataTypeId = overrideDataTypeId < 0 ? this.h5.getNativeDataTypeForDataSet(dataSetId, registry) : overrideDataTypeId;
        return nativeDataTypeId;
    }

    List<String> getGroupMembers(String groupPath) {
        assert (groupPath != null);
        return HDF5Utils.removeInternalNames(this.getAllGroupMembers(groupPath), this.houseKeepingNameSuffix, false);
    }

    List<String> getAllGroupMembers(String groupPath) {
        String[] groupMemberArray = this.h5.getGroupMembers(this.fileId, groupPath);
        return new LinkedList<String>(Arrays.asList(groupMemberArray));
    }

    List<String> getGroupMemberPaths(String groupPath) {
        String superGroupName = groupPath.equals("/") ? "/" : String.valueOf(groupPath) + "/";
        List<String> memberNames = this.getGroupMembers(groupPath);
        int i = 0;
        while (i < memberNames.size()) {
            memberNames.set(i, String.valueOf(superGroupName) + memberNames.get(i));
            ++i;
        }
        return memberNames;
    }

    HDF5DataSetInformation getDataSetInformation(String dataSetPath) {
        return this.getDataSetInformation(dataSetPath, HDF5DataTypeInformation.DataTypeInfoOptions.DEFAULT);
    }

    HDF5DataSetInformation getDataSetInformation(final String dataSetPath, final HDF5DataTypeInformation.DataTypeInfoOptions options) {
        assert (dataSetPath != null);
        ICallableWithCleanUp<HDF5DataSetInformation> informationDeterminationRunnable = new ICallableWithCleanUp<HDF5DataSetInformation>(){

            @Override
            public HDF5DataSetInformation call(ICleanUpRegistry registry) {
                boolean vlString;
                int dataSetId = HDF5BaseReader.this.h5.openDataSet(HDF5BaseReader.this.fileId, dataSetPath, registry);
                int dataTypeId = HDF5BaseReader.this.h5.getDataTypeForDataSet(dataSetId, registry);
                HDF5DataTypeInformation dataTypeInfo = HDF5BaseReader.this.getDataTypeInformation(dataTypeId, options, registry);
                HDF5DataTypeVariant variantOrNull = options.knowsDataTypeVariant() ? HDF5BaseReader.this.tryGetTypeVariant(dataSetId, registry) : null;
                HDF5DataSetInformation dataSetInfo = new HDF5DataSetInformation(dataTypeInfo, variantOrNull);
                boolean bl = vlString = dataTypeInfo.getDataClass() == HDF5DataClass.STRING && HDF5BaseReader.this.h5.isVariableLengthString(dataTypeId);
                if (vlString) {
                    dataTypeInfo.setElementSize(-1);
                }
                HDF5BaseReader.this.h5.fillDataDimensions(dataSetId, false, dataSetInfo);
                return dataSetInfo;
            }
        };
        return this.runner.call(informationDeterminationRunnable);
    }

    HDF5DataTypeVariant tryGetTypeVariant(final String objectPath) {
        assert (objectPath != null);
        ICallableWithCleanUp<HDF5DataTypeVariant> readRunnable = new ICallableWithCleanUp<HDF5DataTypeVariant>(){

            @Override
            public HDF5DataTypeVariant call(ICleanUpRegistry registry) {
                int objectId = HDF5BaseReader.this.h5.openObject(HDF5BaseReader.this.fileId, objectPath, registry);
                return HDF5BaseReader.this.tryGetTypeVariant(objectId, registry);
            }
        };
        return this.runner.call(readRunnable);
    }

    HDF5DataTypeVariant tryGetTypeVariant(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        ICallableWithCleanUp<HDF5DataTypeVariant> readRunnable = new ICallableWithCleanUp<HDF5DataTypeVariant>(){

            @Override
            public HDF5DataTypeVariant call(ICleanUpRegistry registry) {
                int objectId = HDF5BaseReader.this.h5.openObject(HDF5BaseReader.this.fileId, objectPath, registry);
                return HDF5BaseReader.this.tryGetTypeVariant(objectId, attributeName, registry);
            }
        };
        return this.runner.call(readRunnable);
    }

    HDF5EnumerationValueArray getEnumValueArray(int attributeId, String objectPath, String attributeName, ICleanUpRegistry registry) {
        int enumTypeId;
        int len;
        Object[] arrayDimensions;
        int storageDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
        int nativeDataTypeId = this.h5.getNativeDataType(storageDataTypeId, registry);
        if (this.h5.getClassType(storageDataTypeId) == HDF5Constants.H5T_ARRAY) {
            arrayDimensions = this.h5.getArrayDimensions(storageDataTypeId);
            if (arrayDimensions.length != 1) {
                throw new HDF5JavaException("Attribute '" + attributeName + "' of object '" + objectPath + "' is not an array of rank 1, but is of rank " + arrayDimensions.length);
            }
            len = arrayDimensions[0];
            enumTypeId = this.h5.getBaseDataType(storageDataTypeId, registry);
            if (this.h5.getClassType(enumTypeId) != HDF5Constants.H5T_ENUM) {
                throw new HDF5JavaException("Attribute '" + attributeName + "' of object '" + objectPath + "' is not of type enumeration array.");
            }
        } else {
            if (this.h5.getClassType(storageDataTypeId) != HDF5Constants.H5T_ENUM) {
                throw new HDF5JavaException("Attribute '" + attributeName + "' of object '" + objectPath + "' is not of type enumeration array.");
            }
            enumTypeId = storageDataTypeId;
            arrayDimensions = this.h5.getDataDimensionsForAttribute(attributeId, registry);
            len = HDF5Utils.getOneDimensionalArraySize((long[])arrayDimensions);
        }
        HDF5EnumerationType enumType = this.getEnumTypeForEnumDataType(null, enumTypeId, true, this.fileRegistry);
        byte[] data = this.h5.readAttributeAsByteArray(attributeId, nativeDataTypeId, len * enumType.getStorageForm().getStorageSize());
        HDF5EnumerationValueArray value = new HDF5EnumerationValueArray(enumType, HDF5EnumerationType.fromStorageForm(data, enumType.getStorageForm()));
        return value;
    }

    HDF5EnumerationValueMDArray getEnumValueMDArray(int attributeId, String objectPath, String attributeName, ICleanUpRegistry registry) {
        int enumTypeId;
        int len;
        int[] arrayDimensions;
        int storageDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
        int nativeDataTypeId = this.h5.getNativeDataType(storageDataTypeId, registry);
        if (this.h5.getClassType(storageDataTypeId) == HDF5Constants.H5T_ARRAY) {
            arrayDimensions = this.h5.getArrayDimensions(storageDataTypeId);
            len = MDAbstractArray.getLength((int[])arrayDimensions);
            enumTypeId = this.h5.getBaseDataType(storageDataTypeId, registry);
            if (this.h5.getClassType(enumTypeId) != HDF5Constants.H5T_ENUM) {
                throw new HDF5JavaException("Attribute '" + attributeName + "' of object '" + objectPath + "' is not of type enumeration array.");
            }
        } else {
            if (this.h5.getClassType(storageDataTypeId) != HDF5Constants.H5T_ENUM) {
                throw new HDF5JavaException("Attribute '" + attributeName + "' of object '" + objectPath + "' is not of type enumeration array.");
            }
            enumTypeId = storageDataTypeId;
            arrayDimensions = MDAbstractArray.toInt((long[])this.h5.getDataDimensionsForAttribute(attributeId, registry));
            len = MDAbstractArray.getLength((int[])arrayDimensions);
        }
        HDF5EnumerationType enumType = this.getEnumTypeForEnumDataType(null, enumTypeId, true, this.fileRegistry);
        byte[] data = this.h5.readAttributeAsByteArray(attributeId, nativeDataTypeId, len * enumType.getStorageForm().getStorageSize());
        HDF5EnumerationValueMDArray value = new HDF5EnumerationValueMDArray(enumType, HDF5EnumerationType.fromStorageForm(data, arrayDimensions, enumType.getStorageForm()));
        return value;
    }

    int getEnumDataTypeId(int storageDataTypeId, ICleanUpRegistry registry) {
        int enumDataTypeId = this.h5.getClassType(storageDataTypeId) == HDF5Constants.H5T_ARRAY ? this.h5.getBaseDataType(storageDataTypeId, registry) : storageDataTypeId;
        return enumDataTypeId;
    }

    HDF5DataTypeVariant[] tryGetTypeVariantForCompoundMembers(String dataTypePathOrNull, ICleanUpRegistry registry) {
        if (dataTypePathOrNull == null) {
            return null;
        }
        this.checkOpen();
        int objectId = this.h5.openObject(this.fileId, dataTypePathOrNull, registry);
        String typeVariantMembersAttributeName = HDF5Utils.getTypeVariantMembersAttributeName(this.houseKeepingNameSuffix);
        if (!this.h5.existsAttribute(objectId, typeVariantMembersAttributeName)) {
            return null;
        }
        int attributeId = this.h5.openAttribute(objectId, typeVariantMembersAttributeName, registry);
        HDF5EnumerationValueArray valueArray = this.getEnumValueArray(attributeId, dataTypePathOrNull, typeVariantMembersAttributeName, registry);
        HDF5DataTypeVariant[] variants = new HDF5DataTypeVariant[valueArray.getLength()];
        boolean hasVariants = false;
        int i = 0;
        while (i < variants.length) {
            variants[i] = HDF5DataTypeVariant.values()[valueArray.getOrdinal(i)];
            hasVariants |= variants[i].isTypeVariant();
            ++i;
        }
        if (hasVariants) {
            return variants;
        }
        return null;
    }

    HDF5DataTypeVariant tryGetTypeVariant(int objectId, ICleanUpRegistry registry) {
        int typeVariantOrdinal = this.getAttributeTypeVariant(objectId, registry);
        return typeVariantOrdinal < 0 ? null : HDF5DataTypeVariant.values()[typeVariantOrdinal];
    }

    HDF5DataTypeVariant tryGetTypeVariant(int objectId, String attributeName, ICleanUpRegistry registry) {
        int typeVariantOrdinal = this.getAttributeTypeVariant(objectId, attributeName, registry);
        return typeVariantOrdinal < 0 ? null : HDF5DataTypeVariant.values()[typeVariantOrdinal];
    }

    int getAttributeTypeVariant(int objectId, ICleanUpRegistry registry) {
        this.checkOpen();
        String dataTypeVariantAttributeName = HDF5Utils.createObjectTypeVariantAttributeName(this.houseKeepingNameSuffix);
        if (!this.h5.existsAttribute(objectId, dataTypeVariantAttributeName)) {
            return -1;
        }
        int attributeId = this.h5.openAttribute(objectId, dataTypeVariantAttributeName, registry);
        return this.getEnumOrdinal(attributeId, -1, this.typeVariantDataType);
    }

    int getAttributeTypeVariant(int objectId, String attributeName, ICleanUpRegistry registry) {
        this.checkOpen();
        String typeVariantAttrName = HDF5Utils.createAttributeTypeVariantAttributeName(attributeName, this.houseKeepingNameSuffix);
        if (!this.h5.existsAttribute(objectId, typeVariantAttrName)) {
            return -1;
        }
        int attributeId = this.h5.openAttribute(objectId, typeVariantAttrName, registry);
        return this.getEnumOrdinal(attributeId, -1, this.typeVariantDataType);
    }

    int getEnumOrdinal(int attributeId, int nativeDataTypeId, HDF5EnumerationType enumType) {
        byte[] data = this.h5.readAttributeAsByteArray(attributeId, nativeDataTypeId < 0 ? enumType.getNativeTypeId() : nativeDataTypeId, enumType.getStorageForm().getStorageSize());
        return HDF5EnumerationType.fromStorageForm(data);
    }

    private int getHousekeepingAttributeExplicitStringLength(int objectId, ICleanUpRegistry registry) {
        if (!this.h5.existsAttribute(objectId, "__STRING_LENGTH____HOUSEKEEPING_SUFFIX____")) {
            return -1;
        }
        int attributeId = this.h5.openAttribute(objectId, "__STRING_LENGTH____HOUSEKEEPING_SUFFIX____", registry);
        int[] data = this.h5.readAttributeAsIntArray(attributeId, HDF5Constants.H5T_NATIVE_INT32, 1);
        return data[0];
    }

    HDF5DataTypeInformation getDataTypeInformation(final int dataTypeId, final HDF5DataTypeInformation.DataTypeInfoOptions options) {
        ICallableWithCleanUp<HDF5DataTypeInformation> informationDeterminationRunnable = new ICallableWithCleanUp<HDF5DataTypeInformation>(){

            @Override
            public HDF5DataTypeInformation call(ICleanUpRegistry registry) {
                boolean vlString;
                HDF5DataTypeInformation dataTypeInfo = HDF5BaseReader.this.getDataTypeInformation(dataTypeId, options, registry);
                boolean bl = vlString = dataTypeInfo.getDataClass() == HDF5DataClass.STRING && HDF5BaseReader.this.h5.isVariableLengthString(dataTypeId);
                if (vlString) {
                    dataTypeInfo.setElementSize(-1);
                }
                return dataTypeInfo;
            }
        };
        return this.runner.call(informationDeterminationRunnable);
    }

    HDF5DataTypeInformation getDataTypeInformation(int dataTypeId, HDF5DataTypeInformation.DataTypeInfoOptions options, ICleanUpRegistry registry) {
        int classTypeId = this.h5.getClassType(dataTypeId);
        int totalSize = this.h5.getDataTypeSize(dataTypeId);
        if (classTypeId == HDF5Constants.H5T_ARRAY) {
            HDF5DataClass dataClass = this.getElementClassForArrayDataType(dataTypeId);
            int[] arrayDimensions = this.h5.getArrayDimensions(dataTypeId);
            int numberOfElements = MDAbstractArray.getLength((int[])arrayDimensions);
            int size = totalSize / numberOfElements;
            int baseTypeId = this.h5.getBaseDataType(dataTypeId, registry);
            String dataTypePathOrNull = options.knowsDataTypePath() ? this.tryGetDataTypePath(baseTypeId) : null;
            CharacterEncoding dataSetEncoding = dataClass == HDF5DataClass.STRING ? this.h5.getCharacterEncoding(baseTypeId) : CharacterEncoding.ASCII;
            return new HDF5DataTypeInformation(dataTypePathOrNull, options, dataClass, dataSetEncoding, this.houseKeepingNameSuffix, size, arrayDimensions, true);
        }
        HDF5DataClass dataClass = this.getDataClassForClassType(classTypeId, dataTypeId);
        String opaqueTagOrNull = dataClass == HDF5DataClass.OPAQUE ? this.h5.tryGetOpaqueTag(dataTypeId) : null;
        String dataTypePathOrNull = options.knowsDataTypePath() ? this.tryGetDataTypePath(dataTypeId) : null;
        CharacterEncoding dataSetEncoding = dataClass == HDF5DataClass.STRING ? this.h5.getCharacterEncoding(dataTypeId) : CharacterEncoding.ASCII;
        return new HDF5DataTypeInformation(dataTypePathOrNull, options, dataClass, dataSetEncoding, this.houseKeepingNameSuffix, totalSize, 1, opaqueTagOrNull);
    }

    private HDF5DataClass getDataClassForClassType(int classTypeId, int dataTypeId) {
        HDF5DataClass dataClass = HDF5DataClass.classIdToDataClass(classTypeId);
        if (dataClass == HDF5DataClass.ENUM && this.h5.dataTypesAreEqual(dataTypeId, this.booleanDataTypeId)) {
            dataClass = HDF5DataClass.BOOLEAN;
        }
        return dataClass;
    }

    private HDF5DataClass getElementClassForArrayDataType(int arrayDataTypeId) {
        HDF5DataClass[] hDF5DataClassArray = HDF5DataClass.values();
        int n = hDF5DataClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5DataClass eClass = hDF5DataClassArray[n2];
            if (this.h5.hasClassType(arrayDataTypeId, eClass.getId())) {
                return eClass;
            }
            ++n2;
        }
        return HDF5DataClass.OTHER;
    }

    String getCompoundDataTypeName(String nameOrNull, int dataTypeId) {
        return this.getDataTypeName(nameOrNull, HDF5DataClass.COMPOUND, dataTypeId);
    }

    <T> HDF5ValueObjectByteifyer<T> createCompoundByteifyers(Class<T> compoundClazz, HDF5CompoundMemberMapping[] compoundMembers, CompoundTypeInformation compoundTypeInfoOrNull) {
        HDF5ValueObjectByteifyer<T> objectByteifyer = new HDF5ValueObjectByteifyer<T>(compoundClazz, new HDF5ValueObjectByteifyer.FileInfoProvider(){

            @Override
            public int getBooleanDataTypeId() {
                return HDF5BaseReader.this.booleanDataTypeId;
            }

            @Override
            public int getStringDataTypeId(int maxLength) {
                int typeId = HDF5BaseReader.this.h5.createDataTypeString(maxLength, HDF5BaseReader.this.fileRegistry);
                return typeId;
            }

            @Override
            public int getArrayTypeId(int baseTypeId, int length) {
                int typeId = HDF5BaseReader.this.h5.createArrayType(baseTypeId, length, (ICleanUpRegistry)HDF5BaseReader.this.fileRegistry);
                return typeId;
            }

            @Override
            public int getArrayTypeId(int baseTypeId, int[] dimensions) {
                int typeId = HDF5BaseReader.this.h5.createArrayType(baseTypeId, dimensions, (ICleanUpRegistry)HDF5BaseReader.this.fileRegistry);
                return typeId;
            }

            @Override
            public CharacterEncoding getCharacterEncoding(int dataTypeId) {
                return dataTypeId < 0 ? HDF5BaseReader.this.encodingForNewDataSets : HDF5BaseReader.this.h5.getCharacterEncoding(dataTypeId);
            }

            @Override
            public HDF5EnumerationType getEnumType(String[] options) {
                int storageDataTypeId = HDF5BaseReader.this.h5.createDataTypeEnum(options, HDF5BaseReader.this.fileRegistry);
                int nativeDataTypeId = HDF5BaseReader.this.h5.getNativeDataType(storageDataTypeId, HDF5BaseReader.this.fileRegistry);
                return new HDF5EnumerationType(HDF5BaseReader.this.fileId, storageDataTypeId, nativeDataTypeId, null, options, HDF5BaseReader.this);
            }
        }, compoundTypeInfoOrNull, compoundMembers);
        return objectByteifyer;
    }

    int createStorageCompoundDataType(HDF5ValueObjectByteifyer<?> objectArrayifyer) {
        int storageDataTypeId = this.h5.createDataTypeCompound(objectArrayifyer.getRecordSize(), this.fileRegistry);
        objectArrayifyer.insertMemberTypes(storageDataTypeId);
        return storageDataTypeId;
    }

    int createNativeCompoundDataType(HDF5ValueObjectByteifyer<?> objectArrayifyer) {
        int nativeDataTypeId = this.h5.createDataTypeCompound(objectArrayifyer.getRecordSize(), this.fileRegistry);
        objectArrayifyer.insertNativeMemberTypes(nativeDataTypeId, this.h5, this.fileRegistry);
        return nativeDataTypeId;
    }

    HDF5EnumerationType getEnumTypeForStorageDataType(String nameOrNull, int storageDataTypeId, boolean resolveName, String objectPathOrNull, String attributeNameOrNull, ICleanUpRegistry registry) {
        int enumStoreDataTypeId;
        boolean isArray;
        int classType = this.h5.getClassType(storageDataTypeId);
        boolean bl = isArray = classType == HDF5Constants.H5T_ARRAY;
        if (isArray) {
            enumStoreDataTypeId = this.h5.getBaseDataType(storageDataTypeId, registry);
            classType = this.h5.getClassType(enumStoreDataTypeId);
        } else {
            enumStoreDataTypeId = storageDataTypeId;
        }
        if (classType != HDF5Constants.H5T_ENUM) {
            if (attributeNameOrNull != null) {
                throw new HDF5JavaException("Attribute '" + attributeNameOrNull + "' of object '" + objectPathOrNull + "' is not of enum type.");
            }
            if (objectPathOrNull != null) {
                throw new HDF5JavaException("Object '" + objectPathOrNull + "' is not of enum type.");
            }
            throw new HDF5JavaException("Type '" + (nameOrNull != null ? nameOrNull : "???") + "' is not of enum type.");
        }
        return this.getEnumTypeForEnumDataType(nameOrNull, enumStoreDataTypeId, resolveName, registry);
    }

    HDF5EnumerationType getEnumTypeForEnumDataType(String nameOrNull, int enumStoreDataTypeId, boolean resolveName, ICleanUpRegistry registry) {
        int nativeDataTypeId = this.h5.getNativeDataType(enumStoreDataTypeId, registry);
        String[] values = this.h5.getNamesForEnumOrCompoundMembers(enumStoreDataTypeId);
        return new HDF5EnumerationType(this.fileId, enumStoreDataTypeId, nativeDataTypeId, resolveName ? this.getEnumDataTypeName(nameOrNull, enumStoreDataTypeId) : nameOrNull, values, this);
    }

    void checkEnumValues(int dataTypeId, String[] values, String nameOrNull) {
        String[] valuesStored = this.h5.getNamesForEnumOrCompoundMembers(dataTypeId);
        if (valuesStored.length != values.length) {
            throw new IllegalStateException("Enum " + this.getEnumDataTypeName(nameOrNull, dataTypeId) + " has " + valuesStored.length + " members, but should have " + values.length);
        }
        int i = 0;
        while (i < values.length) {
            if (!values[i].equals(valuesStored[i])) {
                throw new HDF5JavaException("Enum member index " + i + " of enum " + this.getEnumDataTypeName(nameOrNull, dataTypeId) + " is '" + valuesStored[i] + "', but should be '" + values[i] + "'");
            }
            ++i;
        }
    }

    String getEnumDataTypeName(String nameOrNull, int dataTypeId) {
        return this.getDataTypeName(nameOrNull, HDF5DataClass.ENUM, dataTypeId);
    }

    private String getDataTypeName(String nameOrNull, HDF5DataClass dataClass, int dataTypeId) {
        if (nameOrNull != null) {
            return nameOrNull;
        }
        String nameFromPathOrNull = HDF5Utils.tryGetDataTypeNameFromPath(this.tryGetDataTypePath(dataTypeId), this.houseKeepingNameSuffix, dataClass);
        return nameFromPathOrNull == null ? "UNKNOWN" : nameFromPathOrNull;
    }

    boolean isScaledEnum(int objectId, ICleanUpRegistry registry) {
        HDF5DataTypeVariant typeVariantOrNull = this.tryGetTypeVariant(objectId, registry);
        return HDF5DataTypeVariant.ENUM == typeVariantOrNull;
    }

    boolean isScaledBitField(int objectId, ICleanUpRegistry registry) {
        HDF5DataTypeVariant typeVariantOrNull = this.tryGetTypeVariant(objectId, registry);
        return HDF5DataTypeVariant.BITFIELD == typeVariantOrNull;
    }

    String getStringAttribute(int objectId, String objectPath, String attributeName, boolean readRaw, ICleanUpRegistry registry) {
        boolean isString;
        int attributeId = this.h5.openAttribute(objectId, attributeName, registry);
        int stringDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
        boolean bl = isString = this.h5.getClassType(stringDataTypeId) == HDF5Constants.H5T_STRING;
        if (!isString) {
            throw new IllegalArgumentException("Attribute " + attributeName + " of object " + objectPath + " needs to be a String.");
        }
        int size = this.h5.getDataTypeSize(stringDataTypeId);
        if (this.h5.isVariableLengthString(stringDataTypeId)) {
            String[] data = new String[1];
            this.h5.readAttributeVL(attributeId, stringDataTypeId, data);
            return data[0];
        }
        CharacterEncoding dataSetEncoding = this.h5.getCharacterEncoding(stringDataTypeId);
        byte[] data = this.h5.readAttributeAsByteArray(attributeId, stringDataTypeId, size);
        return readRaw ? StringUtils.fromBytes(data, dataSetEncoding) : StringUtils.fromBytes0Term(data, dataSetEncoding);
    }

    String[] getStringArrayAttribute(int objectId, String objectPath, String attributeName, boolean readRaw, ICleanUpRegistry registry) {
        boolean isStringArray;
        boolean isArray;
        int attributeId = this.h5.openAttribute(objectId, attributeName, registry);
        int stringArrayDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
        boolean bl = isArray = this.h5.getClassType(stringArrayDataTypeId) == HDF5Constants.H5T_ARRAY;
        if (!isArray) {
            throw new HDF5JavaException("Attribute " + attributeName + " of object " + objectPath + " needs to be a String array of rank 1.");
        }
        int stringDataTypeId = this.h5.getBaseDataType(stringArrayDataTypeId, registry);
        boolean bl2 = isStringArray = this.h5.getClassType(stringDataTypeId) == HDF5Constants.H5T_STRING;
        if (!isStringArray) {
            throw new HDF5JavaException("Attribute " + attributeName + " of object " + objectPath + " needs to be a String array of rank 1.");
        }
        int size = this.h5.getDataTypeSize(stringArrayDataTypeId);
        if (this.h5.isVariableLengthString(stringDataTypeId)) {
            String[] data = new String[1];
            this.h5.readAttributeVL(attributeId, stringDataTypeId, data);
            return data;
        }
        CharacterEncoding dataSetEncoding = this.h5.getCharacterEncoding(stringArrayDataTypeId);
        byte[] data = this.h5.readAttributeAsByteArray(attributeId, stringArrayDataTypeId, size);
        int[] arrayDimensions = this.h5.getArrayDimensions(stringArrayDataTypeId);
        if (arrayDimensions.length != 1) {
            throw new HDF5JavaException("Attribute " + attributeName + " of object " + objectPath + " needs to be a String array of rank 1.");
        }
        int lengthPerElement = this.h5.getDataTypeSize(stringDataTypeId);
        int numberOfElements = arrayDimensions[0];
        String[] result = new String[numberOfElements];
        int i = 0;
        int startIdx = 0;
        int endIdx = lengthPerElement;
        while (i < numberOfElements) {
            result[i] = readRaw ? StringUtils.fromBytes(data, startIdx, endIdx, dataSetEncoding) : StringUtils.fromBytes0Term(data, startIdx, endIdx, dataSetEncoding);
            ++i;
            startIdx += lengthPerElement;
            endIdx += lengthPerElement;
        }
        return result;
    }

    MDArray<String> getStringMDArrayAttribute(int objectId, String objectPath, String attributeName, boolean readRaw, ICleanUpRegistry registry) {
        boolean isStringArray;
        boolean isArray;
        int attributeId = this.h5.openAttribute(objectId, attributeName, registry);
        int stringArrayDataTypeId = this.h5.getDataTypeForAttribute(attributeId, registry);
        boolean bl = isArray = this.h5.getClassType(stringArrayDataTypeId) == HDF5Constants.H5T_ARRAY;
        if (!isArray) {
            throw new HDF5JavaException("Attribute " + attributeName + " of object " + objectPath + " needs to be a String array.");
        }
        int stringDataTypeId = this.h5.getBaseDataType(stringArrayDataTypeId, registry);
        boolean bl2 = isStringArray = this.h5.getClassType(stringDataTypeId) == HDF5Constants.H5T_STRING;
        if (!isStringArray) {
            throw new HDF5JavaException("Attribute " + attributeName + " of object " + objectPath + " needs to be a String array.");
        }
        int size = this.h5.getDataTypeSize(stringArrayDataTypeId);
        if (this.h5.isVariableLengthString(stringDataTypeId)) {
            Object[] data = new String[1];
            this.h5.readAttributeVL(attributeId, stringDataTypeId, (String[])data);
            return new MDArray(data, new int[]{1});
        }
        byte[] data = this.h5.readAttributeAsByteArray(attributeId, stringArrayDataTypeId, size);
        CharacterEncoding dataSetEncoding = this.h5.getCharacterEncoding(stringArrayDataTypeId);
        int[] arrayDimensions = this.h5.getArrayDimensions(stringArrayDataTypeId);
        int lengthPerElement = this.h5.getDataTypeSize(stringDataTypeId);
        int numberOfElements = MDAbstractArray.getLength((int[])arrayDimensions);
        Object[] result = new String[numberOfElements];
        int i = 0;
        int startIdx = 0;
        int endIdx = lengthPerElement;
        while (i < numberOfElements) {
            result[i] = readRaw ? StringUtils.fromBytes(data, startIdx, endIdx, dataSetEncoding) : StringUtils.fromBytes0Term(data, startIdx, endIdx, dataSetEncoding);
            ++i;
            startIdx += lengthPerElement;
            endIdx += lengthPerElement;
        }
        return new MDArray(result, arrayDimensions);
    }

    void checkIsTimeStamp(String objectPath, int dataSetId, ICleanUpRegistry registry) throws HDF5JavaException {
        int typeVariantOrdinal = this.getAttributeTypeVariant(dataSetId, registry);
        if (typeVariantOrdinal != HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH.ordinal()) {
            throw new HDF5JavaException("Data set '" + objectPath + "' is not a time stamp.");
        }
    }

    void checkIsTimeStamp(String objectPath, String attributeName, int dataSetId, ICleanUpRegistry registry) throws HDF5JavaException {
        int typeVariantOrdinal = this.getAttributeTypeVariant(dataSetId, attributeName, registry);
        if (typeVariantOrdinal != HDF5DataTypeVariant.TIMESTAMP_MILLISECONDS_SINCE_START_OF_THE_EPOCH.ordinal()) {
            throw new HDF5JavaException("Attribute '" + attributeName + "' of data set '" + objectPath + "' is not a time stamp.");
        }
    }

    HDF5TimeUnit checkIsTimeDuration(String objectPath, int dataSetId, ICleanUpRegistry registry) throws HDF5JavaException {
        int typeVariantOrdinal = this.getAttributeTypeVariant(dataSetId, registry);
        if (!HDF5DataTypeVariant.isTimeDuration(typeVariantOrdinal)) {
            throw new HDF5JavaException("Data set '" + objectPath + "' is not a time duration.");
        }
        return HDF5DataTypeVariant.getTimeUnit(typeVariantOrdinal);
    }

    HDF5TimeUnit checkIsTimeDuration(String objectPath, String attributeName, int dataSetId, ICleanUpRegistry registry) throws HDF5JavaException {
        int typeVariantOrdinal = this.getAttributeTypeVariant(dataSetId, attributeName, registry);
        if (!HDF5DataTypeVariant.isTimeDuration(typeVariantOrdinal)) {
            throw new HDF5JavaException("Attribute '" + attributeName + "' of data set '" + objectPath + "' is not a time duration.");
        }
        return HDF5DataTypeVariant.getTimeUnit(typeVariantOrdinal);
    }

    static class DataSpaceParameters {
        final int memorySpaceId;
        final int dataSpaceId;
        final int blockSize;
        final long[] dimensions;

        DataSpaceParameters(int memorySpaceId, int dataSpaceId, int blockSize, long[] dimensions) {
            this.memorySpaceId = memorySpaceId;
            this.dataSpaceId = dataSpaceId;
            this.blockSize = blockSize;
            this.dimensions = dimensions;
        }
    }

    private class DataTypeContainer {
        final int typeId;
        final String typePath;

        DataTypeContainer(int typeId, String typePath) {
            this.typeId = typeId;
            this.typePath = typePath;
        }
    }

    protected static enum State {
        CONFIG,
        OPEN,
        CLOSED;

    }
}

