/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import ch.systemsx.cisd.common.filesystem.control.ControlDirectoryEventFeed;
import ch.systemsx.cisd.common.filesystem.control.DelayingDecorator;
import ch.systemsx.cisd.common.filesystem.control.IValueFilter;
import ch.systemsx.cisd.common.filesystem.control.Parameter;
import ch.systemsx.cisd.common.filesystem.control.ParameterMap;
import ch.systemsx.cisd.common.logging.event.BooleanEvent;
import ch.systemsx.cisd.common.logging.event.LongEvent;
import java.io.File;

public class ControlFileBasedLogConfiguration {
    private static final String CONTROL_FILE_DIRECTORY = ".control";
    private static final long CONTROL_FILE_MAX_DELAY = 10000L;
    private static final String ON = "on";
    private static final String OFF = "off";
    private ParameterMap map;

    public ControlFileBasedLogConfiguration() {
        this(new File(CONTROL_FILE_DIRECTORY), 10000L);
    }

    public ControlFileBasedLogConfiguration(File controlFileDirectory, long controlFileMaxDelay) {
        this.map = new ParameterMap(new DelayingDecorator(controlFileMaxDelay, new ControlDirectoryEventFeed(controlFileDirectory)));
    }

    public synchronized void addBooleanParameter(String parameterName, boolean defaultValue) {
        this.map.addParameter(parameterName, defaultValue ? ON : OFF, new IValueFilter(){

            @Override
            public boolean isValid(String value) {
                return ControlFileBasedLogConfiguration.ON.equalsIgnoreCase(value) || ControlFileBasedLogConfiguration.OFF.equalsIgnoreCase(value);
            }
        });
    }

    public synchronized void addBooleanEvent(String eventName) {
        this.map.addParameter(eventName, null, new IValueFilter(){

            @Override
            public boolean isValid(String value) {
                return value == null || ControlFileBasedLogConfiguration.ON.equalsIgnoreCase(value) || ControlFileBasedLogConfiguration.OFF.equalsIgnoreCase(value);
            }
        });
    }

    public synchronized void addLongParameter(String parameterName, long defaultValue) {
        this.map.addParameter(parameterName, String.valueOf(defaultValue), new IValueFilter(){

            @Override
            public boolean isValid(String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Long.valueOf(value);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        });
    }

    public synchronized void addLongEvent(String eventName) {
        this.map.addParameter(eventName, null, new IValueFilter(){

            @Override
            public boolean isValid(String value) {
                if (value == null) {
                    return true;
                }
                try {
                    Long.valueOf(value);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        });
    }

    public synchronized Boolean getBooleanParameterValue(String parameterName) {
        Parameter parameter = this.map.getParameterValue(parameterName);
        if (parameter == null) {
            return null;
        }
        if (parameter.getValue() == null) {
            return null;
        }
        return ON.equalsIgnoreCase(parameter.getValue());
    }

    public synchronized Long getLongParameterValue(String parameterName) {
        Parameter parameter = this.map.getParameterValue(parameterName);
        if (parameter == null) {
            return null;
        }
        if (parameter.getValue() == null) {
            return null;
        }
        return Long.valueOf(parameter.getValue());
    }

    public synchronized BooleanEvent getBooleanEvent(String eventName) {
        Parameter parameter = this.map.getParameterValue(eventName);
        if (parameter == null) {
            return null;
        }
        this.map.removeParameterValue(eventName);
        return new BooleanEvent(eventName, parameter.getValue() != null ? Boolean.valueOf(ON.equalsIgnoreCase(parameter.getValue())) : null);
    }

    public synchronized LongEvent getLongEvent(String eventName) {
        Parameter parameter = this.map.getParameterValue(eventName);
        if (parameter == null) {
            return null;
        }
        this.map.removeParameterValue(eventName);
        return new LongEvent(eventName, parameter.getValue() != null ? Long.valueOf(parameter.getValue()) : null);
    }
}

