/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.DynamicQuery;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.GeneratedKeys;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.QueryParams;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.impl.AbstractMethodImplementation;
import net.lemnik.eodsql.impl.DynamicParameterFactory;
import net.lemnik.eodsql.impl.ExceptionTranslationUtils;
import net.lemnik.eodsql.impl.ManagedConnections;
import net.lemnik.eodsql.impl.MethodImplementationKey;
import net.lemnik.eodsql.impl.SelectDynamicParameterFactory;
import net.lemnik.eodsql.impl.UpdateDynamicParameterFactory;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.MethodImplementation;
import net.lemnik.eodsql.spi.MethodImplementationFactory;
import net.lemnik.eodsql.spi.Resource;
import net.lemnik.eodsql.spi.util.MapDataObjectBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseQueryImpl
implements InvocationHandler {
    protected final Map<Method, Callable> methods = new HashMap<Method, Callable>();
    protected final Map<MethodImplementationKey, MethodImplementation<? extends Annotation>> dynamicMethodImplCache = new HashMap<MethodImplementationKey, MethodImplementation<? extends Annotation>>();
    protected final ConnectionSource connectionSource;

    BaseQueryImpl(ConnectionSource connectionSource, Class<? extends BaseQuery> clazz) {
        this(connectionSource, clazz, BaseQuery.class);
    }

    BaseQueryImpl(ConnectionSource connectionSource, Class<? extends BaseQuery> clazz, Class<? extends BaseQuery> clazz2) {
        this.connectionSource = connectionSource;
        this.createImplementations(clazz, clazz2);
    }

    protected void close() throws SQLException {
        this.connectionSource.close();
    }

    protected boolean isClosed() {
        try {
            return this.connectionSource.isClosed();
        }
        catch (SQLException sQLException) {
            throw new EoDException("isClosed", sQLException);
        }
    }

    private Set<Class> getParentInterfaces(Class<?> clazz) {
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(clazz);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            hashSet.add(clazz2);
        }
        return hashSet;
    }

    private MethodImpl getMethodImpl(Method method) {
        Annotation[] annotationArray = method.getAnnotations();
        MethodImplementationFactory<? extends Annotation> methodImplementationFactory = null;
        Annotation annotation = null;
        for (Annotation annotation2 : annotationArray) {
            MethodImplementationFactory<? extends Annotation> methodImplementationFactory2 = QueryTool.getMethodImplementationFactory(annotation2.annotationType());
            if (methodImplementationFactory2 == null) continue;
            if (methodImplementationFactory != null) {
                throw new InvalidQueryException("All methods in a BaseQuery must have exactly one Method Implementation annotation.", method);
            }
            methodImplementationFactory = methodImplementationFactory2;
            annotation = annotation2;
        }
        if (methodImplementationFactory == null) {
            throw new InvalidQueryException("All methods in a BaseQuery must have an annotation with a matching MethodImplementationFactory.", method);
        }
        return new MethodImpl(methodImplementationFactory.createImplementation(method), annotation);
    }

    protected void createImplementations(Class<? extends BaseQuery> clazz, Class<? extends BaseQuery> clazz2) {
        Set<Class> set = this.getParentInterfaces(clazz2);
        if (DynamicQuery.class.isAssignableFrom(clazz)) {
            set.add(DynamicQuery.class);
            this.addDynamicQueryMethods();
        }
        for (Method method : clazz.getMethods()) {
            if (set.contains(method.getDeclaringClass())) continue;
            this.methods.put(method, this.getMethodImpl(method));
        }
        try {
            Class<BaseQuery> clazz3 = BaseQuery.class;
            this.methods.put(clazz3.getMethod("close", new Class[0]), new InvokeClose());
            this.methods.put(clazz3.getMethod("isClosed", new Class[0]), new InvokeIsClosed());
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void addDynamicQueryMethods() {
        try {
            this.methods.put(DynamicQuery.class.getMethod("select", String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.SIMPLE, DynamicParameterFactory.ReturnType.DATASET)));
            this.methods.put(DynamicQuery.class.getMethod("selectIterator", String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.SIMPLE, DynamicParameterFactory.ReturnType.DATAITERATOR)));
            this.methods.put(DynamicQuery.class.getMethod("selectList", String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.SIMPLE, DynamicParameterFactory.ReturnType.LIST)));
            this.methods.put(DynamicQuery.class.getMethod("selectRow", String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.SIMPLE, DynamicParameterFactory.ReturnType.SINGLEROW)));
            this.methods.put(DynamicQuery.class.getMethod("selectIterator", Integer.TYPE, String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.FETCHSIZE, DynamicParameterFactory.ReturnType.DATAITERATOR)));
            this.methods.put(DynamicQuery.class.getMethod("selectList", Integer.TYPE, String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.FETCHSIZE, DynamicParameterFactory.ReturnType.LIST)));
            this.methods.put(DynamicQuery.class.getMethod("select", Class.class, String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.BASERETURNTYPE, DynamicParameterFactory.ReturnType.DATASET)));
            this.methods.put(DynamicQuery.class.getMethod("selectIterator", Class.class, String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.BASERETURNTYPE, DynamicParameterFactory.ReturnType.DATAITERATOR)));
            this.methods.put(DynamicQuery.class.getMethod("selectList", Class.class, String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.BASERETURNTYPE, DynamicParameterFactory.ReturnType.LIST)));
            this.methods.put(DynamicQuery.class.getMethod("selectRow", Class.class, String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.BASERETURNTYPE, DynamicParameterFactory.ReturnType.SINGLEROW)));
            this.methods.put(DynamicQuery.class.getMethod("select", QueryParams.class, String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.QUERYPARAMS, DynamicParameterFactory.ReturnType.DATASET)));
            this.methods.put(DynamicQuery.class.getMethod("selectIterator", Class.class, Integer.TYPE, String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.BASERETURNTYPE_FETCHSIZE, DynamicParameterFactory.ReturnType.DATAITERATOR)));
            this.methods.put(DynamicQuery.class.getMethod("selectList", Class.class, Integer.TYPE, String.class, Object[].class), new DynamicMethodImpl(new SelectDynamicParameterFactory(SelectDynamicParameterFactory.CallSchema.BASERETURNTYPE_FETCHSIZE, DynamicParameterFactory.ReturnType.LIST)));
            this.methods.put(DynamicQuery.class.getMethod("update", String.class, Object[].class), new DynamicMethodImpl(new UpdateDynamicParameterFactory(Integer.TYPE, -1, true, 0, false, GeneratedKeys.NO_KEYS_RETURNED)));
            this.methods.put(DynamicQuery.class.getMethod("batchUpdate", String.class, Object[].class), new DynamicMethodImpl(new UpdateDynamicParameterFactory(Integer.TYPE, -1, true, 0, true, GeneratedKeys.NO_KEYS_RETURNED)));
            this.methods.put(DynamicQuery.class.getMethod("insert", String.class, Object[].class), new DynamicMethodImpl(new UpdateDynamicParameterFactory(Long.TYPE, -1, true, 0, false, GeneratedKeys.RETURNED_KEYS_FIRST_COLUMN)));
            this.methods.put(DynamicQuery.class.getMethod("insertMultiKeys", String.class, Object[].class), new DynamicMethodImpl(new UpdateDynamicParameterFactory(MapDataObjectBinding.getStringObjectMapObjectType(), -1, true, 0, false, GeneratedKeys.RETURNED_KEYS_DRIVER_DEFINED)));
            this.methods.put(DynamicQuery.class.getMethod("batchInsert", String.class, Object[].class), new DynamicMethodImpl(new UpdateDynamicParameterFactory(long[].class, -1, true, 0, true, GeneratedKeys.RETURNED_KEYS_FIRST_COLUMN)));
            this.methods.put(DynamicQuery.class.getMethod("batchInsertMultiKeys", String.class, Object[].class), new DynamicMethodImpl(new UpdateDynamicParameterFactory(Map[].class, -1, true, 0, true, GeneratedKeys.RETURNED_KEYS_DRIVER_DEFINED)));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Callable callable = this.methods.get(method);
        try {
            return callable.invoke(method, objectArray);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            Class<?>[] classArray = method.getExceptionTypes();
            Class<?> clazz = exception.getClass();
            for (Class<?> clazz2 : classArray) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                throw exception;
            }
            throw ExceptionTranslationUtils.translateException(this.connectionSource, method, objectArray, callable, exception);
        }
    }

    protected Context<Annotation> createContext(Annotation annotation, Class<?> clazz, Object[] objectArray) {
        return new Context<Annotation>(annotation, clazz, objectArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectionSourceConnectionResource
    implements Resource<Connection> {
        private final ConnectionSource connectionSource;
        private Connection connection;

        public ConnectionSourceConnectionResource(ConnectionSource connectionSource) throws SQLException {
            this.connectionSource = connectionSource;
            this.connection = connectionSource.getConnection();
        }

        @Override
        public Connection get() {
            return this.connection;
        }

        @Override
        public boolean isClosed() {
            return this.connection == null;
        }

        @Override
        public void close() throws SQLException {
            Connection connection = this.connection;
            this.connection = null;
            if (connection != null) {
                this.connectionSource.releaseConnection(connection);
            }
        }

        @Override
        public Class<Connection> getResourceType() {
            return Connection.class;
        }
    }

    static class DataSourceConnectionSource
    implements ConnectionSource {
        private static final ThreadLocal<IdentityHashMap<DataSource, ConnectionUtil>> CONNECTION_UTILS = new ThreadLocal<IdentityHashMap<DataSource, ConnectionUtil>>(){

            @Override
            protected IdentityHashMap<DataSource, ConnectionUtil> initialValue() {
                return new IdentityHashMap<DataSource, ConnectionUtil>();
            }
        };
        private final DataSource datasource;
        private final boolean autoCommit;
        private static final Object PRESENT = new Object();
        private final Map<Connection, Object> connections = Collections.synchronizedMap(new IdentityHashMap());

        DataSourceConnectionSource(DataSource dataSource, boolean bl) {
            this.datasource = dataSource;
            this.autoCommit = bl;
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws SQLException {
            Map<Connection, Object> map = this.connections;
            synchronized (map) {
                Iterator<Connection> iterator = this.connections.keySet().iterator();
                while (iterator.hasNext()) {
                    iterator.next().close();
                    iterator.remove();
                }
            }
        }

        public boolean isClosed() throws SQLException {
            return this.connections.isEmpty();
        }

        public Connection getConnection() throws SQLException {
            ConnectionUtil connectionUtil = CONNECTION_UTILS.get().get(this.datasource);
            if (connectionUtil == null || connectionUtil.connection.isClosed()) {
                Connection connection = this.datasource.getConnection();
                try {
                    connection.setAutoCommit(this.autoCommit);
                }
                catch (SQLException sQLException) {
                    throw ExceptionTranslationUtils.translateException(connection, "setAutoCommit", "-", (Exception)sQLException);
                }
                this.connections.put(connection, PRESENT);
                connectionUtil = new ConnectionUtil(connection);
                connectionUtil.count++;
                CONNECTION_UTILS.get().put(this.datasource, connectionUtil);
            } else {
                connectionUtil.count++;
            }
            return connectionUtil.connection;
        }

        public void releaseConnection(Connection connection) throws SQLException {
            ConnectionUtil connectionUtil;
            if (this.connections.containsKey(connection) && --(connectionUtil = CONNECTION_UTILS.get().get(this.datasource)).count <= 0) {
                this.connections.remove(connection);
                connection.close();
                CONNECTION_UTILS.get().remove(this.datasource);
            }
        }

        DataSource getDataSource() {
            return this.datasource;
        }

        private static class ConnectionUtil {
            private final Connection connection;
            private int count;

            ConnectionUtil(Connection connection) {
                this.connection = connection;
                this.count = 0;
            }
        }
    }

    static class ManagedConnectionSource
    implements ConnectionSource {
        private final String database;

        ManagedConnectionSource(String string) {
            if (string == null) {
                throw new IllegalArgumentException("Database name cannot be null");
            }
            this.database = string;
        }

        public Connection getConnection() throws SQLException {
            return ManagedConnections.checkAndGetConnection(this.database);
        }

        public void releaseConnection(Connection connection) throws SQLException {
        }

        public void close() throws SQLException {
        }

        public boolean isClosed() throws SQLException {
            Connection connection = ManagedConnections.getConnection(this.database);
            return connection == null || connection.isClosed();
        }
    }

    static class SingleConnectionSource
    implements ConnectionSource {
        private final Connection connection;
        private final ReentrantLock lock = new ReentrantLock();

        SingleConnectionSource(Connection connection) {
            this.connection = connection;
        }

        public Connection getConnection() throws SQLException {
            try {
                this.lock.lockInterruptibly();
            }
            catch (InterruptedException interruptedException) {
                throw (SQLException)new SQLException().initCause(interruptedException);
            }
            return this.connection;
        }

        public void releaseConnection(Connection connection) throws SQLException {
            if (this.connection == connection) {
                this.lock.unlock();
            }
        }

        public void close() throws SQLException {
            this.connection.close();
        }

        public boolean isClosed() throws SQLException {
            return this.connection.isClosed();
        }
    }

    static interface ConnectionSource {
        public Connection getConnection() throws SQLException;

        public void releaseConnection(Connection var1) throws SQLException;

        public void close() throws SQLException;

        public boolean isClosed() throws SQLException;
    }

    class DynamicMethodImpl
    implements SQLCallable {
        private final DynamicParameterFactory factory;

        public DynamicMethodImpl(DynamicParameterFactory dynamicParameterFactory) {
            this.factory = dynamicParameterFactory;
        }

        private Type createReturnTypeDataSet(final Class clazz) {
            if (this.factory.getReturnType().isSingleRow()) {
                return clazz;
            }
            return new ParameterizedType(){
                private final Class[] typeArgs;
                {
                    this.typeArgs = new Class[]{clazz};
                }

                public Type[] getActualTypeArguments() {
                    return this.typeArgs;
                }

                public Type getRawType() {
                    return DynamicMethodImpl.this.factory.getReturnType().getRawType();
                }

                public Type getOwnerType() {
                    return null;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Method method, Object[] objectArray) throws Throwable {
            Annotation annotation = this.factory.createAnnotation(objectArray);
            Object[] objectArray2 = (Object[])objectArray[objectArray.length - 1];
            Context<Annotation> context = BaseQueryImpl.this.createContext(annotation, method.getReturnType(), objectArray2);
            ConnectionSourceConnectionResource connectionSourceConnectionResource = new ConnectionSourceConnectionResource(BaseQueryImpl.this.connectionSource);
            context.setResource(connectionSourceConnectionResource);
            try {
                MethodImplementationKey methodImplementationKey = new MethodImplementationKey(method, annotation, this.getQueryParamTypes(objectArray2), this.factory.createBaseReturnType(objectArray));
                MethodImplementation<? extends Annotation> methodImplementation = BaseQueryImpl.this.dynamicMethodImplCache.get(methodImplementationKey);
                if (methodImplementation == null) {
                    methodImplementation = this.factory.createMethodImplementation(methodImplementationKey.method, methodImplementationKey.annotation, methodImplementationKey.queryParamTypes, this.createReturnTypeDataSet(methodImplementationKey.baseReturnType), objectArray);
                    BaseQueryImpl.this.dynamicMethodImplCache.put(methodImplementationKey, methodImplementation);
                }
                methodImplementation.invoke(context);
                Object object = context.getReturnValue();
                return object;
            }
            finally {
                if (context.isAutoclose()) {
                    context.close();
                }
            }
        }

        private Class[] getQueryParamTypes(Object[] objectArray) {
            Class[] classArray = new Class[objectArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                classArray[i] = objectArray[i].getClass();
            }
            return classArray;
        }

        public String getSQL(Method method, Object[] objectArray) {
            return this.factory.getSql(objectArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MethodImpl
    implements SQLCallable {
        private final MethodImplementation<Annotation> implementation;
        private final Annotation annotation;

        MethodImpl(MethodImplementation<Annotation> methodImplementation, Annotation annotation) {
            this.implementation = methodImplementation;
            this.annotation = annotation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Method method, Object[] objectArray) throws Throwable {
            Context<Annotation> context = BaseQueryImpl.this.createContext(this.annotation, method.getReturnType(), objectArray);
            ConnectionSourceConnectionResource connectionSourceConnectionResource = new ConnectionSourceConnectionResource(BaseQueryImpl.this.connectionSource);
            context.setResource(connectionSourceConnectionResource);
            try {
                this.implementation.invoke(context);
                Object object = context.getReturnValue();
                return object;
            }
            finally {
                if (context.isAutoclose()) {
                    context.close();
                }
            }
        }

        @Override
        public String getSQL(Method method, Object[] objectArray) {
            return ((AbstractMethodImplementation)this.implementation).query.toString();
        }
    }

    static interface SQLCallable
    extends Callable {
        public String getSQL(Method var1, Object[] var2);
    }

    class InvokeIsClosed
    implements Callable {
        InvokeIsClosed() {
        }

        public Object invoke(Method method, Object[] objectArray) throws Throwable {
            return BaseQueryImpl.this.isClosed();
        }
    }

    class InvokeClose
    implements Callable {
        InvokeClose() {
        }

        public Object invoke(Method method, Object[] objectArray) throws Throwable {
            BaseQueryImpl.this.close();
            return null;
        }
    }

    static interface Callable {
        public Object invoke(Method var1, Object[] var2) throws Throwable;
    }
}

