/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application;

import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.grid.GridWidget;
import ch.systemsx.cisd.cifex.client.application.model.UserGridModel;
import ch.systemsx.cisd.cifex.client.application.page.UserGridRefresherCallback;
import ch.systemsx.cisd.cifex.client.application.ui.DefaultLayoutDialog;
import ch.systemsx.cisd.cifex.client.application.ui.EditUserWidget;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.Button;

public final class EditUserDialog
extends DefaultLayoutDialog {
    private static final int HEIGHT_WITHOUT_EXTERNAL_AUTH = 350;
    private static final int HEIGHT_WITH_EXTERNAL_AUTH = 370;
    private final EditUserWidget editUserWidget;

    public EditUserDialog(ViewContext context, UserInfoDTO user, final GridWidget<UserGridModel> userGrid) {
        super(MessageDictionary.msg(MessageDictionary.EDIT_USER_DIALOG_TITLE, user.getUserCode()), 830, EditUserDialog.getHeight(context));
        this.editUserWidget = new EditUserWidget(context, context.getModel().getUser().isAdmin(), user, false){

            @Override
            protected final void finishEditing() {
                new UserGridRefresherCallback(this.context, userGrid).onSuccess(null);
            }
        };
        this.add((Component)this.editUserWidget);
        this.createUpdateButton();
    }

    private static int getHeight(ViewContext context) {
        boolean hasExternalAuthentication = context.getModel().getConfiguration().getSystemHasExternalAuthentication();
        return hasExternalAuthentication ? 370 : 350;
    }

    private void createUpdateButton() {
        Button button = new Button(this.editUserWidget.getSubmitButtonLabel());
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                if (EditUserDialog.this.editUserWidget.submitForm()) {
                    EditUserDialog.this.hide();
                }
            }
        });
        this.addButton(button);
    }
}

