/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.util.Locale;

public class QuotaExceededException
extends UserFailureException {
    private static final long serialVersionUID = 1L;

    public QuotaExceededException(Integer maxFileCount, Long maxFileSize, int currentFileCount, double currentFileSize) {
        super(QuotaExceededException.constructMessage(maxFileCount, maxFileSize, currentFileCount, currentFileSize));
    }

    private static String constructMessage(Integer maxFileCount, Long maxFileSize, int currentFileCount, double currentFileSize) {
        if (maxFileCount == null) {
            return String.format("The upload would exceed the quota limit of %d MB total size (current usage: %d MB)", maxFileSize, currentFileSize);
        }
        if (maxFileSize == null) {
            return String.format("The upload would exceed the quota limit of %d files (current usage: %d files)", maxFileCount, maxFileSize, currentFileCount, currentFileSize);
        }
        return String.format(Locale.ENGLISH, "The upload would exceed the quota limit of %d files or %d MB total size (current usage: %d files, %1.2f MB)", maxFileCount, maxFileSize, currentFileCount, currentFileSize);
    }
}

