/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.page;

import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.FileCommentGridCellListener;
import ch.systemsx.cisd.cifex.client.application.FileDownloadGridCellListener;
import ch.systemsx.cisd.cifex.client.application.IQuotaInformationUpdater;
import ch.systemsx.cisd.cifex.client.application.ServletPathConstants;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.grid.GridWidget;
import ch.systemsx.cisd.cifex.client.application.model.AbstractFileGridModel;
import ch.systemsx.cisd.cifex.client.application.model.DownloadFileGridModel;
import ch.systemsx.cisd.cifex.client.application.model.OwnedFileGridModel;
import ch.systemsx.cisd.cifex.client.application.page.AbstractMainPageTabController;
import ch.systemsx.cisd.cifex.client.application.page.UploadedFileActionGridCellListener;
import ch.systemsx.cisd.cifex.client.application.utils.ImageUtils;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.client.application.utils.WindowUtils;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import ch.systemsx.cisd.cifex.shared.basic.dto.OwnerFileInfoDTO;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

class FileListingTabHelper {
    private static final long MB = 0x100000L;
    private static final NumberFormat FILE_SIZE_FORMAT = NumberFormat.getFormat((String)"#.#");

    FileListingTabHelper() {
    }

    static final String getMaxFileSize(Long maxFileSizeInMBOrNull) {
        if (maxFileSizeInMBOrNull == null) {
            return "unlimited";
        }
        return maxFileSizeInMBOrNull + " MB";
    }

    static final String getMaxFileCount(Integer maxFileCountOrNull) {
        if (maxFileCountOrNull == null) {
            return "unlimited";
        }
        return Integer.toString(maxFileCountOrNull);
    }

    static final String getCurrentFileSizeInMB(long currentFileSize) {
        return String.valueOf(FILE_SIZE_FORMAT.format((double)currentFileSize / 1048576.0)) + " MB";
    }

    static void createListDownloadFilesGrid(ContentPanel contentPanel, ViewContext context, List<GridWidget<AbstractFileGridModel>> fileGridWidgets, IQuotaInformationUpdater quotaUpdaterOrNull) {
        List<ColumnConfig> columnConfigs = DownloadFileGridModel.getColumnConfigs();
        List filterItems = AbstractFileGridModel.createFilterItems(columnConfigs);
        final GridWidget gridWidget = GridWidget.create(columnConfigs, new ArrayList(), filterItems);
        final Grid grid = gridWidget.getGrid();
        grid.getView().setEmptyText(MessageDictionary.msg(MessageDictionary.DOWNLOAD_FILES_LOADING_MSG));
        fileGridWidgets.add(gridWidget);
        grid.addListener(Events.CellClick, (Listener)new FileDownloadGridCellListener());
        grid.addListener(Events.CellClick, (Listener)new FileCommentGridCellListener());
        AbstractMainPageTabController.addTitleRow(contentPanel, MessageDictionary.msg(MessageDictionary.DOWNLOAD_FILES_PANEL_TITLE));
        AbstractMainPageTabController.addWidgetRow(contentPanel, (Widget)gridWidget.getWidget());
        FileListingTabHelper.addWebStartDownloadClientLink(contentPanel);
        context.getCifexService().listDownloadFiles((AsyncCallback<List<FileInfoDTO>>)new AbstractAsyncCallback<List<FileInfoDTO>>(context){

            public void onSuccess(List<FileInfoDTO> result) {
                grid.getView().setEmptyText(MessageDictionary.msg(MessageDictionary.DOWNLOAD_FILES_EMPTY_MSG));
                gridWidget.setDataAndRefresh(DownloadFileGridModel.convert(result));
            }

            @Override
            public void onFailure(Throwable caught) {
                grid.getView().setEmptyText(MessageDictionary.msg(MessageDictionary.DOWNLOAD_FILES_EMPTY_MSG));
                super.onFailure(caught);
            }
        });
    }

    private static void addWebStartDownloadClientLink(ContentPanel verticalPanel) {
        AbstractMainPageTabController.addTitleRow(verticalPanel, MessageDictionary.msg(MessageDictionary.DOWNLOAD_FILES_WEBSTART_PANEL_TITLE));
        String webStartTitle = MessageDictionary.msg(MessageDictionary.LAUNCH_JWS_APPLICATION_TITLE);
        final String servletName = ServletPathConstants.FILE2GB_DOWNLOAD_SERVLET_NAME;
        String buttonTitle = MessageDictionary.msg(MessageDictionary.DOWNLOAD_FILES_LAUNCH_WEBSTART_LABEL);
        Button launchButton = new Button(buttonTitle, (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                WindowUtils.openNewDependentWindow(servletName);
            }
        });
        launchButton.setIcon(AbstractImagePrototype.create((ImageResource)ImageUtils.ICONS.getDownloaderIcon()));
        launchButton.setTitle(webStartTitle);
        launchButton.setHeight(30);
        launchButton.setIconAlign(Style.IconAlign.LEFT);
        verticalPanel.add((Widget)launchButton, (LayoutData)new RowData(-1.0, -1.0, new Margins(20, 20, 20, 40)));
        verticalPanel.add((Widget)new Html(MessageDictionary.msg(MessageDictionary.DOWNLOAD_FILES_WEBSTART_PROS_INFO)), (LayoutData)new RowData(-1.0, -1.0, new Margins(0, 10, 10, 30)));
    }

    static void createListOwnedFilesGrid(ViewContext context, ContentPanel contentPanel, List<GridWidget<AbstractFileGridModel>> fileGridWidgets, IQuotaInformationUpdater quotaUpdaterOrNull) {
        List<ColumnConfig> columnConfigs = OwnedFileGridModel.getColumnConfigs();
        List filterItems = AbstractFileGridModel.createFilterItems(columnConfigs);
        final GridWidget<AbstractFileGridModel> gridWidget = GridWidget.create(columnConfigs, new ArrayList(), filterItems);
        final Grid grid = gridWidget.getGrid();
        grid.getView().setEmptyText(MessageDictionary.msg(MessageDictionary.LIST_FILES_SHARED_LOADING_MSG));
        fileGridWidgets.add(gridWidget);
        grid.addListener(Events.CellClick, (Listener)new FileDownloadGridCellListener());
        grid.addListener(Events.CellClick, (Listener)new FileCommentGridCellListener());
        grid.addListener(Events.CellClick, (Listener)new UploadedFileActionGridCellListener(context, gridWidget, fileGridWidgets, quotaUpdaterOrNull));
        AbstractMainPageTabController.addTitleRow(contentPanel, MessageDictionary.msg(MessageDictionary.LIST_FILES_SHARED_TITLE));
        AbstractMainPageTabController.addWidgetRow(contentPanel, (Widget)gridWidget.getWidget());
        context.getCifexService().listOwnedFiles((AsyncCallback<List<OwnerFileInfoDTO>>)new AbstractAsyncCallback<List<OwnerFileInfoDTO>>(context){

            public void onSuccess(List<OwnerFileInfoDTO> result) {
                grid.getView().setEmptyText(MessageDictionary.msg(MessageDictionary.LIST_FILES_SHARED_EMPTY_MSG));
                gridWidget.setDataAndRefresh(OwnedFileGridModel.convert(result));
            }

            @Override
            public void onFailure(Throwable caught) {
                grid.getView().setEmptyText(MessageDictionary.msg(MessageDictionary.LIST_FILES_SHARED_EMPTY_MSG));
                super.onFailure(caught);
            }
        });
    }
}

