/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderFactory;
import ch.systemsx.cisd.imagereaders.ReadParams;
import java.awt.Component;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.media.jai.widget.ScrollingImagePanel;
import org.apache.log4j.BasicConfigurator;

public class BioFormatsImageJImageViewer {
    private static void showImage(RenderedImage image) {
        Frame frame = new Frame("Image");
        ScrollingImagePanel panel = new ScrollingImagePanel(image, image.getWidth() + 10, image.getHeight() + 10);
        frame.add((Component)panel);
        frame.setLocationByPlatform(true);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Syntax: showBioFormatsImage <imagefile>");
            System.exit(1);
        }
        BasicConfigurator.configure();
        String fileName = args[0];
        IImageReader imageReader = ImageReaderFactory.tryGetReaderForFile((String)"BioFormats", (String)fileName);
        File file = new File(fileName);
        ReadParams readParams = new ReadParams();
        readParams.setIntensityRescalingChannel(Integer.valueOf(0));
        BufferedImage image = imageReader.readImage(file, ImageID.NULL, (IReadParams)readParams);
        BioFormatsImageJImageViewer.showImage(image);
    }
}

