/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Database;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexCodes {
    static final byte ASC_START_FLAG = 127;
    static final byte ASC_NULL_FLAG = 0;
    static final byte DESC_START_FLAG = -128;
    static final byte DESC_NULL_FLAG = -1;
    static final byte END_TEXT = 1;
    static final byte END_EXTRA_TEXT = 0;
    static final byte MID_GUID = 9;
    static final byte ASC_END_GUID = 8;
    static final byte DESC_END_GUID = -9;
    static final byte ASC_BOOLEAN_TRUE = 0;
    static final byte ASC_BOOLEAN_FALSE = -1;
    static final byte DESC_BOOLEAN_TRUE = -1;
    static final byte DESC_BOOLEAN_FALSE = 0;
    static final int UNPRINTABLE_COUNT_START = 7;
    static final int UNPRINTABLE_COUNT_MULTIPLIER = 4;
    static final int UNPRINTABLE_OFFSET_FLAGS = 32768;
    static final byte UNPRINTABLE_MIDFIX = 6;
    static final byte INTERNATIONAL_EXTRA_PLACEHOLDER = 2;
    static final byte CRAZY_CODE_START = -128;
    static final byte CRAZY_CODE_1 = 2;
    static final byte CRAZY_CODE_2 = 3;
    static final byte[] CRAZY_CODES_SUFFIX = new byte[]{-1, 2, -128, -1, -128};
    static final byte CRAZY_CODES_UNPRINT_SUFFIX = -1;
    private static final String CODES_FILE = Database.RESOURCE_PATH + "index_codes.txt";
    private static final String EXT_CODES_FILE = Database.RESOURCE_PATH + "index_codes_ext.txt";
    static final CharHandler IGNORED_CHAR_HANDLER = new CharHandler(){

        public Type getType() {
            return Type.IGNORED;
        }
    };
    static final CharHandler SURROGATE_CHAR_HANDLER = new CharHandler(){

        public Type getType() {
            return Type.IGNORED;
        }

        public byte[] getInlineBytes() {
            throw new IllegalStateException("Surrogate pair chars are not handled");
        }
    };
    private static final char FIRST_CHAR = '\u0000';
    private static final char LAST_CHAR = '\u00ff';
    private static final char FIRST_EXT_CHAR = '\u0100';
    private static final char LAST_EXT_CHAR = '\uffff';

    private IndexCodes() {
    }

    static CharHandler getCharHandler(char c) {
        if (c <= '\u00ff') {
            return Codes._values[c];
        }
        int extOffset = IndexCodes.asUnsignedChar(c) - IndexCodes.asUnsignedChar('\u0100');
        return ExtCodes._values[extOffset];
    }

    private static CharHandler[] loadCodes(String codesFilePath, char firstChar, char lastChar) {
        int numCodes = IndexCodes.asUnsignedChar(lastChar) - IndexCodes.asUnsignedChar(firstChar) + 1;
        CharHandler[] values = new CharHandler[numCodes];
        HashMap<String, Type> prefixMap = new HashMap<String, Type>();
        for (Type type : Type.values()) {
            prefixMap.put(type.getPrefixCode(), type);
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(codesFilePath), "US-ASCII"));
            int start = IndexCodes.asUnsignedChar(firstChar);
            int end = IndexCodes.asUnsignedChar(lastChar);
            for (int i = start; i <= end; ++i) {
                char c = (char)i;
                CharHandler ch = null;
                if (Character.isHighSurrogate(c) || Character.isLowSurrogate(c)) {
                    ch = SURROGATE_CHAR_HANDLER;
                } else {
                    String codeLine = reader.readLine();
                    ch = IndexCodes.parseCodes(prefixMap, codeLine);
                }
                values[i - start] = ch;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("failed loading index codes file " + codesFilePath, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
        return values;
    }

    private static CharHandler parseCodes(Map<String, Type> prefixMap, String codeLine) {
        String prefix = codeLine.substring(0, 1);
        String suffix = codeLine.length() > 1 ? codeLine.substring(2) : "";
        return prefixMap.get(prefix).parseCodes(suffix.split(",", -1));
    }

    private static CharHandler parseSimpleCodes(String[] codeStrings) {
        if (codeStrings.length != 1) {
            throw new IllegalStateException("Unexpected code strings " + Arrays.asList(codeStrings));
        }
        return new SimpleCharHandler(IndexCodes.codesToBytes(codeStrings[0], true));
    }

    private static CharHandler parseInternationalCodes(String[] codeStrings) {
        if (codeStrings.length != 2) {
            throw new IllegalStateException("Unexpected code strings " + Arrays.asList(codeStrings));
        }
        return new InternationalCharHandler(IndexCodes.codesToBytes(codeStrings[0], true), IndexCodes.codesToBytes(codeStrings[1], true));
    }

    private static CharHandler parseUnprintableCodes(String[] codeStrings) {
        if (codeStrings.length != 1) {
            throw new IllegalStateException("Unexpected code strings " + Arrays.asList(codeStrings));
        }
        return new UnprintableCharHandler(IndexCodes.codesToBytes(codeStrings[0], true));
    }

    private static CharHandler parseUnprintableExtCodes(String[] codeStrings) {
        if (codeStrings.length != 1) {
            throw new IllegalStateException("Unexpected code strings " + Arrays.asList(codeStrings));
        }
        byte[] bytes = IndexCodes.codesToBytes(codeStrings[0], true);
        if (bytes.length != 1) {
            throw new IllegalStateException("Unexpected code strings " + Arrays.asList(codeStrings));
        }
        return new UnprintableExtCharHandler(bytes[0]);
    }

    private static CharHandler parseInternationalExtCodes(String[] codeStrings) {
        if (codeStrings.length != 3) {
            throw new IllegalStateException("Unexpected code strings " + Arrays.asList(codeStrings));
        }
        byte crazyFlag = "1".equals(codeStrings[2]) ? (byte)2 : 3;
        return new InternationalExtCharHandler(IndexCodes.codesToBytes(codeStrings[0], true), IndexCodes.codesToBytes(codeStrings[1], false), crazyFlag);
    }

    private static byte[] codesToBytes(String codes, boolean required) {
        if (codes.length() == 0) {
            if (required) {
                throw new IllegalStateException("empty code bytes");
            }
            return null;
        }
        byte[] bytes = new byte[codes.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int charIdx = i * 2;
            bytes[i] = (byte)Integer.parseInt(codes.substring(charIdx, charIdx + 2), 16);
        }
        return bytes;
    }

    private static int asUnsignedChar(char c) {
        return c & 0xFFFF;
    }

    static boolean isNullEntry(byte startEntryFlag) {
        return startEntryFlag == 0 || startEntryFlag == -1;
    }

    static byte getNullEntryFlag(boolean isAscending) {
        return isAscending ? (byte)0 : -1;
    }

    static byte getStartEntryFlag(boolean isAscending) {
        return isAscending ? (byte)127 : -128;
    }

    static /* synthetic */ String access$600() {
        return CODES_FILE;
    }

    static /* synthetic */ CharHandler[] access$700(String x0, char x1, char x2) {
        return IndexCodes.loadCodes(x0, x1, x2);
    }

    static /* synthetic */ String access$800() {
        return EXT_CODES_FILE;
    }

    private static final class ExtCodes {
        private static final CharHandler[] _values = IndexCodes.access$700(IndexCodes.access$800(), '\u0100', '\uffff');

        private ExtCodes() {
        }
    }

    private static final class Codes {
        private static final CharHandler[] _values = IndexCodes.access$700(IndexCodes.access$600(), '\u0000', '\u00ff');

        private Codes() {
        }
    }

    private static final class InternationalExtCharHandler
    extends CharHandler {
        private byte[] _bytes;
        private byte[] _extraBytes;
        private byte _crazyFlag;

        private InternationalExtCharHandler(byte[] bytes, byte[] extraBytes, byte crazyFlag) {
            this._bytes = bytes;
            this._extraBytes = extraBytes;
            this._crazyFlag = crazyFlag;
        }

        public Type getType() {
            return Type.INTERNATIONAL_EXT;
        }

        public byte[] getInlineBytes() {
            return this._bytes;
        }

        public byte[] getExtraBytes() {
            return this._extraBytes;
        }

        public byte getCrazyFlag() {
            return this._crazyFlag;
        }
    }

    private static final class UnprintableExtCharHandler
    extends CharHandler {
        private byte _extraByteMod;

        private UnprintableExtCharHandler(Byte extraByteMod) {
            this._extraByteMod = extraByteMod;
        }

        public Type getType() {
            return Type.UNPRINTABLE_EXT;
        }

        public byte getExtraByteModifier() {
            return this._extraByteMod;
        }
    }

    private static final class UnprintableCharHandler
    extends CharHandler {
        private byte[] _unprintBytes;

        private UnprintableCharHandler(byte[] unprintBytes) {
            this._unprintBytes = unprintBytes;
        }

        public Type getType() {
            return Type.UNPRINTABLE;
        }

        public byte[] getUnprintableBytes() {
            return this._unprintBytes;
        }
    }

    private static final class InternationalCharHandler
    extends CharHandler {
        private byte[] _bytes;
        private byte[] _extraBytes;

        private InternationalCharHandler(byte[] bytes, byte[] extraBytes) {
            this._bytes = bytes;
            this._extraBytes = extraBytes;
        }

        public Type getType() {
            return Type.INTERNATIONAL;
        }

        public byte[] getInlineBytes() {
            return this._bytes;
        }

        public byte[] getExtraBytes() {
            return this._extraBytes;
        }
    }

    private static final class SimpleCharHandler
    extends CharHandler {
        private byte[] _bytes;

        private SimpleCharHandler(byte[] bytes) {
            this._bytes = bytes;
        }

        public Type getType() {
            return Type.SIMPLE;
        }

        public byte[] getInlineBytes() {
            return this._bytes;
        }
    }

    static abstract class CharHandler {
        CharHandler() {
        }

        public abstract Type getType();

        public byte[] getInlineBytes() {
            return null;
        }

        public byte[] getExtraBytes() {
            return null;
        }

        public byte[] getUnprintableBytes() {
            return null;
        }

        public byte getExtraByteModifier() {
            return 0;
        }

        public byte getCrazyFlag() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        SIMPLE("S"){

            public CharHandler parseCodes(String[] codeStrings) {
                return IndexCodes.parseSimpleCodes(codeStrings);
            }
        }
        ,
        INTERNATIONAL("I"){

            public CharHandler parseCodes(String[] codeStrings) {
                return IndexCodes.parseInternationalCodes(codeStrings);
            }
        }
        ,
        UNPRINTABLE("U"){

            public CharHandler parseCodes(String[] codeStrings) {
                return IndexCodes.parseUnprintableCodes(codeStrings);
            }
        }
        ,
        UNPRINTABLE_EXT("P"){

            public CharHandler parseCodes(String[] codeStrings) {
                return IndexCodes.parseUnprintableExtCodes(codeStrings);
            }
        }
        ,
        INTERNATIONAL_EXT("Z"){

            public CharHandler parseCodes(String[] codeStrings) {
                return IndexCodes.parseInternationalExtCodes(codeStrings);
            }
        }
        ,
        IGNORED("X"){

            public CharHandler parseCodes(String[] codeStrings) {
                return IGNORED_CHAR_HANDLER;
            }
        };

        private final String _prefixCode;

        private Type(String prefixCode) {
            this._prefixCode = prefixCode;
        }

        public String getPrefixCode() {
            return this._prefixCode;
        }

        public abstract CharHandler parseCodes(String[] var1);
    }
}

