/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.gui;

import ch.systemsx.sybit.imageviewer.connectors.DataConnector;
import ch.systemsx.sybit.imageviewer.connectors.LocalSystemConnector;
import ch.systemsx.sybit.imageviewer.connectors.OpenBISConnector;
import ch.systemsx.sybit.imageviewer.data.ImageHandler;
import ch.systemsx.sybit.imageviewer.data.ImageViewerParameters;
import ch.systemsx.sybit.imageviewer.data.MinMaxInChannel;
import ch.systemsx.sybit.imageviewer.data.SettingsUtil;
import ch.systemsx.sybit.imageviewer.gui.ErrorDialog;
import ch.systemsx.sybit.imageviewer.gui.ImagePanel;
import ch.systemsx.sybit.imageviewer.gui.ImageViewerMenu;
import ch.systemsx.sybit.imageviewer.gui.ImagesListPanel;
import ch.systemsx.sybit.imageviewer.gui.OperationPanel;
import ch.systemsx.sybit.imageviewer.processors.ImageUtil;
import ch.systemsx.sybit.imageviewer.processors.LutProcessor;
import ch.systemsx.sybit.imageviewer.service.ImageViewerServer;
import ch.systemsx.sybit.imageviewer.utils.ImageViewerUtils;
import ij.process.ImageStatistics;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageViewer
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private Container content;
    private ImageViewerMenu menuBar;
    private ImagePanel imagePanel;
    private JScrollPane imagePanelScrollWraper;
    private ImagesListPanel imageList;
    private OperationPanel operationPanel;
    private DataConnector dataConnector;
    private ImageViewerParameters imageViewerParameters;
    private ImageViewerParameters savedImageViewerParameters;
    private List<ImageHandler> images;
    private int currentImageId;
    private int maxImageWidth = 0;
    private int maxImageHeight = 0;
    private ImageStatistics originalImageStatistics;
    private JPanel centerPanel;
    private JPanel imageNamePanel;
    private JLabel imageName;
    private String imageScale = "thumbnail";
    private int mode;
    private ErrorDialog errorDialog;

    public ImageViewer(ImageViewerParameters storedParameters, String[] args, int mode) throws Throwable {
        this.savedImageViewerParameters = storedParameters;
        this.mode = mode;
        this.init(args);
    }

    public ImageViewer(String[] args, int mode, String defaultImageScale) throws Throwable {
        this.mode = mode;
        this.imageScale = defaultImageScale;
        this.init(args);
    }

    public void init(String[] args) throws Throwable {
        this.setTitle("ImageViewer (v" + SettingsUtil.version + ")");
        this.setDefaultCloseOperation(2);
        if (this.mode == SettingsUtil.OpenBIS) {
            this.dataConnector = new OpenBISConnector(args, this);
            this.setTitle("ImageViewer: Experiment: " + args[2] + ", Channel: " + args[3]);
        } else {
            this.dataConnector = new LocalSystemConnector(this, args);
        }
        if (this.savedImageViewerParameters == null) {
            this.savedImageViewerParameters = this.dataConnector.getParameters();
        }
        if (this.savedImageViewerParameters != null) {
            this.imageViewerParameters = ImageViewerUtils.generateParametersCopy(this.savedImageViewerParameters);
        }
        this.images = new ArrayList<ImageHandler>();
        if (this.mode == SettingsUtil.OpenBIS) {
            this.maxImageWidth = SettingsUtil.defaultThumbnailWidth + 250;
            this.maxImageHeight = SettingsUtil.defaultThumbnailHeight + 250;
        }
        this.currentImageId = 0;
        this.addWindowListener(this);
        this.content = this.getContentPane();
        this.content.setBackground(Color.white);
        this.content.setLayout(new BorderLayout());
        this.imageList = new ImagesListPanel(this, this.mode);
        this.centerPanel = new JPanel(new BorderLayout());
        this.imageNamePanel = new JPanel();
        this.imageName = new JLabel();
        this.imageName.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.imageNamePanel.setBackground(Color.white);
        this.imageNamePanel.add(this.imageName);
        this.centerPanel.add((Component)this.imageNamePanel, "North");
        this.imagePanelScrollWraper = new JScrollPane();
        this.imagePanel = new ImagePanel(this);
        this.imagePanel.setLoadingImage();
        this.centerPanel.add((Component)this.imagePanel, "Center");
        this.imagePanelScrollWraper.setViewportView(this.centerPanel);
        this.imagePanelScrollWraper.setHorizontalScrollBarPolicy(30);
        this.imagePanelScrollWraper.setBackground(Color.white);
        this.imagePanelScrollWraper.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.content.add((Component)this.imagePanelScrollWraper, "Center");
        this.content.add((Component)this.imageList, "South");
        this.menuBar = new ImageViewerMenu(this, this.mode, this.imageScale);
        this.content.add((Component)this.menuBar, "North");
        this.operationPanel = new OperationPanel(this);
        this.content.add((Component)this.operationPanel, "East");
        this.setMinimumSize(new Dimension(this.maxImageWidth + 400, Math.max(this.maxImageHeight + 100, 450) + 40));
        this.pack();
        if (this.mode != SettingsUtil.OpenBIS) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize(screenSize.width, screenSize.height);
            this.setExtendedState(6);
        }
    }

    public void loadImages(String fileNameFilter) {
        try {
            this.dataConnector.loadImages(fileNameFilter);
        }
        catch (Throwable t) {
            this.showErrorDialog("Error during loading image", t, false);
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ImageViewer.this.imageList.getList().grabFocus();
                }
            });
        }
        catch (Throwable t) {
            this.showErrorDialog("Error during trying to focus on list", t, false);
        }
    }

    public static void main(String[] args) throws Throwable {
        int mode = SettingsUtil.LocalSystem;
        String defaultScale = "thumbnail";
        String fileNameFilter = null;
        boolean daemonMode = false;
        int port = SettingsUtil.daemonPort;
        String topPath = null;
        if (args != null && args.length > 0) {
            mode = SettingsUtil.OpenBIS;
        }
        if (daemonMode) {
            ImageViewerServer server = null;
            try {
                server = new ImageViewerServer(port, topPath);
            }
            catch (Throwable t) {
                System.out.println("Could not start server - check if port: " + port + " is not used by the other applicatons" + " or is blocked by firewall. If you need to change port please start the application with" + " parameters: -d -p 8080 , where 8080 is selected port number.\n");
                throw t;
            }
            try {
                server.run();
            }
            catch (Throwable t) {
                System.out.println("Error during connection to the server");
                throw t;
            }
            System.out.println("Daemon started");
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (UnsupportedLookAndFeelException e) {
                e.printStackTrace();
            }
            try {
                final ImageViewer imageViewer = new ImageViewer(args, mode, defaultScale);
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    public void uncaughtException(Thread t, Throwable e) {
                        imageViewer.showErrorDialog("Default handler", e, true);
                        e.printStackTrace();
                    }
                });
                imageViewer.setVisible(true);
                if (mode == SettingsUtil.OpenBIS || args != null && args.length > 0) {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            imageViewer.showLoading();
                        }
                    });
                }
                imageViewer.loadImages(fileNameFilter);
            }
            catch (Throwable t) {
                t.printStackTrace();
                new ErrorDialog("Error during initialization", t, true).setVisible(true);
            }
        }
    }

    public ImageViewerParameters getImageViewerParameters() {
        return this.imageViewerParameters;
    }

    public void setImageViewerParameters(ImageViewerParameters imageViewerParameters) {
        this.imageViewerParameters = imageViewerParameters;
    }

    public void saveModifiedParameters() {
        try {
            this.dataConnector.save(this.imageViewerParameters);
            this.savedImageViewerParameters = ImageViewerUtils.generateParametersCopy(this.imageViewerParameters);
        }
        catch (Throwable t) {
            this.showErrorDialog("Parameters can not be saved", t, false);
        }
    }

    public void updateImage() {
        this.imagePanel.updateImage();
    }

    public void cleanImage() {
        this.imagePanel.cleanImagePanel();
    }

    public void setImageName(String text) {
        this.imageName.setText(text);
    }

    public void showLoading() {
        this.imagePanel.showLoadingImage();
    }

    public ImageHandler getImageHandler() {
        if (this.images.size() >= this.currentImageId + 1 && this.currentImageId != -1) {
            if (!this.imageScale.equals("thumbnail")) {
                if (this.images.get(this.currentImageId).getFullSizeImage() == null) {
                    ImageHandler fullSizeImage = null;
                    try {
                        fullSizeImage = this.mode == SettingsUtil.OpenBIS ? ((OpenBISConnector)this.dataConnector).loadFullSizeImage(this.images.get(this.currentImageId).getImageReference()) : ((LocalSystemConnector)this.dataConnector).loadFullSizeImage(this.images.get(this.currentImageId).getPath());
                    }
                    catch (Throwable t) {
                        this.showErrorDialog("Error during loading full size image", t, true);
                    }
                    this.images.get(this.currentImageId).setFullSizeImage(fullSizeImage);
                    if (fullSizeImage == null) {
                        this.imageScale = "thumbnail";
                        this.showErrorDialog("Full size image can not be loaded", new Throwable("Full size image can not be loaded"), true);
                        return this.images.get(this.currentImageId);
                    }
                }
                return this.images.get(this.currentImageId).getFullSizeImage();
            }
            return this.images.get(this.currentImageId);
        }
        return null;
    }

    public ImageStatistics getOriginalImageStatistics() {
        return this.originalImageStatistics;
    }

    public void setupImage() {
        this.getImageHandler().getImage().getProcessor().reset();
        this.originalImageStatistics = new ImageStatistics();
        this.originalImageStatistics.histogram = (int[])this.getImageHandler().getImage().getStatistics().histogram.clone();
        this.originalImageStatistics.maxCount = this.getImageHandler().getImage().getStatistics().maxCount;
        LutProcessor lutProcessor = new LutProcessor();
        if (this.getImageHandler().getImage().getType() != 4 && this.getImageHandler().getOriginalImage() != null && this.getImageHandler().getOriginalImage().getType() == 4 && !this.getImageHandler().getImage().getStack().isRGB() && this.imageViewerParameters.getLutOperation().equals("")) {
            lutProcessor.restoreOriginalImage(this.getImageHandler());
        } else if (this.getImageHandler().getImage().getType() != 4 || !this.imageViewerParameters.getLutOperation().equals("")) {
            lutProcessor.doOperation(this.imageViewerParameters.getLutOperation(), this.imageViewerParameters.getSlice(), this.getImageHandler().getImage(), this.getImageHandler().getOriginalColorModel());
        }
        this.getImageHandler().getImage().getProcessor().snapshot();
        ImageUtil.modifyContrastBrightness(this.getImageHandler().getImage(), this.imageViewerParameters);
    }

    public void refreshGuiAfterImageSelection() {
        this.setupImage();
        if (this.getImageHandler().getImageReference() != null) {
            this.imageName.setText(this.getImageHandler().getImageReference().toString());
        } else if (this.getImageHandler().getPath() != null) {
            this.imageName.setText(this.getImageHandler().getPath());
        }
        this.operationPanel.refreshGuiAfterImageSelection();
    }

    public void refreshColorPanel() {
        this.hideColorPanel();
        this.showColorPanel();
    }

    public void showColorPanel() {
        this.operationPanel.showColorPanel();
    }

    public void hideColorPanel() {
        this.operationPanel.hideColorPanel();
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.checkBeforeExit();
        this.operationPanel.finish();
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public void setCurrentImageId(int currentImageId) {
        this.currentImageId = currentImageId;
    }

    public int getCurrentImageId() {
        return this.currentImageId;
    }

    public List<ImageHandler> getImages() {
        return this.images;
    }

    public int getMaxImageWidth() {
        return this.maxImageWidth;
    }

    public int getMaxImageHeight() {
        return this.maxImageHeight;
    }

    public OperationPanel getOperationPanel() {
        return this.operationPanel;
    }

    public ImagesListPanel getImagesList() {
        return this.imageList;
    }

    public ImagePanel getImagePanel() {
        return this.imagePanel;
    }

    public void resetAll() {
        this.imageViewerParameters.setMin(0.0);
        this.imageViewerParameters.setMax(255.0);
        this.imageViewerParameters.setMinMaxInChannels(new HashMap<Integer, MinMaxInChannel>());
        this.imageViewerParameters.setSlice(1);
        this.imageViewerParameters.setLutOperation("");
        if (this.imageList != null && this.images.size() > 0) {
            this.refreshGuiAfterImageSelection();
            this.updateImage();
        }
    }

    public void restoreLastSaved() {
        try {
            this.imageViewerParameters = ImageViewerUtils.generateParametersCopy(this.savedImageViewerParameters);
        }
        catch (Throwable t) {
            this.showErrorDialog("Can not restored last saved parameters", t, false);
        }
        if (this.imageList != null && this.images.size() > 0) {
            this.refreshGuiAfterImageSelection();
            this.updateImage();
        }
    }

    public void checkBeforeExit() {
        int decision;
        if (!this.imageViewerParameters.equals(this.savedImageViewerParameters) && (decision = JOptionPane.showConfirmDialog(null, "Do you want to save modifications?", "Exit", 0)) == 0) {
            this.saveModifiedParameters();
        }
    }

    public JScrollPane getImagePanelScrollWraper() {
        return this.imagePanelScrollWraper;
    }

    public int getMode() {
        return this.mode;
    }

    public ImageViewerMenu getImageViewerMenu() {
        return this.menuBar;
    }

    public void setImageScale(String imageScale) {
        this.imageScale = imageScale;
    }

    public void selectImageScaleItem(String imageScale) {
        this.menuBar.selectSizeItem(imageScale);
    }

    public String getImageScale() {
        return this.imageScale;
    }

    public void stopLoading() {
        if (this.dataConnector != null) {
            this.dataConnector.stopLoading();
        }
    }

    public void cleanImagesList() {
        this.imageList.cleanImagesList();
    }

    public void updateInputFiles(String[] files) {
        if (this.dataConnector != null && this.dataConnector instanceof LocalSystemConnector) {
            ((LocalSystemConnector)this.dataConnector).setFiles(files);
        }
    }

    public void finish() {
        if (this.dataConnector != null) {
            this.dataConnector.stopLoading();
        }
        if (this.operationPanel != null) {
            this.operationPanel.finish();
        }
    }

    public synchronized void showErrorDialog(String title, Throwable t, boolean closeApplication) {
        if (this.errorDialog == null) {
            this.errorDialog = new ErrorDialog(title, t, closeApplication);
        } else {
            this.errorDialog.addErrorMessage(t);
            this.errorDialog.setCloseApplication(closeApplication);
        }
        this.errorDialog.setVisible(true);
        t.printStackTrace();
        if (closeApplication) {
            this.setEnabled(false);
        }
    }
}

