/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.FilterSet;
import ome.xml.model.Instrument;
import ome.xml.model.LightPath;
import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.TransmittanceRange;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.FilterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Filter
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Filter.class);
    private String filterWheel;
    private FilterType type;
    private String id;
    private TransmittanceRange transmittanceRange;
    private Instrument instrument;
    private List<FilterSet> filterSetExcitationFilterLinks = new ArrayList<FilterSet>();
    private List<FilterSet> filterSetEmissionFilterLinks = new ArrayList<FilterSet>();
    private List<LightPath> lightPathExcitationFilterLinks = new ArrayList<LightPath>();
    private List<LightPath> lightPathEmissionFilterLinks = new ArrayList<LightPath>();

    public Filter() {
    }

    public Filter(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> TransmittanceRange_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Filter".equals(tagName)) {
            LOGGER.debug("Expecting node name of Filter got {}", (Object)tagName);
        }
        if (element.hasAttribute("FilterWheel")) {
            this.setFilterWheel(String.valueOf(element.getAttribute("FilterWheel")));
        }
        if (element.hasAttribute("Type")) {
            this.setType(FilterType.fromString(element.getAttribute("Type")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Filter missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((TransmittanceRange_nodeList = Filter.getChildrenByTagName(element, "TransmittanceRange")).size() > 1) {
            throw new RuntimeException(String.format("TransmittanceRange node list size %d != 1", TransmittanceRange_nodeList.size()));
        }
        if (TransmittanceRange_nodeList.size() != 0) {
            this.setTransmittanceRange(new TransmittanceRange(TransmittanceRange_nodeList.get(0), model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public String getFilterWheel() {
        return this.filterWheel;
    }

    public void setFilterWheel(String filterWheel) {
        this.filterWheel = filterWheel;
    }

    public FilterType getType() {
        return this.type;
    }

    public void setType(FilterType type) {
        this.type = type;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public TransmittanceRange getTransmittanceRange() {
        return this.transmittanceRange;
    }

    public void setTransmittanceRange(TransmittanceRange transmittanceRange) {
        this.transmittanceRange = transmittanceRange;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument_BackReference) {
        this.instrument = instrument_BackReference;
    }

    public int sizeOfLinkedFilterSetExcitationFilterList() {
        return this.filterSetExcitationFilterLinks.size();
    }

    public List<FilterSet> copyLinkedFilterSetExcitationFilterList() {
        return new ArrayList<FilterSet>(this.filterSetExcitationFilterLinks);
    }

    public FilterSet getLinkedFilterSetExcitationFilter(int index) {
        return this.filterSetExcitationFilterLinks.get(index);
    }

    public FilterSet setLinkedFilterSetExcitationFilter(int index, FilterSet o) {
        return this.filterSetExcitationFilterLinks.set(index, o);
    }

    public boolean linkFilterSetExcitationFilter(FilterSet o) {
        if (!this.filterSetExcitationFilterLinks.contains(o)) {
            return this.filterSetExcitationFilterLinks.add(o);
        }
        return false;
    }

    public boolean unlinkFilterSetExcitationFilter(FilterSet o) {
        return this.filterSetExcitationFilterLinks.remove(o);
    }

    public int sizeOfLinkedFilterSetEmissionFilterList() {
        return this.filterSetEmissionFilterLinks.size();
    }

    public List<FilterSet> copyLinkedFilterSetEmissionFilterList() {
        return new ArrayList<FilterSet>(this.filterSetEmissionFilterLinks);
    }

    public FilterSet getLinkedFilterSetEmissionFilter(int index) {
        return this.filterSetEmissionFilterLinks.get(index);
    }

    public FilterSet setLinkedFilterSetEmissionFilter(int index, FilterSet o) {
        return this.filterSetEmissionFilterLinks.set(index, o);
    }

    public boolean linkFilterSetEmissionFilter(FilterSet o) {
        if (!this.filterSetEmissionFilterLinks.contains(o)) {
            return this.filterSetEmissionFilterLinks.add(o);
        }
        return false;
    }

    public boolean unlinkFilterSetEmissionFilter(FilterSet o) {
        return this.filterSetEmissionFilterLinks.remove(o);
    }

    public int sizeOfLinkedLightPathExcitationFilterList() {
        return this.lightPathExcitationFilterLinks.size();
    }

    public List<LightPath> copyLinkedLightPathExcitationFilterList() {
        return new ArrayList<LightPath>(this.lightPathExcitationFilterLinks);
    }

    public LightPath getLinkedLightPathExcitationFilter(int index) {
        return this.lightPathExcitationFilterLinks.get(index);
    }

    public LightPath setLinkedLightPathExcitationFilter(int index, LightPath o) {
        return this.lightPathExcitationFilterLinks.set(index, o);
    }

    public boolean linkLightPathExcitationFilter(LightPath o) {
        if (!this.lightPathExcitationFilterLinks.contains(o)) {
            return this.lightPathExcitationFilterLinks.add(o);
        }
        return false;
    }

    public boolean unlinkLightPathExcitationFilter(LightPath o) {
        return this.lightPathExcitationFilterLinks.remove(o);
    }

    public int sizeOfLinkedLightPathEmissionFilterList() {
        return this.lightPathEmissionFilterLinks.size();
    }

    public List<LightPath> copyLinkedLightPathEmissionFilterList() {
        return new ArrayList<LightPath>(this.lightPathEmissionFilterLinks);
    }

    public LightPath getLinkedLightPathEmissionFilter(int index) {
        return this.lightPathEmissionFilterLinks.get(index);
    }

    public LightPath setLinkedLightPathEmissionFilter(int index, LightPath o) {
        return this.lightPathEmissionFilterLinks.set(index, o);
    }

    public boolean linkLightPathEmissionFilter(LightPath o) {
        if (!this.lightPathEmissionFilterLinks.contains(o)) {
            return this.lightPathEmissionFilterLinks.add(o);
        }
        return false;
    }

    public boolean unlinkLightPathEmissionFilter(LightPath o) {
        return this.lightPathEmissionFilterLinks.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Filter_element) {
        if (Filter_element == null) {
            Filter_element = document.createElementNS(NAMESPACE, "Filter");
        }
        if (this.filterWheel != null) {
            Filter_element.setAttribute("FilterWheel", this.filterWheel.toString());
        }
        if (this.type != null) {
            Filter_element.setAttribute("Type", this.type.toString());
        }
        if (this.id != null) {
            Filter_element.setAttribute("ID", this.id.toString());
        }
        if (this.transmittanceRange != null) {
            Filter_element.appendChild(this.transmittanceRange.asXMLElement(document));
        }
        if (this.instrument != null) {
            // empty if block
        }
        if (this.filterSetExcitationFilterLinks != null) {
            // empty if block
        }
        if (this.filterSetEmissionFilterLinks != null) {
            // empty if block
        }
        if (this.lightPathExcitationFilterLinks != null) {
            // empty if block
        }
        if (this.lightPathEmissionFilterLinks != null) {
            // empty if block
        }
        return super.asXMLElement(document, Filter_element);
    }
}

