/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.AbstractStorageProcessor;
import ch.systemsx.cisd.etlserver.AbstractStorageProcessorTransaction;
import ch.systemsx.cisd.etlserver.DispatcherStorageProcessor;
import ch.systemsx.cisd.etlserver.FileRenamer;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.etlserver.utils.Unzipper;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class DefaultStorageProcessor
extends AbstractStorageProcessor
implements DispatcherStorageProcessor.IDispatchableStorageProcessor {
    public static final String ORIGINAL_DIR = "original";
    static final String NO_RENAME = "Couldn't rename '%s' to '%s'.";
    static final String UNZIP_CRITERIA_KEY = "unzip";
    static final String DELETE_UNZIPPED_KEY = "delete_unzipped";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DefaultStorageProcessor.class);
    private final boolean unzip;
    private final boolean deleteUnzipped;

    public DefaultStorageProcessor(Properties properties) {
        super(properties);
        this.unzip = PropertyUtils.getBoolean(properties, UNZIP_CRITERIA_KEY, false);
        this.deleteUnzipped = PropertyUtils.getBoolean(properties, DELETE_UNZIPPED_KEY, true);
    }

    @Override
    public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters) {
        return new DefaultStorageProcessorTransaction(parameters, this);
    }

    public static File getOriginalDirectory(File storedDataDirectory) {
        return new File(storedDataDirectory, ORIGINAL_DIR);
    }

    @Override
    public boolean accepts(DataSetInformation dataSetInformation, File incomingDataSet) {
        return true;
    }

    protected static class DefaultStorageProcessorTransaction
    extends AbstractStorageProcessorTransaction {
        private static final long serialVersionUID = 1L;
        private final boolean unzip;
        private final boolean deleteUnzipped;
        protected final IStorageProcessorTransactional.UnstoreDataAction unstoreDataAction;

        public DefaultStorageProcessorTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters, DefaultStorageProcessor processor) {
            super(parameters);
            this.unzip = processor.unzip;
            this.deleteUnzipped = processor.deleteUnzipped;
            this.unstoreDataAction = processor.getDefaultUnstoreDataAction(null);
        }

        @Override
        protected File executeStoreData(ITypeExtractor typeExtractor, IMailClient mailClient) {
            DefaultStorageProcessor.checkParameters(this.incomingDataSetDirectory, this.rootDirectory);
            File originalDir = DefaultStorageProcessor.getOriginalDirectory(this.rootDirectory);
            if (!originalDir.mkdir()) {
                throw new EnvironmentFailureException("Couldn't create " + originalDir.getAbsolutePath());
            }
            File targetFile = new File(originalDir, this.incomingDataSetDirectory.getName());
            if (!FileRenamer.renameAndLog(this.incomingDataSetDirectory, targetFile)) {
                throw new EnvironmentFailureException(String.format(DefaultStorageProcessor.NO_RENAME, this.incomingDataSetDirectory, targetFile));
            }
            this.storedDataDirectory = this.rootDirectory;
            this.unzipIfMatching(targetFile, originalDir);
            return this.rootDirectory;
        }

        @Override
        protected void executeCommit() {
        }

        @Override
        protected IStorageProcessorTransactional.UnstoreDataAction executeRollback(Throwable ex) {
            if (this.storedDataDirectory == null) {
                this.storedDataDirectory = this.rootDirectory;
            }
            DefaultStorageProcessor.checkParameters(this.incomingDataSetDirectory, this.storedDataDirectory);
            File targetFile = new File(DefaultStorageProcessor.getOriginalDirectory(this.storedDataDirectory), this.incomingDataSetDirectory.getName());
            FileRenamer.renameAndLog(targetFile, this.incomingDataSetDirectory);
            try {
                FileUtils.deleteDirectory((File)this.storedDataDirectory);
            }
            catch (IOException iOException) {
                String message = String.format("Failed to remove stored directory '%s'. In the future the creation of a data set with the same code will fail. To fix the problem remove the directory manually.", new Object[0]);
                operationLog.warn((Object)message);
            }
            return this.unstoreDataAction;
        }

        @Override
        public File tryGetProprietaryData() {
            File originalDir = DefaultStorageProcessor.getOriginalDirectory(this.storedDataDirectory);
            List<File> files = FileUtilities.listFilesAndDirectories(originalDir, false, null);
            if (files.size() != 1) {
                throw EnvironmentFailureException.fromTemplate("Exactly one file expected in '%s' directory, but %d found.", originalDir.getPath(), files.size());
            }
            return files.get(0);
        }

        protected Status unzipIfMatching(File archiveFile, File outputDirectory) {
            if (this.unzip && DefaultStorageProcessor.isZipFile(archiveFile)) {
                return Unzipper.unzip(archiveFile, outputDirectory, this.deleteUnzipped);
            }
            return Status.OK;
        }
    }
}

